{$mode delphi}
{$longstrings on}
{$appmode console}


program fromto;
uses sysutils, strings, Classes, IniFiles;

var 
  f: text;
  s, s2: string;
  i, n: integer;
  hext: string = '.shtml';

Const
  MaxRep = 12;
  Rep: array [0..MaxRep, 0..1] of string = (
    ('<','{{'),
    ('>','}}'),
    ('&lt;','<'),
    ('&gt;','>'),
    ('&mdash;',#$97),
    ('&ndash;',#$96),
    ('&laquo;',#$AB),
    ('&raquo;',#$BB),
    ('&ldquo;',#$84),
    ('&rdquo;',#$94),
    ('&nbsp;',#$B7),
    (#$0D#$0A, '//line break//'),
    (' ', #$A4)

);

  MaxToRep = 14;
  ToRep: array [0..MaxToRep, 0..1] of string = (
    ('<p>', #$0D#$0A),
    ('</p>',''),
    ('<','{{'),
    ('>','}}'),
    ('&lt;','<'),
    ('&gt;','>'),
    ('&mdash;',#$97),
    ('&ndash;',#$96),
    ('&laquo;',#$AB),
    ('&raquo;',#$BB),
    ('&quot;','"'),
    ('&ldquo;',#$84),
    ('&rdquo;',#$94),
    ('&nbsp;',#$B7),
    (' LANG="ru-RU"','')

);

function Replace(u, a, b: string): string;
var p: integer;
    s: String;
begin
  s:=u;
  p:=Pos(a, s);
  While p > 0 do begin
    s:=COPY(s, 1, p - 1) + b + COPY(s, p + Length(a), Length(s));
    p:=Pos(a, s);
  end;
  Result:=s;
end;

procedure Totxt(filename: string);
var
  s, s2: string;
  i, n, j: integer;
  L: TStringList;
  lfirst, llast: integer;
begin
  Write( 'TOtxt ... ');
  filename:= ChangeFileExt(filename, hext);
  L:=TStringList.Create;
  L.LoadFromFile(filename);
  s:='';
  j:=0;
  While (j < L.Count - 1) and (pos('<P', UpperCase(L[j])) <= 0) do begin
    L[j]:=Replace(L[j], ' ', #$A4) + '//line break//';
    inc(j);
    lfirst:=j + 1;
  end;
  j:=L.Count - 2;
  While (j > 0) and (pos('/P>', UpperCase(L[j])) <= 0) do begin
    L[j]:=Replace(L[j], ' ', #$A4) + '//line break//';
    dec(j);
    llast:=j - 1;
  end;
  s:=L[0];
  For j:=1 to L.Count - 1 do begin
    if (j >= lfirst) and (j<=llast) then s:=s + ' ';
    s:=s + Trim(L[j]);
  end;

  For i:=0 to MaxToRep do begin
    s:=Replace(s, ToRep[i,0], ToRep[i,1]);
    s:=Replace(s, UpperCase(ToRep[i,0]), ToRep[i,1]);
  end;

  L.Clear;
  L.Add(s);
  L.SaveToFile(ChangeFileExt(filename, '.txt'));
  L.Free;

  WriteLn('OK  ^_^');
end;

procedure Fromtxt(filename: string);
var
  L:TStringList;
  i: integer;
begin
  Write( 'FROMtxt ... ');
  
  L:=TStringList.Create;
  L.LoadFromFile(ChangeFileExt(filename, '.txt'));
  
  s:=L[0];
  for i:=1 to L.Count - 1 do
    s:=s + '{{/p}}{{p}}' + Trim(L[i]);

  For i:=MaxRep downto 0 do
    s:=Replace(s, Rep[i,1], Rep[i,0]);

  L.Clear;
  L.Add(s);
  L.SaveToFile(ChangeFileExt(filename, hext));
  AssignFile(f, filename);
  WriteLn('OK  ^_^');
end;

Procedure Process(filename: string);
var
  ah, at: longint;
  nh, nt: string;
begin
  Write(ChangeFileExt(filename, ''), ' ... ');
  nh:=ChangeFileExt(ExtractFilePath(ParamStr(0)) + '../' + filename, hext);
  if not FileExists(nh)
    then nh:=ChangeFileExt(ExtractFilePath(ParamStr(0)) + filename, hext);
  if FileExists(nh) then ah:=FileAge(nh) else ah:=0;

  nt:=ChangeFileExt(ExtractFilePath(ParamStr(0)) + '../' + filename, '.txt');
  if not FileExists(nt)
    then nt:=ChangeFileExt(ExtractFilePath(ParamStr(0)) + filename, '.txt');
  if FileExists(nt) then at:=FileAge(nt) else at:=0;
  
  if (at = 0) and (ah = 0) then raise(Exception.Create(format(
    'Not .txt nor %s file is present!', [hext])));
    
  if ah > at then ToTxt(nh);
  if ah < at then FromTxt(nt);
  if ah = at then Writeln('Dates are identic.')
end;

var
  ini: TIniFile;
  name: string;
begin
  ini:=TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
  hext:=ini.ReadString('Options','HtmlExtension', hext);

  For n:=1 to ini.ReadInteger('Job', 'Count', 0) do begin
    Try 
      name:=ini.ReadString('Job', 'Name' + IntToStr(n), '');
      if name='' then raise(Exception.Create(format('[Job]->name%d not set!',[n])));
      Process(name);


    Except
      WriteLn('ERROR!  >_<');;
      WriteLn((ExceptObject as Exception).Message);
      WriteLn('Press Enter to continue.');
      ReadLn;
    End;
  end;
  WriteLn; WriteLn;
  Writeln('Job''s done. ^_^');
  WriteLn('Press Enter to close.');
  readln;
  ini.Free;
end.
