{
    This file is part of the chelinfo library.

    Copyright (c) 2008 by Anton Rzheshevski
    Parts (c) 2006 Thomas Schatzl, member of the FreePascal
    Development team
    Parts (c) 2000 Peter Vreman (adapted from original stabs line
    reader)

    Dwarf LineInfo Extractor

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
{
    2008, Anton Rzheshevski aka Cheb:
    Like dr. Frankenshtein I sewn this library together
    from the dead meat of the the FPC RTL modules
    lineinfo.pp and lnfodwrf.pp.
    These as of Jan. 2008 / FPC 2.2.0 both didn't work
    and had several limitations (e.g. inability to be used
    from a DLL)
    
}
{$mode delphi}
{$longstrings on}

{$ifndef cpu32}
  {$fatal 64 bit formats not supported}
{$endif}
{$ifndef endian_little}
  {$fatal powerpc architecture not supported}
{$endif}
{
    You can, I presume, easily adapt this thing to 64-bits
    by borrowing from the same sources: lineinfo.pp
    and lnfodwrf.pp of the FreePascal RTL.
    I didn't, because there is no way for me to debug it.
    I use only the 32-bit OSes
}
   

unit un_xtrctdwrflnfo;


interface
  uses SysUtils, Classes, zstream;

  function ExtractDwarfLineInfo(
    ExeFileName: ansistring; var _dlnfo: pointer; var _dlnfoSize: integer;
    var Imagebase: cardinal): longbool;
  {
  Reads the dwarf line info from an executable.
    In case of error, see ExtractDwarfLineInfoError for details.
  ImageBase is nil for unix DLLs
    in all other cases the value it receives must be substracted
    from the addresses in the dwarf line info (and then the real
    base address added, to account for the possible relocation)
  NOTE: currently in unix it is also NIL for the main executable,
    corresponding the GetModuleByAddr() in un_lineinfo
    also returning NIL as the base address for the main executable.
  }

  procedure BrutalStripFPC(ein, eout, dlnout: TStream; UseWriteLn: longbool);
  {
  This function strips *all* unnecessary info from an EXE/DLL file.
  It is more effective than the standard "strip" utility,
    which leaves untouched any sections it doesn't understand.
  Unfortunately, "strip" doesn't understand the dwarf debugging info at all,
    so it doesn't strip it at all, leaving tons of junk behind it!
  This procedure is designed specifically for the executables generated by FPC,
    it would likely mutilate the files created by other compilers
    beyond any repair.
  The dlnout stream receives the dwarf line info.
    It can be NIL, in which case the dwarf line info is just discarded,
  }


  procedure InjectLineInfo(ein, dliin, eout: TStream; UseWriteLn: longbool);
  {
  This function injects the (compressed) line info
    back into the stripped exe.
    Usage:
    1. BrutalStrip it
    2. UPX it
    3. InjectLineInfo
    -- now you got a maximum-compressed release-quality exe}

    
  function DlnNameByExename(exename: string): string;
  {generates file names with .dwrlnfo extension.
     For unix, gives .elf.drwlnfo if the source name
     has no extension (as most executables do).
   Use in cases when both your windows and linux binaries are placed
     in the same folder }
  
  var
    ExtractDwarfLineInfoError: WideString = '';
    
    

implementation

const
  //sections to leave in the PE executable
  PeNecessary: array [0..9] of string =
    ('.text','.data','.bss','.idata','.edata', '.rdata', '.rsrc', '.reloc', 'CODE', 'DATA');
  PEDlin: string = '/30';
  ZPEDlin: string = 'Zdblinfo';
  ELFDlin: string = '.debug_line';
  ZELFDlin: string = '.z_debug_line';

{$ioerrors on}

  function DlnNameByExename(exename: string): string;
  begin
    {$ifdef unix}
     if ExtractFileExt(exename) = ''
       then Result:= ChangeFileExt(exename, '.elf-zdli')
       else
    {$endif}
            Result:= ChangeFileExt(exename, '.zdli');
  end;

{$MACRO ON}

{define DEBUG_ADDLOG := AddLog} //needs Cheb's Game Engine's units to work
{$define DEBUG_ADDLOG := //}

{$packrecords c}

{ ELF Header structures types}
type
  Elf32_Half = Word;
  Elf64_Half = Word;
  { Types for signed and unsigned 32-bit quantities.   }
  Elf32_Word = DWord;
  Elf32_Sword = Longint;
  Elf64_Word = DWord;
  Elf64_Sword = Longint;
  { Types for signed and unsigned 64-bit quantities.   }
  Elf32_Xword = QWord;
  Elf32_Sxword = Int64;
  Elf64_Xword = QWord;
  Elf64_Sxword = Int64;
  { Type of addresses.   }
  Elf32_Addr = DWord;
  Elf64_Addr = QWord;
  { Type of file offsets.   }
  Elf32_Off = DWord;
  Elf64_Off = QWord;
  { Type for section indices, which are 16-bit quantities.   }
  Elf32_Section = Word;
  Elf64_Section = Word;
  { Type for version symbol information.   }
  Elf32_Versym = Elf32_Half;
  Elf64_Versym = Elf64_Half;
{ some constants from the corresponding header files }
const
  El_NIDENT = 16;
  { some important indices into the e_ident signature of an ELF file }
  EI_MAG0 = 0;
  EI_MAG1 = 1;
  EI_MAG2 = 2;
  EI_MAG3 = 3;
  EI_CLASS = 4;
  { the first byte of the e_ident array must be of this value }
  ELFMAG0 = $7f;
  { the second byte of the e_ident array must be of this value }
  ELFMAG1 = Byte('E');
  { the third byte of the e_ident array must be of this value }
  ELFMAG2 = Byte('L');
  { the fourth byte of the e_ident array must be of this value }
  ELFMAG3 = Byte('F');

  { the fifth byte specifies the bitness of the header; all other values are invalid }
  ELFCLASS32 = 1;
  ELFCLASS64 = 2;

  ELFCLASS = {$IFDEF CPU32}ELFCLASS32{$ENDIF}{$IFDEF CPU64}ELFCLASS64{$ENDIF};

type
   { The ELF file header.  This appears at the start of every ELF file, 32 bit version }
  TElf32_Ehdr = record
    e_ident : array[0..El_NIDENT-1] of Byte; { file identification }
    e_type : Elf32_Half; { file type }
    e_machine : Elf32_Half; { machine architecture }
    e_version : Elf32_Word; { ELF format version }
    e_entry : Elf32_Addr; { entry point }
    e_phoff : Elf32_Off; { program header file offset }
    e_shoff : Elf32_Off; { section header file offset }
    e_flags : Elf32_Word; { architecture specific flags }
    e_ehsize : Elf32_Half; { size of ELF header in bytes }
    e_phentsize : Elf32_Half; { size of program header entry }
    e_phnum : Elf32_Half; { number of program header entries }
    e_shentsize : Elf32_Half; { size of section header entry }
    e_shnum : Elf32_Half; { number of section header entry }
    e_shstrndx : Elf32_Half; { section name strings section index }
  end;

  { ELF32 Section header }
  TElf32_Shdr = record
    sh_name : Elf32_Word; { section name }
    sh_type : Elf32_Word; { section type }
    sh_flags : Elf32_Word; { section flags }
    sh_addr : Elf32_Addr; { virtual address }
    sh_offset : Elf32_Off; { file offset }
    sh_size : Elf32_Word; { section size }
    sh_link : Elf32_Word; { misc info }
    sh_info : Elf32_Word; { misc info }
    sh_addralign : Elf32_Word; { memory alignment }
    sh_entsize : Elf32_Word; { entry size if table }
  end;

  { The ELF file header.  This appears at the start of every ELF file, 64 bit version }
  TElf64_Ehdr = record
    e_ident : array[0..El_NIDENT-1] of Byte;
    e_type : Elf64_Half;
    e_machine : Elf64_Half;
    e_version : Elf64_Word;
    e_entry : Elf64_Addr;
    e_phoff : Elf64_Off;
    e_shoff : Elf64_Off;
    e_flags : Elf64_Word;
    e_ehsize : Elf64_Half;
    e_phentsize : Elf64_Half;
    e_phnum : Elf64_Half;
    e_shentsize : Elf64_Half;
    e_shnum : Elf64_Half;
    e_shstrndx : Elf64_Half;
  end;

  { ELF64 Section header }
  TElf64_Shdr = record
    sh_name : Elf64_Word;
    sh_type : Elf64_Word;
    sh_flags : Elf64_Xword;
    sh_addr : Elf64_Addr;
    sh_offset : Elf64_Off;
    sh_size : Elf64_Xword;
    sh_link : Elf64_Word;
    sh_info : Elf64_Word;
    sh_addralign : Elf64_Xword;
    sh_entsize : Elf64_Xword;
  end;

  TElf_Shdr = {$ifdef cpu32}TElf32_Shdr{$endif}{$ifdef cpu64}TElf64_Shdr{$endif};
  TElf_Ehdr = {$ifdef cpu32}TElf32_Ehdr{$endif}{$ifdef cpu64}TElf64_Ehdr{$endif};


  {$packrecords default}

var
  ExeFileName: ansistring;
  header : TElf_Ehdr;
  strtab_header : TElf_Shdr;
  cursec_header : TElf_Shdr;

  buf : array[0..20] of char;


type
  tdosheader = packed record
     e_magic : word;
     e_cblp : word;
     e_cp : word;
     e_crlc : word;
     e_cparhdr : word;
     e_minalloc : word;
     e_maxalloc : word;
     e_ss : word;
     e_sp : word;
     e_csum : word;
     e_ip : word;
     e_cs : word;
     e_lfarlc : word;
     e_ovno : word;
     e_res : array[0..3] of word;
     e_oemid : word;
     e_oeminfo : word;
     e_res2 : array[0..9] of word;
     e_lfanew : longint;
  end;
  tpeheader = packed record
     PEMagic : longint;
     Machine : word;
     NumberOfSections : word;
     TimeDateStamp : longint;
     PointerToSymbolTable : longint;
     NumberOfSymbols : longint;
     SizeOfOptionalHeader : word;
     Characteristics : word;
     Magic : word;
     MajorLinkerVersion : byte;
     MinorLinkerVersion : byte;
     SizeOfCode : longint;
     SizeOfInitializedData : longint;
     SizeOfUninitializedData : longint;
     AddressOfEntryPoint : longint;
     BaseOfCode : longint;
     BaseOfData : longint;
     ImageBase : longint;
     SectionAlignment : longint;
     FileAlignment : longint;
     MajorOperatingSystemVersion : word;
     MinorOperatingSystemVersion : word;
     MajorImageVersion : word;
     MinorImageVersion : word;
     MajorSubsystemVersion : word;
     MinorSubsystemVersion : word;
     Reserved1 : longint;
     SizeOfImage : longint;
     SizeOfHeaders : longint;
     CheckSum : longint;
     Subsystem : word;
     DllCharacteristics : word;
     SizeOfStackReserve : longint;
     SizeOfStackCommit : longint;
     SizeOfHeapReserve : longint;
     SizeOfHeapCommit : longint;
     LoaderFlags : longint;
     NumberOfRvaAndSizes : longint;
     DataDirectory : array[1..$80] of byte;
  end;
  tcoffsechdr=packed record
    name     : array[0..7] of char;
    vsize    : longint;
    rvaofs   : longint;
    datalen  : longint;
    datapos  : longint;
    relocpos : longint;
    lineno1  : longint;
    nrelocs  : word;
    lineno2  : word;
    flags    : longint;
  end;

var
  dosheader  : tdosheader;
  peheader   : tpeheader;
  coffsec    : tcoffsechdr;



  function cntostr(cn: pchar): string;
  var
    i: integer = 0;
  begin
    Result:='';
    repeat
      if cn^ = #0 then break;
      Result+= cn^;
      inc(i);
      inc(cn);
    until i = 8;
  end;



function ExtractDwarfLineInfo(
  ExeFileName: ansistring; var _dlnfo: pointer; var _dlnfoSize: integer;
  var Imagebase: cardinal): longbool;

var
  DwarfOffset : int64;
  DwarfSize : SizeInt;
  i : Integer;
  f, fo : TFileStream;
  IsExternal: boolean;
  IsCompressed: boolean = false;
  DC: TDecompressionStream;

begin
  DEBUG_ADDLOG('Reading dwarf line info from %0', [ExeFileName]);
  Result := false;

  f:= TFileStream.Create(ExeFileName, fmOpenRead or fmShareDenyNone);
  DwarfOffset:= -1;
  DwarfSize:= -1;

  {$ifdef unix}

    if (f.read(header, sizeof(header)) <> sizeof(header)) then begin
      ExtractDwarfLineInfoError:='Could not read the ELF header!';
      f.Free;
      Exit(false);
    end;

    { more paranoia checks }
    if ((header.e_ident[EI_MAG0] <> ELFMAG0) or (header.e_ident[EI_MAG1] <> ELFMAG1) or
      (header.e_ident[EI_MAG2] <> ELFMAG2) or (header.e_ident[EI_MAG3] <> ELFMAG3)) then begin
      ExtractDwarfLineInfoError:='Invalid ELF magic header.';
      f.Free;
      Exit(false);
    end;

    if (header.e_ident[EI_CLASS] <> ELFCLASS) then begin
      ExtractDwarfLineInfoError:='Invalid ELF header bitness.';
      f.Free;
      Exit(false);
    end;

    { seek to the start of section headers }

    { first get string section header }
    f.Position:= header.e_shoff + (header.e_shstrndx * header.e_shentsize);
    if (f.read(strtab_header, sizeof(strtab_header)) <> sizeof(strtab_header)) then begin
      ExtractDwarfLineInfoError:='Could not read string section header';
      f.Free;
      Exit(false);
    end;

    for i := 0 to (header.e_shnum-1) do begin
      f.Position:= header.e_shoff + (i * header.e_shentsize);
      if (f.Read(cursec_header, sizeof(cursec_header)) <> sizeof(cursec_header)) then begin
        ExtractDwarfLineInfoError:='Could not read next section header';
        f.Free;
        Exit(false);
      end;
      { paranoia TODO: check cursec_header.e_shentsize }

      f.Position:= strtab_header.sh_offset + cursec_header.sh_name;
      if (f.Read(buf, sizeof(buf)) <> sizeof(buf)) then begin
        ExtractDwarfLineInfoError:='Could not read section name';
        Exit(false);
      end;
      buf[sizeof(buf)-1] := #0;

      DEBUG_ADDLOG('This section is "%0", offset %1 size %2', [pchar(@buf[0]), cursec_header.sh_offset, cursec_header.sh_size]);
      if (pchar(@buf[0]) = ELFDlin) then begin
        DEBUG_ADDLOG(ELFDlin + ' section found');
        DwarfOffset := cursec_header.sh_offset;
        DwarfSize := cursec_header.sh_size;
        { more checks }
        DEBUG_ADDLOG(' offset %0,  size %1', [DwarfOffset, DwarfSize]);
        Result := (DwarfOffset >= 0) and (DwarfSize > 0);
        break;
      end;
      if (pchar(@buf[0]) = ZELFDlin) then begin
        DEBUG_ADDLOG(ZELFDlin + ' section found');
        DwarfOffset := cursec_header.sh_offset;
        DEBUG_ADDLOG(' offset %0', [DwarfOffset]);
        IsCompressed:= true;
        Result := (DwarfOffset >= 0);
        break;
      end;

    end;
    
    Imagebase:= 0;

 {$else}

    { read and check header }
    if f.Size < sizeof(dosheader) then begin
        ExtractDwarfLineInfoError:= 'Could not read the PE header';
        f.Free;
        Exit(false);
      end;
    f.Read(dosheader, sizeof(tdosheader));
    f.Position:= dosheader.e_lfanew;
    f.Read(peheader, sizeof(tpeheader));
    if peheader.pemagic<>$4550 then begin
        ExtractDwarfLineInfoError:= 'Not a valid Portable Executable';
        f.Free;
        Exit(false);
      end;
//writeln('--base, ', IntToHex(peheader.Imagebase,8));
      
    { read section info }
    for i:=1 to peheader.NumberOfSections do
     begin
       f.Read(coffsec, sizeof(tcoffsechdr));
       DEBUG_ADDLOG(coffsec.name);
//writeln(coffsec.name, '  ', coffsec.datalen);

       if cntostr(@coffsec.name) = PEDlin then begin
         DwarfOffset:= coffsec.datapos;
         DwarfSize:= coffsec.datalen;
         break;
       end;
       if cntostr(@coffsec.name) = ZPEDlin then begin
         DwarfOffset:= coffsec.datapos;
         IsCompressed:= true;
         break;
       end;

       
     end;
    Result:= (DwarfOffset > 0);
    ImageBase:= peheader.Imagebase;
    
 {$endif}
 
  if Result then begin
    if IsCompressed then begin
      f.Position:= DwarfOffset;
      DC:= TDecompressionStream.Create(f);
      DC.Read(DwarfSize, sizeof(DwarfSize));
      DC.Read(ImageBase, sizeof(ImageBase));
      _dlnfoSize:= DwarfSize;
      GetMem(_dlnfo, DwarfSize);
      DC.Read(_dlnfo^, DwarfSize);
      DC.Free;
    end
    else begin
      GetMem(_dlnfo, DwarfSize);
      _dlnfoSize:= DwarfSize;
      f.Position:= DwarfOffset;
      f.Read(_dlnfo^, DwarfSize);
    end;
  end
  else
    ExtractDwarfLineInfoError:=
    {$ifdef unix}
      'The line info section not found in the ELF file.'
    {$else}
      'The line info section not found in the PE file.'
    {$endif}
    ;
  f.Free;
end;

  function align(addr, alignment: cardinal): cardinal;
  begin
    if addr = 0
      then result:=0
      else result:=(((addr - 1) div alignment) + 1) * alignment;
  end;
  
  function strpaddr(a: string; l: integer): string;
  begin
    result:=a;
    if l <= length(a) then exit;
    setlength(result, l);
    fillchar(result[length(a) + 1], l - length(a), 32);
  end;

  function strpaddl(a: string; l: integer): string;
  begin
    if l <= length(a) then exit(a);
    SetLength(result, l - length(a));
    fillchar(result[1], length(result), 32);
    result+= a;
  end;



  procedure BrutalStripFPC(ein, eout, dlnout: TStream; UseWriteLn: longbool);
  var
    elfid: string[4];
    zero: byte = 0;
    ct, cofftable: array of tcoffsechdr;
    necessary: array of boolean;
    i, j, n, sectpos, rmv: integer;
    dlil: integer = 0;
    p: pointer;
    ib: cardinal;
    CS: TCompressionStream;
    procedure advanceOut(pos: integer);
    begin
      if eout.size >= pos then eout.position:=pos
      else begin
        eout.position:= eout.size;
        repeat eout.write(zero, 1) until eout.size = pos;
      end;
    end;
  begin
    ExtractDwarfLineInfoError:= '';
    ein.position:=0;
    eout.position:=0;
    ein.read(elfid[1], 4);
    if elfid = #$7f'ELF' then begin
      ExtractDwarfLineInfoError:=('ELF format isn''t supported yet!');
      eout.CopyFrom(ein, ein.size);
//************************************** ДОДЕЛАТЬ!!!!!!!!!!!!!!!!!!!!!!!!
    end
    else begin
      ein.position:= 0;
      ein.Read(dosheader, sizeof(tdosheader));
      //removing the DOS crap:
      dosheader.e_lfarlc:=0;
      ein.position:= dosheader.e_lfanew;
      ein.Read(peheader, sizeof(peheader));
      if peheader.pemagic<>$4550 then begin
        ExtractDwarfLineInfoError:= 'Not a valid Portable Executable';
        Exit;
      end;
      
      SetLength(ct, peheader.NumberOfSections);
      SetLength(necessary, peheader.NumberOfSections);
      ein.read(ct[0], length(ct) * sizeof(tcoffsechdr));

      peheader.NumberOfSections:= 0;
      rmv:=0;
      
      for i:=0 to high(ct) do begin
        Necessary[i]:=false;
        for n:=0 to high(PENecessary)
          do Necessary[i]:= Necessary[i] or (cntostr(@ct[i].name[0]) = PENecessary[n]);
        if UseWriteLn then write('   ',
          strpaddr(cntostr(@ct[i].name[0]), 8), ' ',
          strpaddl(inttostr(ct[i].datalen div 1024), 4), 'K'
//,' flags', inttohex(ct[i].flags,8),' vsize:', ct[i].vsize,' rvaofs:',ct[i].rvaofs

          );
        if necessary[i] then inc(peheader.NumberOfSections)
        else begin
          if Assigned(dlnout) and (cntostr(@ct[i].name[0]) = pedlin)
          then begin
            dlil:= ct[i].datalen;
            if UseWriteLn then write(' - EXTRACTED');
            dlnout.position:= 0;
            ein.position:= ct[i].datapos;
            CS:= TCompressionStream.Create(clMax, dlnout);
            CS.write(ct[i].datalen, 4);
            CS.write(peheader.ImageBase, 4);
            CS.CopyFrom(ein, ct[i].datalen);
            CS.Free;
          end
          else
            if UseWriteLn then write(' - removed');
          inc(rmv, ct[i].datalen);
        end;
        writeln;
      end;
      
      // copying everything up to the PE header;
      ein.Position:=0;
      eout.position:=0;
      eout.CopyFrom(ein, dosheader.e_lfanew);

      
      eout.write(peheader, sizeof(peheader)); //solely to update the number of sections.
      
      sectpos:= eout.position;
      
      advanceOut(eout.position + (peheader.NumberOfSections * sizeof(tcoffsechdr)));

      for i:=0 to high(ct) do begin
        if not Necessary[i] then continue; //skip this unfortunate section
        SetLength(cofftable, length(cofftable) + 1);

        //add this section to the output file
        cofftable[high(cofftable)]:= ct[i];
        ein.position:= ct[i].datapos;
        
       if ct[i].datalen > 0 then begin
          advanceOut(align(eout.position, peheader.FileAlignment));
          cofftable[high(cofftable)].datapos:= eout.position;
          eout.CopyFrom(ein, ct[i].datalen);
        end;
//with cofftable[high(cofftable)] do writeln(' --> ', cntostr(@name[0]), '  len= ', datalen, '  pos=',datapos);

      end;

      //with all the politically reliable sections written
      // we can write the section table.
      eout.position:= sectpos;
      eout.write(cofftable[0], length(cofftable) * sizeof(tcoffsechdr));
      if UseWriteLn then begin
        WriteLn('  total crap count: ', rmv div 1024,'K');
        WriteLn('  line info: ', dlil div 1024,'K, compressed to ',dlnout.size div 1024,'K');
      end;
    end;
  end;
  
  
  procedure InjectLineInfo(ein, dliin, eout: TStream; UseWriteLn: longbool);
  var
    elfid: string[4];
    zero: byte = 0;
    ct: array of tcoffsechdr;
    i, j, n, sectpos, rmv: integer;
    dlil: integer = 0;
    p: pointer;
    ib, maxrva, maxrvl : cardinal;
    procedure advanceOut(pos: integer);
    begin
      if eout.size >= pos then eout.position:=pos
      else begin
        eout.position:= eout.size;
        repeat eout.write(zero, 1) until eout.size = pos;
      end;
    end;
  begin
    ExtractDwarfLineInfoError:= '';
    ein.position:=0;
    eout.position:=0;
    ein.read(elfid[1], 4);
    if elfid = #$7f'ELF' then begin
      ExtractDwarfLineInfoError:=('ELF format isn''t supported yet!');
      eout.CopyFrom(ein, ein.size);
//************************************** ДОДЕЛАТЬ!!!!!!!!!!!!!!!!!!!!!!!!
    end
    else begin
      ein.position:= 0;
      ein.Read(dosheader, sizeof(tdosheader));
      //removing the DOS crap:
      dosheader.e_lfarlc:=0;
      ein.position:= dosheader.e_lfanew;
      ein.Read(peheader, sizeof(peheader));
      if peheader.pemagic<>$4550 then begin
        ExtractDwarfLineInfoError:= 'Not a valid Portable Executable';
        Exit;
      end;

      SetLength(ct, peheader.NumberOfSections);
      ein.read(ct[0], length(ct) * sizeof(tcoffsechdr));
      SetLength(ct, length(ct) + 1);

      peheader.NumberOfSections:= length(ct);

      // copying everything up to the PE header;
      ein.Position:=0;
      eout.position:=0;
      eout.CopyFrom(ein, dosheader.e_lfanew);

      eout.write(peheader, sizeof(peheader)); //solely to update the number of sections.

      sectpos:= eout.position;

      advanceOut(eout.position + (peheader.NumberOfSections * sizeof(tcoffsechdr)));

      maxrva:=0;
      for i:=0 to high(ct) - 1 do begin
        ein.position:= ct[i].datapos;
        if ct[i].datalen > 0 then begin
          advanceOut(align(eout.position, peheader.FileAlignment));
          ct[i].datapos:= eout.position;
          eout.CopyFrom(ein, ct[i].datalen);
          if ct[i].rvaofs > maxrva then maxrva:= ct[i].rvaofs + ct[i].vsize;
        end;
      end;
      FillChar(ct[high(ct)], sizeof(tcoffsechdr), 0);
      with ct[high(ct)] do begin
        datalen:= dliin.Size;
        advanceOut(align(eout.position, peheader.FileAlignment));
        datapos:= eout.position;
        dliin.position:=0;
        eout.CopyFrom(dliin, datalen);
        move(ZPEDlin[1], name[0], 8);
        flags:= $02100800; //do not load
        rvaofs:=align(maxrva, peheader.SectionAlignment);
//        peheader.
      end;
      
      if UseWriteln then
        for i:=0 to high(ct) do
          WriteLn('   ',
            strpaddr(cntostr(@ct[i].name[0]), 8), ' ',
            strpaddl(inttostr(ct[i].datalen div 1024), 4), 'K'
            //,' pos', strpaddl(inttostr(ct[i].datapos), 7)
            );


      // write the section table.
      eout.position:= sectpos;
      eout.write(ct[0], length(ct) * sizeof(tcoffsechdr));
    end;
  end;


end.
