{
    This file is part of the chelinfo library.

    Copyright (c) 2008 by Anton Rzheshevski

    Dwarf LineInfo Extractor

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
{
    2008, Anton Rzheshevski aka Cheb:
    Like dr. Frankenshtein I sewn this library together
    from the dead meat of the the FPC RTL modules
    lineinfo.pp and lnfodwrf.pp.
    These (as of Jan. 2008 / FPC 2.2.0) both didn't work
    and had several limitations (e.g. inability to be used
    from a DLL)

    }

{$ifndef unix}
  {$apptype console}
{$endif}
{$undef cge}
program brutalstrip;
uses
  Classes, SysUtils, un_lineinfo, un_xtrctdwrflnfo;


var
  fname, f2name: string;
  m: TMemoryStream;
  f,f2: TStream;

begin
  InitLineInfo(nil);
  fname:= ParamStr(1);
  if fname = '' then begin
    WriteLn('Usage: brutalstrip <executable file name> [-dontwrite]');
    halt(0);
  end;
  f:= TFileStream.Create(fname, fmOpenRead);
  m:= TMemoryStream.Create;
  m.CopyFrom(f, f.size);
  f.free;
  m.position:=0;
  if LowerCase(ParamStr(2)) = '-dontwrite'
    then f:= TMemoryStream.Create
    else f:= TFileStream.Create(fname, fmCreate);
  f2:= TFileStream.Create(DlnNameByExename(fname), fmCreate);
  WriteLn('Brutally stripping ', fname);
  BrutalStripFPC(m, f, f2, true);
  m.Free;
  f.Free;
  f2.free;
  if ExtractDwarfLineInfoError <> '' then begin
    WriteLn(ExtractDwarfLineInfoError);
    Halt(1);
  end;
end.

