unit cheb_facelift_gl;

interface
uses
  SysUtils, Windows, Classes,  OpenGL, qgl_win, math, ref;

var
  cflVWidth,
  cflVHeight,
  cflQWidth,
  cflQHeight: integer;
  cflRTexture, cflParticleTexture: cardinal;
  cflInWater,
  cflDontWarp,
  cflIsSky,
  cflPixellate : boolean;

const
  cflTWidth = 512;
  cflTHeight = 512;
  WXSpeed = 0.6;
  WYSpeed = 0.6;
  WXBSpeed = 3.0;
  WYBSpeed = 3.0;

  WXamplitude = 0.015;
  WYamplitude = 0.02;

  WXBamplitude = 0.003;
  WYBamplitude = 0.003;
  WfShift = 17.0;
  WBfShift = 9.0;

procedure Cheb_Facelift_Init();
procedure Cheb_Facelift_Warp();
procedure Cheb_Facelift_PrepareRT();



implementation

uses
  gl_rmain;

var
  CTW, CTH: integer;
  LQ: boolean;

const
  ted = 0.003;//1/1024;//0.5 / (1.0* cfltwidth);
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = $83F2;

procedure Cheb_Facelift_Init();
var
  t: array[-16..15, -16..15] of byte;
  x, y: integer;
begin
  qGLGenTextures(1, @cflRTexture);
  qglEnable(GL_TEXTURE_2D);
  qglBindTexture(GL_TEXTURE_2D, cflRTexture);
  qglTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  qglTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  //create an the empty texture:
  qglTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, cflTWidth, cflTHeight, 0, GL_RGB, GL_UNSIGNED_BYTE, nil);

  qGLGenTextures(1, @cflParticleTexture);
  qglBindTexture(GL_TEXTURE_2D, cflParticleTexture);
  qglTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  qglTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  for x:=-16 to 15 do
    for y:=-16 to 15 do
      t[x,y]:=min(255, max(0,  Trunc(255 * (1.0 - sqr(abs(x) /14) - sqr(abs(y) / 14)))));
  qglTexImage2D(GL_TEXTURE_2D, 0, GL_ALPHA,
     32, 32, 0, GL_ALPHA, GL_UNSIGNED_BYTE, @t);
end;


procedure Cheb_Facelift_PrepareRT();
begin
  CTW:=cfltwidth;
  CTH:=cfltheight;
  LQ:=(Trunc(gl_picmip^.Value) > 1);
  if (CTH > cflvheight) or LQ then CTH:=CTH div 2;
  
  qglViewport(0, 0, CTW, CTH);
end;


procedure Cheb_Facelift_Warp();
var
 PhaseX, PhaseY: single;
 wdx, wdy: array [0..33, 0..33] of single;
 x, y, i: integer;
 fx, fy: single;
begin
  if not cflInWater then Exit;

  qglEnable(GL_TEXTURE_2D);
  qglBindTexture(GL_TEXTURE_2D, cflRTexture);
//                (target: TGLenum; level: TGLint; internalFormat: TGLenum; x, y: TGLint; width, height: TGLsizei; border: TGLint); stdcall;
//  qglCopyTexSubImage2D: procedure(target: TGLenum; level, xoffset, yoffset, x, y: TGLint; width, height: TGLsizei); stdcall;
  qglCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, CTW, CTH);

//  qglCopyTexImage2d(GL_TEXTURE_2D, 0,GL_RGB,0,0, cfltwidth,cfltheight,0);
  // set 2D virtual screen size
  qglDisable(GL_DEPTH_TEST);
  qglDisable(GL_CULL_FACE);
  qglDisable(GL_LIGHTING);

  qglBindTexture(GL_TEXTURE_2D, cflRTexture);

  if not LQ then begin // BLUR!
    qglColor4f(1, 1, 1, 0.5);
    qglViewport(0, 0, CTW, CTH);
    qglMatrixMode(GL_PROJECTION);
    qglLoadIdentity();
    qglMatrixMode(GL_MODELVIEW);
    qglLoadIdentity();
    qglOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
    qglEnable(GL_BLEND);
    qglAlphaFunc(GL_GREATER, 0.0);

    PhaseX:= r_newrefdef.time * WXBSpeed;
    PhaseY:= r_newrefdef.time * WYBSpeed;
    for i:=-1 to 1 do
      if i <> 0 then begin
        For x:=0 to 32 do
          For y:=0 to 32 do begin
            wdx[x, y]:=x / 32 + i * WXBAmplitude * sin(PhaseX + (x/32)*WBfshift);
            wdy[x, y]:=(CTH/cfltheight) * (y / 32 + i * WYBAmplitude * cos(PhaseY + (y/32)*WBfshift));
          end;
    // blur it
        if i =1 then  qglColor4f(1, 1, 1, 0.33);

        qglBegin(GL_QUADS);
        For x:=0 to 31 do
          For y:=0 to 31 do begin
          qglTexCoord2f(wdx[x,y], wdy[x,y]); //bottom left corner
          qglVertex2f(x/32, y/32);
          qglTexCoord2f(wdx[x,y+1], wdy[x,y+1]);
          qglVertex2f(x/32, (y +1)/32);
          qglTexCoord2f(wdx[x+1,y+1], wdy[x+1,y+1]);
          qglVertex2f((x+1)/32,(y+1)/32);
          qglTexCoord2f(wdx[x+1,y], wdy[x+1,y]);
          qglVertex2f((x+1)/32, y/32);
          end;
        qglEnd;
      end;
    qglCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, CTW, CTH div 2);
  end;

  PhaseX:= r_newrefdef.time * WXSpeed;
  PhaseY:= r_newrefdef.time * WYSpeed;
  For x:=0 to 33 do
    For y:=0 to 33 do begin
      fx:= - WXamplitude + x * ((1 + 2 * WXamplitude)/32);
      fy:= - WYamplitude + y * ((1 + 2 * WYamplitude)/32);
      wdx[x, y]:=fx + WXAmplitude * sin(PhaseX + fx*Wfshift);
      wdy[x, y]:=fy + WYAmplitude * cos(PhaseY + fy*Wfshift);
    end;

//finally render the warped scene
  qglColor4f(1, 1, 1, 1);
  qglDisable(GL_BLEND);
  qglViewport(0, 0, cflvwidth, cflvheight);//vid.width, vid.height);
  qglMatrixMode(GL_PROJECTION);
  qglLoadIdentity();
  qglMatrixMode(GL_MODELVIEW);
  qglLoadIdentity();
  qglOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);


  qglBegin(GL_QUADS);
  For x:=0 to 32 do
    For y:=0 to 32 do begin
     qglTexCoord2f(x/32, y*(CTH/cfltheight)/32);
     qglVertex2f(wdx[x,y], wdy[x,y]); //bottom left corner
     qglTexCoord2f(x/32, (y +1)*(CTH/cfltheight)/32);
     qglVertex2f(wdx[x,y+1], wdy[x,y+1]);
     qglTexCoord2f((x+1)/32,(y+1)*(CTH/cfltheight)/32);
     qglVertex2f(wdx[x+1,y+1], wdy[x+1,y+1]);
     qglTexCoord2f((x+1)/32, y*(CTH/cfltheight)/32);
     qglVertex2f(wdx[x+1,y], wdy[x+1,y]);
    end;
  qglEnd;
end;


end.
