{
    This file is part of the ChebLib library,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains string handling routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{$mode delphi}

unit cl_strings;
interface
  uses SysUtils;

Type Chars = Set of char;

Const
  RussianChars: Chars = [''..'', ''..'', '', ''];
  CyrillicChars: Chars = [''..'', ''..'', '', '', '', '', '', '',
                          '', '', '', '', '', '', '', '', '', '',
                          '', '', '', '', '', '', '', '', '', '',
                          '', '', '', ''];
  LatinChars: Chars = ['A'..'Z', 'a'..'z'];
  NumberChars: Chars = ['0'..'9'];
  ASCIISafeChars = [' '..'~'];

procedure WriteRu(s: string);
procedure WriteLnRu(s: string);
Function Translit(source: string): string;

Function PCharToStr(P:PChar):string;
Function RanStr(s: string):string; //separator = '~'
function UpCase(h: char): char;
function LowCase(h: char): char;
//Function NumParm(s:string; n:integer):integer;

Function StrParm(s:string; n:integer{0..}; sep: Chars):string;


Function StrDelSet(s:string;c:chars):string;
Function StrFilter(s:string;c:chars):string;

Function StrUpLett(s:string):string;
Function StrUpFirst(s: string): string;
Function StrLowLett(s:string):string;

Function StrDelAllSp(S:string):string;
Function StrCut (S:string;K:integer ):string;

Function StrSupplRight(S:string;K:integer;c:char ):string;
Function StrSupplLeft(S:string;K:integer;c:char ):string;

Function StrRepeat (S:string;K: integer):string;
Function StrReplace (S, zamenjaemoe, zamenjajushee:string):string;

Function StrContPos (S,w:string): integer;

Function ParIs(s: string): BOOLean;

IMPLEMENTATION

  Function RanStr(s: string):string;
  var c :integer;
      EM: Array of string;
  begin
    SetLength(EM, 1);
    c:=0;
    Repeat
      inc(c);
      IF s[c]='~' then SetLength(EM, Length(EM) + 1)
                  else EM[Length(EM) - 1]:=EM[Length(EM) - 1]+S[c];
    Until c = Length(S);
    RanStr:=EM[Random(Length(EM))];
    SetLength(EM, 0);
  end;

Function StrDelAllSp;
  var c: integer;
      cus: string;
begin
  cus:='';
  For c:=1 to Length(S) do
    IF S[c] <> ' ' Then cus:=cus+S[c];
  StrDelAllSp:=cus;
end;

Function StrUpLett;
var n: integer;
begin
  For n:=1 to Length(s) do s[n]:=UpCase(s[n]);
  StrUpLett:=s
end;

Function StrUpFirst;
begin
  s[1]:=UpCase(s[1]);
  StrUpFirst:=s;
end;

Function StrLowLett;
var n: integer;
begin
  For n:=1 to Length(s) do s[n]:=LowCase(s[n]);
  StrLowLett:=s
end;

Function StrContPos;
var b,n:integer;
begin
  b:=Length(s)-Length(w)+1;
  repeat
    Dec(b); n:=-1;
    repeat
      Inc(n);
    until (s[b+n]<>w[n+1]) or( n=Length(w)-1)
  until (b=0) or (n=Length(w)-1);
  StrContPos:=b;
end;


Function StrCut ;
begin
  IF K<Length(S) then StrCut:=copy(s,1,K)
                 else StrCut:=s;
end;

Function StrRepeat;
  var cy:integer; cus:string;
begin
  cus:= '';
  FOR cy:=1 to K do
              IF (255-Length(cus))>=Length(s) then cus:=cus+s
              ELSE if Length(CUS)<255 then
                        cus:=cus+StrCut(s,255-Length(cus));
  StrRepeat := cus;
end;

Function StrReplace (S, zamenjaemoe, zamenjajushee: string): string;
var p: integer;
begin
  if s <> '' then begin
    p:=Pos(zamenjaemoe, s);
    While p > 0 do begin
      s:=COPY(s, 1, p - 1) + zamenjajushee + COPY(s, p + Length(zamenjaemoe), Length(s));
      p:=Pos(zamenjaemoe, s);
    end;
  end;
  Result:=s;
end;

Function StrDelSet;
var cy:integer;Ul:string;
begin
  ul:='';
  For Cy:=1 to length(s) do
           IF not(s[cy] in c) then ul:=ul+s[cy];
  StrDelSet:=ul;
end;

Function StrFilter;
var cy:integer;Ul:string;
begin
  ul:='';
  For Cy:=0 to length(s) do
           IF not(s[cy] in c) then ul:=ul+s[cy];
  StrFilter:=ul;
end;

Function StrSupplLeft;
begin
  if Length(s)<K Then
        StrSupplLeft:=S+StrRepeat(c,k-Length(s))
  else StrSupplLeft:=s;
end;

Function StrSupplRight;
begin
  if Length(s)<K Then
        StrSupplRight:=StrRepeat(c,k-Length(s))+S
  else StrSupplRight:=s;
end;

{Function NumParm(s:string;n:integer):integer;
var st: string;
    i,j:integer;
begin
  st:=StrParm(s,n);
  VAL(st,i,j);
  NumParm:=i;
end;
}

Function StrParm;
var
  a: array of string;
  i: integer;
begin
  s:=StrReplace(StrDelSet(s,[#10]), #13, ' ');
  SetLength(a, 1);
  for i:=1 to Length(s) do begin
    if (s[i] in sep) then SetLength(a, Length(a) + 1)
                     else a[High(a)]:= a[High(a)] + s[i];
  end;
  if (n >= Low(a)) and (n <= High(a)) then Result:=Trim(a[n])
  else Result:='';
  SetLength(a, 0);
end;

Function ParIs(s: string): BOOLean;
var c: integer;
begin
  Result:=False;
  For c:=1 to ParamCount do
    If UpperCase(ParamStr(c))=UpperCase(s) then ParIs:=True;
end;

function UpCase(h: char): char;
begin
  Case h of
    'a'..'z': UpCase:=chr(ord(h)+(ord('Z')-ord('z')));
    ''..'': UpCase:=chr(ord(h)+(ord('')-ord('')));
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';
  else
    UpCase:=h;
  end;
end;

function LowCase(h: char): char;
begin
  Case h of
    'A'..'Z': LowCase:=chr(ord(h)+(ord('z')-ord('Z')));
    ''..'': LowCase:=chr(ord(h)+(ord('')-ord('')));
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';
  else
    LowCase:=h;
  end;
end;

Function PCharToStr(P:PChar):string;
begin
  Result:=Format('%P', [p]);
end;

Type TRusTrans = array [#$80..#$FF] of string;

Const RusTrans: TRusTrans = (
 {$ifdef linux}
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');  
 {$else}
  '?', '?', ',', '?', '"', '...', '?', '?', 'euro', '0/oo', '?', '<', '?', '?', '?', '?',
  '?', '''', '''', '"', '"', #249, '-', '-', '?', '(TM)', '?', '>', '?', '?', '?', '?',
  '', '', '', '', #253, '', '', '#', #240, '(C)', '', '<<', '-', '-', '(R)', '',
  #248, '', '', '', '', '', '', #250, #241, #252, '', '>>', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
 {$endif}
  

procedure WriteRu(s: string);
begin
  write(translit(s));
end;

procedure WriteLnRu(s: string);
begin
  writeLn(translit(s));
end;


Function Translit(source: string): string;
var i: integer;
begin
  Result:='';
 {$ifdef win32}
  if not parIs('-t') then
  For i:=1 to Length(source) do
     if source[i] in [#$80..#$ff] then Result:=Result + RusTrans[source[i]] 
                                  else Result:=Result + source[i]
  else
 {$endif}  //pod linuksom wsegda translitom...
    For i:=1 to Length(source) do
    Case source[i] of
      '': Result:=Result+'A';
      '': Result:=Result+'B';
      '': Result:=Result+'W';
      '': Result:=Result+'G';
      '': Result:=Result+'D';
      '': Result:=Result+'E';
      '': Result:=Result+'JO';
      '': Result:=Result+'ZH';
      '': Result:=Result+'Z';
      '': Result:=Result+'I';
      '': Result:=Result+'J';
      '': Result:=Result+'K';
      '': Result:=Result+'L';
      '': Result:=Result+'M';
      '': Result:=Result+'N';
      '': Result:=Result+'O';
      '': Result:=Result+'P';
      '': Result:=Result+'R';
      '': Result:=Result+'S';
      '': Result:=Result+'T';
      '': Result:=Result+'U';
      '': Result:=Result+'F';
      '': Result:=Result+'H';
      '': Result:=Result+'C';
      '': Result:=Result+'CH';
      '': Result:=Result+'SH';
      '': Result:=Result+'SHCH';
      '': Result:=Result+'6';
      '': Result:=Result+'Y';
      '': Result:=Result+'''';
      '': Result:=Result+'E';
      '': Result:=Result+'JU';
      '': Result:=Result+'JA';
      '': Result:=Result+'a';
      '': Result:=Result+'b';
      '': Result:=Result+'w';
      '': Result:=Result+'g';
      '': Result:=Result+'d';
      '': Result:=Result+'e';
      '': Result:=Result+'jo';
      '': Result:=Result+'zh';
      '': Result:=Result+'z';
      '': Result:=Result+'i';
      '': Result:=Result+'j';
      '': Result:=Result+'k';
      '': Result:=Result+'l';
      '': Result:=Result+'m';
      '': Result:=Result+'n';
      '': Result:=Result+'o';
      '': Result:=Result+'p';
      '': Result:=Result+'r';
      '': Result:=Result+'s';
      '': Result:=Result+'t';
      '': Result:=Result+'u';
      '': Result:=Result+'f';
      '': Result:=Result+'h';
      '': Result:=Result+'c';
      '': Result:=Result+'ch';
      '': Result:=Result+'sh';
      '': Result:=Result+'shch';
      '': Result:=Result+'6';
      '': Result:=Result+'y';
      '': Result:=Result+'''';
      '': Result:=Result+'e';
      '': Result:=Result+'ju';
      '': Result:=Result+'ja';
    else
      Result:=Result + source[i];
    end;
  end;



END.
