{
    This file is part of the ChebLib library,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains additional routines for handling classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


unit cl_Classes;

interface
  Uses SysUtils, Classes, cl_strings;

  Procedure SafeFree(o: TObject);
  
Type
  TStringListWithIDs = class (TStringList)
  private
    function _ReadId(i: integer): integer;
    procedure _WriteId(i, id: integer);
    function _ReadTextByOneLine: string;
  public
    Property ID[index: integer]: integer read _ReadId write _WriteId;
    Property TextByOneLine: string read _ReadTextByOneLine;
  end;

implementation

  Procedure SafeFree(o: TObject);
  begin
    Try
      if Assigned(o) then o.Free;
    Except End;
    //pointer(o):=nil;
  end;
  
  function TStringListWithIDs._ReadId(i: integer): integer;
  begin
    if i > Count - 1 then i:= Count - 1;
    Result:=integer(Objects[i]);
  end;
  
  procedure TStringListWithIDs._WriteId(i, id: integer);
  begin
    if i > Count - 1 then i:= Count - 1;
    Objects[i]:=TObject(id);
  end;

  function TStringListWithIDs._ReadTextByOneLine: string;
  begin
    Result:=Trim(StrReplace(StrDelSet(Text, [#10]), #13, ' '));
  end;

end.
