{   This file is part of the Automaton program,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains parts of code from "Kambi's images Pascal units"
      (Copyright 2002-2004 Michalis Kamburelis).

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************

 }

  procedure our_png_error_fn(png_ptr : png_structp; s : png_const_charp); cdecl;
  begin
    YellAndDie(' libpng     : '+s);
  end;

  procedure our_png_warning_fn(png_ptr : png_structp; s : png_const_charp); cdecl;
  begin
    WriteLn;
    WriteLnRu(' LibPng  : ' + s);
  end;

  procedure Check( condition: boolean; yell: string);
  begin
    if not Condition then Raise Exception.Create(yell);
  end;

  procedure our_png_write_fn(png_ptr:png_structp; data:png_bytep; len:png_size_t); cdecl;
  begin
    TFileStream(png_get_io_ptr(png_ptr)).WriteBuffer(data^, len);
  end;

  procedure our_png_read_fn(png_ptr:png_structp; data:png_bytep; len:png_size_t); cdecl;
  begin
    TStream(png_get_io_ptr(png_ptr)).ReadBuffer(data^, len);
  end;

  procedure our_png_flush_fn(png_ptr:png_structp); cdecl;
  begin
   {we would like to do here something like TStream(png_get_io_ptr(png_ptr)).Flush;
    but there is no "flush" method in TStream or any of its descendant; }
  end;

  procedure TAuGraph.Save(FileName: string; Colors: integer);
  var png_ptr:png_structp;
    info_ptr:png_infop;
    InterlaceType:LongWord;
    row_pointers: array of pointer;
    IMG: array of string;
    x,y,i: integer;
    ColorType:LongInt;
    Stream: TFileStream;
    bit_depth: integer;
    shv, j, mw, n: integer;
    s: string;
    p: pointer;
  begin
    //  
    bit_depth:=Colors;
    shv:=0;
    if bit_depth = 4 then shv:=4;
    if bit_depth = 2 then shv:=6;
    For y:=0 to High do
      For x:=0 to D[0].High do
        D[y][x]:=(D[y][x] shr shv);
    //  
    SetLength(IMG, Length);
    SetLength(row_pointers, Length);
    For i:=0 to Length - 1 do begin
      s:='';
      For j:=0 to D[0].High do s:=s + chr(D[i][j]);
      SetLength(s, D[0].Length + 4);
      If bit_depth = 4 then begin
        For j:=0 to D[0].Length div 2 do
          s[j + 1]:=chr(ord(s[j*2 + 2]) + (ord(s[j*2 + 1]) shl 4));
      end;
      If bit_depth = 2 then begin
        For j:=0 to D[0].Length div 4 do
          s[j + 1]:=chr(ord(s[j*4 + 4]) + (ord(s[j*4 + 3]) shl 2) + (ord(s[j*4 + 2]) shl 4) + (ord(s[j*4 + 1]) shl 6));
      end;
      Img[i]:=s;
      row_pointers[i]:=@(Img[i][1]);
    end;
    // PNG
    FileName:=ChangeFileExt(FileName, '.png');
    Stream:=TFileStream.Create(FileName, fmCreate);
    png_ptr:=png_create_write_struct(PNG_LIBPNG_VER_STRING, nil, our_png_error_fn, our_png_warning_fn);
      Check( png_ptr<>nil, '    PngLib:    png_create_write_struct');
    info_ptr:=png_create_info_struct(png_ptr);
      Check( info_ptr<>nil, '    PngLib:    png_create_info_struct');
    png_set_compression_level(png_ptr, Z_BEST_COMPRESSION);
    png_set_write_fn(png_ptr, Stream, our_png_write_fn, our_png_flush_fn);
    png_set_IHDR(png_ptr, info_ptr, D[0].Length, Length, bit_depth, PNG_COLOR_TYPE_GRAY,
      PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);
    png_write_info(png_ptr, info_ptr);
    png_write_image(png_ptr, @row_pointers[0]);
    png_write_end(png_ptr, info_ptr);
    Stream.Free;
    png_destroy_write_struct(@png_ptr, @info_ptr);
    setLength(row_pointers, 0);
    For i:=0 to Length - 1 do IMG[i]:='';
    SetLength(IMG, 0);
  end;

  type
    TCB = array of array of byte;

  procedure TAuColorMangaScan.Save(FileName: string; Colors: integer);
  var png_ptr:png_structp;
    info_ptr:png_infop;
    InterlaceType:LongWord;
    row_pointers: array of pointer;
    buf: TCB;
    x,y,i: integer;
    ColorType:LongInt;
    Stream: TFileStream;
    j, mw, n: integer;
    s: string;
  begin
    // 
    SetLength(buf, Height);
    SetLength(row_pointers, Height);
    For y:=0 to High do  begin
      setLength(buf[y], Width*3 + 4);
      For x:=0 to D[0].High do begin
        buf[y][x * 3]:=Clamp(RV[y][x], 0, 255);
        buf[y][x * 3 + 1]:=Clamp(GV[y][x], 0, 255);
        buf[y][x * 3 + 2]:=Clamp(D[y][x], 0, 255);
      end;
      row_pointers[y]:=@(buf[y][0]);
    end;
    // PNG
    FileName:=ChangeFileExt(FileName, '.png');
    Stream:=TFileStream.Create(FileName, fmCreate);
    png_ptr:=png_create_write_struct(PNG_LIBPNG_VER_STRING, nil, our_png_error_fn, our_png_warning_fn);
      Check( png_ptr<>nil, '    PngLib:    png_create_write_struct failed');
    info_ptr:=png_create_info_struct(png_ptr);
      Check( info_ptr<>nil, '    PngLib:    png_create_info_struct failed');
    png_set_compression_level(png_ptr, Z_BEST_COMPRESSION);
    png_set_write_fn(png_ptr, Stream, our_png_write_fn, our_png_flush_fn);
    png_set_IHDR(png_ptr, info_ptr, Width, Height, 8, PNG_COLOR_TYPE_RGB,
      PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);
    png_write_info(png_ptr, info_ptr);
    png_write_image(png_ptr, @row_pointers[0]);
    png_write_end(png_ptr, info_ptr);
    Stream.Free;
    png_destroy_write_struct(@png_ptr, @info_ptr);
    setLength(row_pointers, 0);
    For y:=0 to High do setLength(buf[y], 0);
    SetLength(buf, 0);
  end;

  procedure TAuGraph._ReadFromPng(FileName: string);
  var
    png_ptr:png_structp;
    info_ptr:png_infop;
    row_pointers: array of pointer;
    has_alpha_info:boolean;
    ColorType, BitDepth:LongWord;
    Stream: TFileStream;
    j: integer;
  begin
    FileName:=ChangeFileExt(FileName, '.png');
    Stream:= TFileStream.Create(filename, fmOpenRead + fmShareDenyWrite);
    if not LibPngLoaded then LoadLibPNG;

    png_ptr:=png_create_read_struct(PNG_LIBPNG_VER_STRING, nil, our_png_error_fn, our_png_warning_fn);

    Check( png_ptr<>nil, '    PngLib:    png_create_read_struct');

    info_ptr:=png_create_info_struct(png_ptr);
    Check( info_ptr<>nil, '    PngLib:    png_create_info_struct failed');

    png_set_read_fn(png_ptr, Stream, our_png_read_fn);

    png_read_info(png_ptr, info_ptr);
    if (png_get_image_height(png_ptr, info_ptr) > MaxPicDimensions)
    or (png_get_image_width(png_ptr, info_ptr) > MaxPicDimensions) then YellAndDie(
      '    - %dx%d,'#10#13
      +'    ?.. %dx%d!'#10#13'( "%s")', [MaxPicDimensions, png_get_image_width(png_ptr, info_ptr), png_get_image_width(png_ptr, info_ptr), filename]);
    SetRect(png_get_image_height(png_ptr, info_ptr), png_get_image_width(png_ptr, info_ptr));

    BitDepth:=png_get_bit_depth(png_ptr, info_ptr);
    ColorType:=png_get_color_type(png_ptr, info_ptr);

   {palette -> rgb, maybe with alpha}
    if (ColorType and PNG_COLOR_MASK_PALETTE)<>0 then
    begin
      png_set_palette_to_rgb(png_ptr);
      {we converted palette to rgb; actually it may be RGB or RGBA;
       paletted images can contain alpha channel only using tRNS chunk
       so here we can check whether we got RGB or RGBA by checking
       whether there exists tRNS chunk;
       Ufff; this way a bug corrected after a long day : 21.12.2002}
      if png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS)<>0 then
        ColorType:=PNG_COLOR_TYPE_RGB_ALPHA else
        ColorType:=PNG_COLOR_TYPE_RGB;
        BitDepth:=8; { when expanding palette we always get 8 bit depth because
        pallete entries are always in 8bit RGB }
    end;
    {grayscale -> 8bit rgb}
    if (ColorType and PNG_COLOR_MASK_COLOR)=0 then
    begin
      if BitDepth<8 then
      begin
        png_set_gray_1_2_4_to_8(png_ptr);
        BitDepth:=8;
      end;
      png_set_gray_to_rgb(png_ptr);
      {gray color means ColorType = PNG_COLOR_TYPE_GRAY or GRAY_ALPHA = 0 or MASK_ALPHA
       and that's why here we can simply combine it bitwise with MASK_COOR }
     ColorType:=ColorType or PNG_COLOR_MASK_COLOR;
    end;
    {now he have rgb 8/16 bitDepth + maybe alpha}
    {rgb 16 bitdepth -> rgb 8 bitdepth}
    if BitDepth=16 then
    begin
     png_set_strip_16(png_ptr);
     BitDepth:=8;
    end;

    if (ColorType = PNG_COLOR_TYPE_RGB) and (BitDepth = 8)
      then png_set_filler(png_ptr, 255, PNG_FILLER_AFTER) else
    Assert((ColorType = PNG_COLOR_TYPE_RGB_ALPHA) and (BitDepth = 8),
     'png_transform_to_rgba4byte failed to apply good png transformations');

    png_read_update_info(png_ptr, info_ptr);
    Assert(png_get_rowbytes(png_ptr, info_ptr) = Width * 4,
      format('internal error : applied wrong png transformations, width %d with %d bytes per pixel gave row byte length %d instead of %d',
      [Width, 4, png_get_rowbytes(png_ptr, info_ptr), Width * 4]));

    SetLength(row_pointers, Height);
    For j:=0 to Height - 1 do row_pointers[j]:=D[j].DPTR;

    png_read_image(png_ptr, @(row_pointers[0]));

    png_destroy_read_struct(@png_ptr, @info_ptr, nil);

    SetLength(row_pointers, 0);
    Stream.Free;
  end;
