{
    This file is part of the Automaton program,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the main program unit.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{$ifndef fpc}
!!
//This program can be compiled in FreePascal ONLY!
//(beause it uses some units which utilize macros and templates - the
// features, Borland Delphi doesn't have.
{$endif}

{$mode delphi} //affects only strictness of name space checking -
               // in the objfpc mode same identifier cannot be used for a
               // class field and for a parameter in a method of same class
{$ifdef win32}
  {$apptype console}
  {$m 5000000, 5000000}
{$endif}
program automaton;

uses SysUtils, {$ifdef win32} Windows, {$endif} aut_parser, aut_graph, cl_strings, cl_kambipng;

Const yoptt: string = 'Ѩ  ~   ~!     !~!..'
    +'~   Ǩ,    Ǩ~, ...!~!!!~   !~ !~!~...'
    +'~...~  !~,  -  ...~Ш !..~, ...~,  !..~....!';

Procedure Yell(s: string);
begin
   randomize;
  {$ifdef win32}
   if ParIs('-o') then MessageBox(0, PChar(s), PChar(ranStr(yoptt)), MB_ICONERROR + MB_OK)
   else
  {$endif}
   begin
     WriteLnRu(#10#13#10#13#10#13 + ranStr(yoptt));
     WritelnRu(#10#13 + s + #10#13);
     WritelnRu(' ENTER  .');
     ReadLn;
   end;
   Halt;
end;

var
  P: TAuManga;
begin
  {$ifndef win32}
  WriteLn;
  WriteLn('------------------------------------------------------------');
  {$endif}
  WriteLn('"AUTOMATON": The Manga Compiler, Version ', VersionString, '.');
  WriteLn('Copyright (c) 2004 by Anton Rzheshevski');
  if ParamCount = 0 then begin
    WriteLnRu(#10#13#10#13);
    WriteLnRu(': automaton "< *.manga >" [<>]');
    WriteLnRu('  , :');
    WriteLnRu('    -w        ,');
    WriteLnRu('          Enter''');
    WriteLnRu('    -d   ');
    WriteLnRu('    -r    (   !');
    WriteLnRu('              n-...)');
    {$ifdef win32}
    WriteLnRu('    -t    ');
    WriteLnRu('    -o       ');
    {$endif}
    WriteLnRu('    -x      LibPng');
    WriteLnRu('        (    *.png  )');
    WriteLnRu('');
    WriteLnRu('    ');
    WriteLnRu('    ,  ');
    WriteLnRu('  http://chebmaster.narod.ru/mantrah/automaton_manual.html');
    WriteLnRu('');
    WriteLnRu(' ENTER  .');
    ReadLn;
    Halt(0);
  end;
  Try
    P:=TAuManga.Create(ParamStr(1));
    P.Parse;
    P.Free;
  Except
    if ExceptObject is Exception
      then Yell((ExceptObject as Exception).Message)
      else Yell(' ,   -  , .');
    Halt(0);
  End;
  if ParIs('-w') then
  {$ifdef win32}
    if ParIs ('-o') then MessageBox(0, PChar('  !'), PChar(UpperCase(ChangeFileExt(ExtractFileName(ParamStr(1)), '')) + '   ^_^'), MB_ICONASTERISK + MB_OK)
    else
  {$endif}
    begin
      WriteLnRu(#10#13#10#13#10#13);
      WriteLnRu('  ! :)'#10#13);
      WriteLnRu(' ENTER  .');
      ReadLn;
    end;
end.
