{
    This file is part of the ChebLib libraly,
    Copyright (c) 2004-2005 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the INI-based mini-database class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

unit TeXtruct;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, IniFiles;

Type

  { TTeXtruct }

  TTeXtruct = class(TMemIniFile)
  protected
    Function SN(name: string): string;
    Function PN(name: string): string;
    Function ReadInt(name: string): Integer;
    Function ReadBool(name: string): Boolean;
    Function ReadStr(name: string): string;
    Procedure WriteInt (name: string; value: integer);
    Procedure WriteStr (name, value: string);
    Procedure WriteBool (name: string; value: boolean);
  public
    Destructor Destroy; override;
    Procedure GetList(name: string; L: TStrings);
    Procedure SetList(name: string; L: TStrings);
    Procedure Flush;
    Property Int[name: string]: integer Read ReadInt Write WriteInt;
    Property Bool[name: string]: boolean Read ReadBool Write WriteBool;
    Property Str[name: string]: string Read ReadStr Write WriteStr; Default;
  end;


implementation

  function TTeXtruct.PN(name: string): string;
  var
    c: integer;
  begin
    Result:=name;
    For c:=Length(name) downto 1 do
      if name[c] = '/' then begin
        Result:=Copy(name, c + 1, Length(name) - c);
        Break;
      end;
  end;

  function TTeXtruct.SN(name: string): string;
  var
    c: integer;
  begin
    Result:=name;
    For c:=Length(name) downto 1 do
      if name[c] = '/' then begin
        Result:=Copy(name, 1, c - 1);
        Break;
      end;
    if Result=name then Result:='Root';
  end;

  Function TTeXtruct.ReadInt(name: string): Integer;
  begin
    Result:=ReadInteger(sn(name), pn(name), 0);
  end;

  function TTeXtruct.ReadBool(name: string): Boolean;
  begin
    Result:=(Int[name] <> 0);
  end;

  Function TTeXtruct.ReadStr(name: string): string;
  begin
    Result:=ReadString(sn(name), pn(name), '');
  end;

  Procedure TTeXtruct.WriteInt (name: string; value: integer);
  begin
    WriteInteger(sn(name), pn(name), value);
  end;

  Procedure TTeXtruct.WriteStr (name, value: string);
  begin
    WriteString(sn(name), pn(name), value);
  end;

  procedure TTeXtruct.WriteBool(name: string; value: boolean);
  begin
    if value then Int[name]:=1 else Int[name]:=0;
  end;

  procedure TTeXtruct.GetList(name: string; L: TStrings);
  begin
    L.Clear;
    L.Text:=StringReplace(Str[name], '/', #13, [rfReplaceAll]);
  end;

  procedure TTeXtruct.SetList(name: string; L: TStrings);
  var
    s: string;
    c: integer;
  begin
    if L.Count > 0 then s:=L[0];
    For c:=1 to L.Count - 1 do s:=s + '/' + L[c];
    Str[name]:=s;
  end;

  procedure TTeXtruct.Flush;
  begin
    UpdateFile;
  end;
  
  destructor TTeXtruct.Destroy;
  begin
    Flush;
    inherited Destroy;
  end;

end.

