unit ripretimer_userform;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Buttons, srtretimer_main, cl_filelist, textruct;

type

  { TForm4 }

  TForm4 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Panel1: TPanel;
    Panel2: TPanel;
    SelectDirectoryDialog1: TSelectDirectoryDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Form4Activate(Sender: TObject);
    procedure Form4Close(Sender: TObject; var CloseAction: TCloseAction);
    procedure Form4Create(Sender: TObject);
    procedure Form4Hide(Sender: TObject);
    procedure Form4Resize(Sender: TObject);
  private
    Activated, dmode: boolean;
    procedure RefillDir;
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form4: TForm4; 

implementation

{ TForm4 }

procedure TForm4.Button2Click(Sender: TObject);
begin
  dmode:=true;
  Form1.Visible:=True;
  Application.ProcessMessages;
  Form1.SetFocus;
  Application.ProcessMessages;
  Form1.Prepare;
  MainForm:=Form1;

  Form4.Visible:=False;
end;

const Slash: char = {$ifdef win32} '\' {$else} '/' {$endif};

procedure TForm4.Button3Click(Sender: TObject);
begin
  if SelectDirectoryDialog1.Execute then begin
    Dir:=SelectDirectoryDialog1.FileName;
    if (Dir <> '') and (Dir[Length(Dir)] <> Slash) then Dir:=Dir + Slash;
    RefillDir;
  end;
end;

procedure TForm4.ComboBox1Change(Sender: TObject);
begin
  if ComboBox1.ItemIndex < 0 then ProjectName:=''
  else ProjectName:=Dir + ComboBox1.Items[ComboBox1.ItemIndex] + '.rrp';
end;

procedure TForm4.Button1Click(Sender: TObject);
begin
  if ComboBox1.ItemIndex < 0
    then ErrorMessage('?..',' -?..'#10#13
      +'  ,'#10#13
      +'   '#10#13
      +'     .')
  else begin
    Project:=TTeXtruct.Create(Dir + ComboBox1.Text + '.rrp');
    if Go then Self.Close
    else begin
      Project.Free;
      Project:=nil;
    end;
  end;
end;

procedure TForm4.Form4Activate(Sender: TObject);
begin
  if Activated then Exit;
  Activated:=True;
  Form4.Icon:=Application.Icon;
  Form1.Visible:=False;
end;

procedure TForm4.Form4Close(Sender: TObject; var CloseAction: TCloseAction);
begin

  if not dmode then Halt(0);
end;

procedure TForm4.Form4Create(Sender: TObject);
begin
  RefillDir;
end;

procedure TForm4.Form4Hide(Sender: TObject);
begin
  if Self.WindowState = wsMinimized
    then Form1.Close;
end;

procedure TForm4.Form4Resize(Sender: TObject);
begin
  if Self.WindowState = wsMinimized
    then Form1.Close;
end;

procedure TForm4.RefillDir;
var
  L: TFileList;
  c: integer;
begin
  ProjectName:='';
  if Dir = '' then Exit;
  L:=TFileList.Create(Dir + '*.rrp');
  L.SortByName;
  ComboBox1.Clear;
  For c:=0 to L.Count - 1 do
    ComboBox1.Items.Add(
      ChangeFileExt(ExtractFileName(L.Names[c]), ''));
  ComboBox1.ItemIndex:=Combobox1.Items.IndexOf(
    ChangeFileExt(ExtractFileName(ParamStr(1)), ''));
  With ComboBox1 do if (ItemIndex < 0) and (Items.Count > 0)
  then begin
    ItemIndex:=0;
  end;
  if ComboBox1.ItemIndex >=0
    then ProjectName:=Dir + ComboBox1.Items[ComboBox1.ItemIndex] + '.rrp';
end;

initialization
  {$I ripretimer_userform.lrs}

end.

