unit preventmultipleinstances;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils {$ifdef win32}, Windows{$endif};

  function ThisIsAnOnlyInstance: boolean;

implementation

{$ifdef win32}

  var
    M: THandle;
    Di: boolean = false;

  function ThisIsAnOnlyInstance: boolean;
  var N: string;
  begin
    Result:=True;
    N:='SingleInstancEMutex' + ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    M:=OpenMutex(MUTEX_MODIFY_STATE, False, PChar(N));
    if M = 0 then M:=CreateMutex(nil, True, PChar(N))
    else begin
      if WaitForSingleObject(M, 0) <> WAIT_ABANDONED
        then Result:=False;
    end;
    Di:=Result;
  end;

{$else}

  function ThisIsAnOnlyInstance: boolean;
  begin
    Result:=True;
  end;
{$endif}

finalization
{$ifdef win32}
  Try
    if Di then ReleaseMutex(M);
  Except End;
{$else}

{$endif}
end.

