{
    This file is part of the SrtRetimer utility,
    Copyright (c) 2005 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the main project form.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

unit SrtRetimer_Main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  CheckLst, ExtCtrls, Buttons, textruct, Menus {$ifdef win32},Windows{$endif}
  ,Script, strretimer_form2, ComCtrls, cl_filelist
  , strretimer_form3, srtretimer_reg, preventmultipleinstances, math;

type

  { TForm1 }

  TForm1 = class(TForm)
    AddDestSRTButton: TButton;
    Button1: TButton;
    Button10: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckListBox2: TCheckListBox;
    GroupBox1: TGroupBox;
    GroupBox5: TGroupBox;
    Label1: TLabel;
    Label7: TLabel;
    ErrorJournalMemo: TMemo;
    MemoSSAHeader: TMemo;
    Page1: TPage;
    ErrorJournalPage: TPage;
    T1Edit: TEdit;
    T2Edit: TEdit;
    ShEdit: TEdit;
    ScEdit: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Panel1: TPanel;
    RefSubCheckBox: TCheckListBox;
    ComboBox1: TComboBox;
    ListBox2: TListBox;
    LoadReferenceEngSub: TBitBtn;
    DeleteDestSRTSafetyClamp: TCheckBox;
    DeleteDestSRTButton: TButton;
    CheckListBox1: TCheckListBox;
    DestSRTNameEdit: TEdit;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    Label2: TLabel;
    ListBox1: TListBox;
    OpenDialogRefSub: TOpenDialog;
    RipFilesBox: TGroupBox;
    SrcFilesBox: TGroupBox;
    Notebook1: TNotebook;
    DestFilesPage: TPage;
    SegsPage: TPage;
    MainMenu1: TMainMenu;
    MenuItemExecute: TMenuItem;
    MenuItemHelp: TMenuItem;
    MenuItemProjectLoad: TMenuItem;
    MenuItemNewProject: TMenuItem;
    MenuItemProject: TMenuItem;
    OpenDialogProject: TOpenDialog;
    SaveNewProjectDialog: TSaveDialog;
    procedure AddDestSRTButtonClick(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button3KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
      );
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure CheckBox1Change(Sender: TObject);
    procedure CheckBox2Change(Sender: TObject);
    procedure CheckBox3Change(Sender: TObject);
    procedure CheckListBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure DeleteDestSRTButtonClick(Sender: TObject);
    procedure DeleteDestSRTSafetyClampChange(Sender: TObject);
    procedure DestFilesPageResize(Sender: TObject);
    procedure DestSRTNameEditChange(Sender: TObject);
    procedure DestSRTNameEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Form1Activate(Sender: TObject);
    procedure Form1ChangeBounds(Sender: TObject);
    procedure Form1Close(Sender: TObject; var CloseAction: TCloseAction);
    procedure Form1Create(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure GroupBox3Resize(Sender: TObject);
    procedure GroupBox4Resize(Sender: TObject);
    procedure ListBox1SelectionChange(Sender: TObject; User: boolean);
    procedure ListBox2Click(Sender: TObject);
    procedure ListBox2SelectionChange(Sender: TObject; User: boolean);
    procedure LoadReferenceEngSubClick(Sender: TObject);
    procedure MemoSSAHeaderChange(Sender: TObject);
    procedure MenuItemExecuteClick(Sender: TObject);
    procedure MenuItemHelpClick(Sender: TObject);
    procedure MenuItemNewProjectClick(Sender: TObject);
    procedure MenuItemProjectLoadClick(Sender: TObject);
    procedure Notebook1PageChanged(Sender: TObject);
    procedure ProjectOpen(filename: string);
    procedure RefillProjectForms;
    procedure RefillRipForms;
    procedure RefillDestFileForms;
    procedure Prepare;
    procedure SegsPageResize(Sender: TObject);
    procedure FlushSegs;
    function ValuesValid: boolean;
    Procedure RepaintSelectedSegs;
    procedure LoadRefSub(fname: string);
  private
    Activated, prepared : boolean;
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1;
  MainForm:TForm;
  Reg, Project: TTeXtruct;
  StartDir: string;
  Dir: string;
  SrcSub, RefSub: TScript;
  ProjectName: string = '';
  ConvertToSrt: boolean;
  
Procedure InitRg;
function GO: boolean;
procedure ErrorMessage(capt, txt: string);
    
implementation
 Uses ripretimer_userform;


Const Slash: String = {$ifdef win32}'\'{$else}'/'{$endif};

{$define guiversion}
{$include rrt_common.inc}

{ TForm1 }

procedure TForm1.Form1Create(Sender: TObject);
var
  mess: string = '';
begin
  MainForm:=Self;
  Dir:=ExtractFilePath(ParamStr(1));
  CheckBox1.Checked := (Reg.Int['DeveloperModeByDefault'] = 1);
  CheckBox2.Checked := (Reg.Int['KillSrtTags'] > 0);
//  Notebook1.PageIndex:=2;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  Panel1.Height:=ClientHeight - Panel1.Top - 2;
end;

procedure TForm1.GroupBox3Resize(Sender: TObject);
begin
  CheckListBox2.Width:=
    GroupBox3.ClientWidth - CheckListBox2.Left - 3;
  CheckListBox2.Height:=
    GroupBox3.ClientHeight - CheckListBox2.Top - 2;
end;

procedure TForm1.GroupBox4Resize(Sender: TObject);
begin
  RefSubCheckBox.Width:=
    GroupBox4.ClientWidth - RefSubCheckBox.Left - 3;
  RefSubCheckBox.Height:=
    GroupBox4.ClientHeight - RefSubCheckBox.Top - 2;
end;

procedure TForm1.Prepare;
begin
  if ProjectName = '' then projectName:=Reg['CurrentProject'];
  if FileExists(ProjectName)
    then ProjectOpen(ProjectName);
  SaveNewProjectDialog.InitialDir:=Reg.Str['LastUsedDir'];
  OpenDialogProject.InitialDir:=Reg.Str['LastUsedDir'];
  prepared:=true;
end;


procedure TForm1.ListBox1SelectionChange(Sender: TObject; User: boolean);
begin
  With ListBox1 do begin
    if ItemIndex < 0 then begin
      DestSrtNameEdit.Text:='';
    end
    else begin
      DestSrtNameEdit.Text:=Items[ItemIndex];
      Project['CurrentDestFile']:=DestSRTNameEdit.Text;
      RefillDestFileForms;
    end;
  end;
end;

procedure TForm1.ListBox2Click(Sender: TObject);
begin

end;

procedure TForm1.ListBox2SelectionChange(Sender: TObject; User: boolean);
begin
  if ListBox2.ItemIndex < 0 then Exit;
  T1Edit.Text:= Copy(ListBox2.Items[ListBox2.ItemIndex], 1, 12);
  T2Edit.Text:= Copy(ListBox2.Items[ListBox2.ItemIndex], 15, 12);
  ShEdit.Text:= Copy(ListBox2.Items[ListBox2.ItemIndex], 29, 13);
  ScEdit.Text:= Copy(ListBox2.Items[ListBox2.ItemIndex], 45, 7);
  RepaintSelectedSegs;
  Project.Int[DestSrtNameEdit.Text + '/SelectedSeg']:=ListBox2.ItemIndex;
end;

procedure TForm1.LoadReferenceEngSubClick(Sender: TObject);

begin
  OpenDialogRefSub.InitialDir:=Reg.Str['LastSrtDir'];
  if not OpenDialogRefSub.Execute then Exit;
  Reg.Str['LastSrtDir']:=ExtractFilePath(OpenDialogRefSub.FileName);
  LoadRefSub(OpenDialogRefSub.FileName);
end;

procedure TForm1.MemoSSAHeaderChange(Sender: TObject);
begin
  Project.SetTxt('Rip/SSA Header', MemoSSAHeader.Lines);
end;

procedure TForm1.LoadRefSub(fname: string);
var c: integer;
begin
  if Assigned(RefSub) then begin
    RefSub.Free;
    RefSub:=nil;
  end;
  RefSubCheckBox.Clear;
  Try
    RefSub:=TScript.CreateFromFile(fname);
  Except
    ErrorMessage('   !', (ExceptObject as Exception).Message);
    Project[DestSrtNameEdit.Text + '/RefSub']:='';
    RepaintSelectedSegs;
    Exit;
  End;
  RefSub.Sort;
  For c:=0 to RefSub.Count - 1 do
    RefSubCheckBox.Items.Add(RefSub.GetRefLine(c));
{
      MsToSrtTime(StrToInt(Copy(RefSub.Strings[c],1,10)))
      + '  ' + RefSub.GetText(c));//Copy(RefSub.Strings[c], 21, Length(RefSub.Strings[c]) - 20));
}
  RepaintSelectedSegs;
  Project[DestSrtNameEdit.Text + '/RefSub']:=fname;
end;

procedure TForm1.MenuItemExecuteClick(Sender: TObject);
begin
  GO;
end;


procedure TForm1.MenuItemHelpClick(Sender: TObject);
begin
  {$ifdef win32}
  ShellExecute(0,'open', 'http://chebmaster.narod.ru/srtretimer/manual.html','','',SW_SHOWNORMAL);
  {$endif}
end;

procedure TForm1.MenuItemNewProjectClick(Sender: TObject);
begin
  SaveNewProjectDialog.InitialDir:=Reg.Str['LastUsedDir'];
  if not SaveNewProjectDialog.Execute then Exit;
  Panel1.Visible:=False;
  ProjectOpen(SaveNewProjectDialog.FileName);
end;

procedure TForm1.MenuItemProjectLoadClick(Sender: TObject);
begin
  if not OpenDialogProject.Execute then Exit;
  Panel1.Visible:=False;
  ProjectOpen(OpenDialogProject.FileName);
end;

procedure TForm1.Notebook1PageChanged(Sender: TObject);
begin
  if (Notebook1.PageIndex = 1) and (ListBox1.ItemIndex < 0)
    then Notebook1.PageIndex:=0;
  if not Assigned(Project)
    then Notebook1.PageIndex:=2
    else Project.Int['TabIndex']:=Notebook1.PageIndex;
end;

procedure TForm1.ProjectOpen(filename: string);
begin
  if Assigned(Project) then begin
    Project.Flush;
    Project.Free;
  end;
  Project:=TTeXtruct.Create(filename);
  Caption:=ExtractFileName(filename) + ' - Rip Retimer,  ';
  if Project['Rips'] <> '' then begin
    ErrorMessage(' ... v_v',
    ' SRP   SrtRetimer  0.91.     0.92    .'
    +#10#13#10#13'     ,     ,  '
    +#10#13'[Rip/<  >]'#10#13''#10#13'[Rip]'#10#13
    +',    '
    +#10#13'Rips=< >');
    Application.Terminate;
  end;
  Reg['CurrentProject']:=filename;
  Reg.Flush;
  RefillProjectForms;
end;

procedure TForm1.RefillProjectForms;
var
  FL: TFileList;
  c: integer;
  s: string;
begin
  Panel1.Visible:=True;
  s:=ExtractFilePath(Project.FileName);
  FL:=TFileList.Create([s + '*.srt', s + '*.ssa', s + '*.ass']);
  FL.SortByDate;
  CheckListBox1.Clear;
  For c:=FL.count - 1 downto 0 do
    CheckListBox1.Items.Add(ExtractFileName(FL.Names[c]));
  FL.Free;
  RefillRipForms;
end;

procedure TForm1.RefillRipForms;
var
  ChList: TStrings;
  c: integer;
begin
  Panel1.Visible:=True;
  {$ifdef win32}
    Button10.Caption:=' ';
    label7.Visible:=false;
  {$endif}
  Project.GetList('Rip/Script List', ListBox1.Items);
  With ListBox1 do
    ItemIndex:=Items.IndexOf(Project['CurrentDestFile']);
  DestSrtNameEdit.Text:=Project['CurrentDestFile'];

  With Notebook1 do
    if ListBox1.ItemIndex < 0 then PageIndex:=0
    else begin
      PageIndex:=Project.Int['TabIndex'];
      if PageIndex = 3 then PageIndex:=1;
    end;

  ComboBox1.Clear;
  ChList:=TStringList.Create;
  Project.GetList('SelectedSourcesList', ChList);
  For c:=0 to ChList.Count - 1 do
    With CheckListBox1 do
      if Items.IndexOf(ChList[c]) >=0
        then Checked[Items.IndexOf(ChList[c])]:=True;
  ChList.Free;

  Self.CheckListBox1Click(nil);// ComboBox1

  RefillDestFileForms;
  
  CheckBox3.Checked:=Project.Bool['ClearSelections'];
  
  Project.GetTxt('Rip/SSA Header', MemoSSAHeader.Lines);
end;

procedure TForm1.RefillDestFileForms;
var
  c: integer;
  FN, f: string;

begin
  FN:=DestSrtNameEdit.Text;
  if FN = '' then begin
    SegsPage.Caption:='<,  >';
    Exit;
  end;
  SegsPage.Caption:='  ' + FN;

  CheckListBox2.Clear;
  f:=Project[FN + '/ActiveSource'];
  c:=ComboBox1.Items.IndexOf(f);
  if (c < 0) and (f<>'') then ComboBox1.Items.Add(f);
  ComboBox1.Text:=f;
  With  ComboBox1 do
    ItemIndex:=Items.IndexOf(Text);
  ComboBox1Change(nil); //   

  if Assigned(RefSub) then begin
    RefSub.Free;
    RefSub:=nil;
  end;

  f:=Project[FN + '/RefSub'];
  if FileExists(f) then LoadRefSub(f)
                   else RefSubCheckBox.Clear;

  Project.GetList(
    'Rip/' + FN, ListBox2.Items);
    
  c:=Project.Int[FN + '/SelectedSeg'];
  With ListBox2 do
    if (Items.Count > 0) and (c < Items.Count) then ItemIndex:=c;
end;

procedure TForm1.FlushSegs;
begin
  Project.SetList(
    'Rip/' + DestSrtNameEdit.Text, ListBox2.Items);
  Project.Flush;
end;

function SrtTimeValid(s: string): boolean;
begin
  Result:=False;
  s:=Trim(s);
  if Length(s) <> 12 then Exit;
  Try
    SrtTimeToMs(s);
  Except
    Exit;
  End;{
00:00:00,000}
  if (s[3] <> ':') or (s[6] <> ':') or (s[9] <> ',') then Exit;
  Result:=True;
end;

function TForm1.ValuesValid: boolean;
var
  val: real;
  shs: string;
begin
  Result:=False;
  if not SrtTimeValid(T1Edit.Text) then begin
    ErrorMessage('!',T1Edit.Text + ' -   !');
    exit;
  end;
  if not SrtTimeValid(T2Edit.Text) then begin
    ErrorMessage('!',T2Edit.Text + ' -   !');
    exit;
  end;
  shs:=Trim(ShEdit.Text);
  if length (shs) = 12 then shs:='+' + shs;
  if not ((length(shs) = 13) and SrtTimeValid(Copy(shs, 2, 12))
           and (shs[1] in ['+','-']))
  then begin
    ErrorMessage('!',shs + ' -   !');
    exit;
  end;
  if (shs[1]='-') and (SrtTimeToMs(Copy(shs, 2, 12)) > SrtTimeToMs(T1Edit.Text))
  then begin
    ErrorMessage('!', '    .');
    exit;
  end;
  ShEdit.Text:=shs;
  Try
    val:=StrToFloat(trim(ScEdit.Text));
    if (val < 0) or (val > 9.9990)
    then begin
      ErrorMessage('!','     9.9999  !');
      exit;
    end;
  Except
    ErrorMessage('!',ScEdit.Text + ' -      !');
    exit;
  End;
  Result:=True;
end;

procedure TForm1.RepaintSelectedSegs;
var
  sbeg, send, dbeg, dend, c, i: integer;
  ss: string;
begin
  if ListBox2.ItemIndex < 0 then Exit;
  ss:=ListBox2.Items[ListBox2.ItemIndex];
  Sbeg:=SrtTimeToMs(Copy(ss, 1, 12));
  Send:=SrtTimeToMs(Copy(ss, 15, 12));
  dbeg:=SrtTimeToMs(Copy(ss, 30, 12));
  if Copy(ss, 29, 1) = '-' then dbeg:= -dbeg;
  dbeg:=dbeg + sbeg;
  dend:=dbeg + Trunc((send - sbeg) * StrToFloat(Copy(ss, 45, 7)));

  //     
  if Copy(ss, 59, length(ss) - 58) = ComboBox1.Text
  //      
  then begin
     CheckListBox2.Visible:=False;
     For c:=0 to CheckListBox2.Items.Count - 1 do begin
      i:=SrtTimeToMs(Copy(CheckListBox2.Items[c], 1, 12));
      CheckListBox2.Selected[c]:= (i >= sbeg) and (i <send);
    end;
    CheckListBox2.Visible:=True;
  end
  else
    For c:=0 to CheckListBox2.Items.Count - 1
      do CheckListBox2.Selected[c]:=False;

  RefSubCheckBox.Visible:=False;
  For c:=0 to RefSubCheckBox.Items.Count - 1 do begin
    i:=SrtTimeToMs(Copy(RefSubCheckBox.Items[c], 1, 12));
    RefSubCheckBox.Selected[c]:= (i >= dbeg) and (i <dend);
  end;
  RefSubCheckBox.Visible:=True;
end;

procedure TForm1.SegsPageResize(Sender: TObject);
begin
  GroupBox2.Width:=SegsPage.ClientWidth - GroupBox2.Left - 2;
  GroupBox3.Width:=(SegsPage.ClientWidth - 10) div 2;
  GroupBox4.Width:=SegsPage.ClientWidth - (GroupBox3.Left + GroupBox3.Width) - 4;
  GroupBox4.Left:=(GroupBox3.Left + GroupBox3.Width) + 2;
  GroupBox4.Height:=(SegsPage.ClientHeight - GroupBox4.Top) - 2;
  GroupBox3.Height:=(SegsPage.ClientHeight - GroupBox3.Top) - 2;
end;

procedure TForm1.Form1Activate(Sender: TObject);
var mess:string;
begin
  if Activated then Exit;
  //Icon:=Application.Icon;
  {$ifdef unix}
   MenuItemHelp.Visible:=false;
  {$endif}
  if not ThisIsAnOnlyInstance then begin
    Visible:=False;
    Application.ProcessMessages;
    ErrorMessage('!..','   RipRetimer  ,'#10#13
                           + '    .');
    Halt(0);
  end;
  if Reg.Int['FormWidth'] > 0 then Form1.Width:=Reg.Int['FormWidth'];
  if Reg.Int['FormHeight'] > 0 then Form1.Height:=Reg.Int['FormHeight'];
  if Reg.Int['FormHeight'] > 0 then Form1.Top:=Reg.Int['FormTop'];
  if Reg.Int['FormHeight'] > 0 then Form1.Left:=Reg.Int['FormLeft'];
  if Reg.Int['FormMaximized'] > 0 then Form1.WindowState:=wsMaximized;
  {$ifdef win32}
  if not RegisterSelf then mess :=
    ' .RRP    ,    '
    + ParamStr(0);
  {$endif}
  if Reg.Int['DeveloperModeByDefault'] = 0 then begin
    if ParamStr(1) = '' then Dir:=Reg.Str['LastSrtDir'];
    Application.CreateForm(TForm4, Form4);
    if Mess <> '' Then Form4.Label1.Caption:=mess;
    MainForm:=Form4;
    Application.ProcessMessages;
  end
  else Prepare;
  Activated:=True;
end;

procedure TForm1.DeleteDestSRTButtonClick(Sender: TObject);
var
  c: integer;
begin
  DeleteDestSRTButton.Enabled:=False;
  DeleteDestSRTSafetyClamp.Checked:=False;
  c:=ListBox1.Items.IndexOf(DestSrtNameEdit.Text);
  if c < 0 then Exit;
  ListBox1.Items.Delete(c);
  Project.SetList('Rip/Script List', ListBox1.Items);
  DestSrtNameEdit.Text:='';
  RefillDestFileForms;
end;

procedure TForm1.AddDestSRTButtonClick(Sender: TObject);
var
  n: string;
begin
  n:=Trim(ChangeFileExt(DestSrtNameEdit.Text, '.srt'));
  if ListBox1.Items.IndexOf(n) < 0 then begin
    ListBox1.Items.Add(n);
    Project.SetList('Rip/Script List', ListBox1.Items);
    RefillDestFileForms;
  end;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
  ErrorJournalpage.Visible:=False;
  ErrorJournalMemo.Lines.Clear;
end;


procedure TForm1.Button1Click(Sender: TObject);
var
  c: integer;
begin
  For c:=0 to CheckListBox2.Items.Count - 1 do begin
    CheckListBox2.Checked[c]:=False;
    CheckListBox2.Selected[c]:=False;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  c: integer;
begin
  For c:=0 to RefSubCheckBox.Items.Count - 1 do begin
    RefSubCheckBox.Checked[c]:=False;
    RefSubCheckBox.Selected[c]:=False;
  end;
end;

//    :
procedure TForm1.Button3Click(Sender: TObject);
var
  c, n1, n2, s1, s2, d1, d2, Sstart, Send, Dstart, Dend: integer;
  scale: real;
  shift, scalestr: string;
  b: boolean;
begin
  n1:=0; n2:=0; s1:=-1; s2:=-1; d1:=-1; d2:=-1;
  For c:=0 to CheckListBox2.Items.count - 1 do
    if CheckListBox2.Checked[c] then begin
      case n1 of
        0: s1:=c;
        1: s2:=c;
      end;
      inc(n1);
    end;
  For c:=0 to RefSubCheckBox.Items.count - 1 do
    if RefSubCheckBox.Checked[c] then begin
      case n2 of
        0: d1:=c;
        1: d2:=c;
      end;
      inc(n2);
    end;
  if (n1 < 1) or (n1 > 2) or (n2 > 2) then ErrorMessage(
    '!', Format(
    '     1  2  ( %d),    -  0  2 ( %d)',
    [n1, n2]))
  else begin
    if n1=1 then s2:=s1;
    Sstart:=StrToInt(copy(SrcSub[s1], 1, 10));

    //    -  ,    :
    //        ?  
    //      ...
    Send:=StrToInt(copy(SrcSub[s2], 1, 10))
                   + StrToInt(copy(SrcSub[s2], 11, 10));
                   
    case n2 of
      0: begin
        Dstart:= Sstart;
        Scale:= 1.0;
      end;
      1: begin
        Dstart:=StrToInt(copy(RefSub[d1], 1, 10));
        if n1 = 2 then Scale:=1.0
        else begin
          Dend:=StrToInt(copy(RefSub[d1], 1, 10))
                + StrToInt(copy(RefSub[d1], 11, 10));
          Scale:=(Dend - Dstart) / (Send - Sstart);
        end;
      end;
      2: begin
        Dstart:=StrToInt(copy(RefSub[d1], 1, 10));
        Dend:=StrToInt(copy(RefSub[d2], 1, 10))
              + StrToInt(copy(RefSub[d2], 11, 10));
        Scale:=(Dend - Dstart) / (Send - Sstart);
      end;
    end;

    //    :
    shift:=MsToSrtTime(abs(Dstart - Sstart));
    if Dstart < SStart then shift:= '-' + shift else shift:= '+' + shift;
    
    if scale > 9.99990 then begin
      if n1 = 1 then begin
        if n2 = 1 then ErrorMessage(
         '!','       9.9999 .     ,       9.9999  .')
                  else ErrorMessage(
         '!','     ,   9.9999 .     ,       9.9999  .');
        scale:= 9.99990
      end
      else begin
        ErrorMessage('  9.9999!','      9.9999  - , ,   !');
        Exit;
      end;
    end;

    scalestr:=FloatToStrF(scale, ffFixed, 0, 5);

    ListBox2.ItemIndex:=-1;
    ListBox2.Items.Add(
    // 1, 10                        13, 10
    MsToSrtTime(Sstart) + '..' + MsToSrtTime(Send) + ', '
    // 24, 11           35, 7                    49,   
    + shift + ', x' + scalestr + ',  : ' + ComboBox1.Text);

    ListBox2.ItemIndex:=ListBox2.Items.Count - 1;
    FlushSegs;
    //RepaintSelectedSegs;
    if (CheckBox3.Checked) then begin
      CheckListBox2.LockSelectionChange;
      RefSubCheckBox.LockSelectionChange;
      For c:=0 to CheckListBox2.Items.Count - 1 do begin
        if CheckListBox2.Checked[c] then CheckListBox2.Checked[c]:=False;
      end;
      For c:=0 to RefSubCheckBox.Items.Count - 1 do begin
        if RefSubCheckBox.Checked[c] then RefSubCheckBox.Checked[c]:=False;
      end;
      CheckListBox2.UnlockSelectionChange;
      RefSubCheckBox.UnlockSelectionChange;
    end;
  end;
end;

procedure TForm1.Button3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  Button3Click(Sender);
  Button2Click(Sender);
  Button1Click(Sender);
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  fn: string;
begin
  if not ValuesValid then Exit;
  if ListBox2.ItemIndex < 0 then begin
    ErrorMessage('?..','  , -  ...');
    exit;
  end;
  fn:=ListBox2.Items[ListBox2.ItemIndex];
  fn:=Copy(fn, 59, length(fn) - 58);
  ListBox2.Items[ListBox2.ItemIndex]:=
    Trim(T1Edit.Text) + '..' + Trim(T2Edit.Text) + ', '
    + ShEdit.Text + ', x'
    + FloatToStrF(StrToFloat(ScEdit.Text), ffFixed, 0, 5) + ',  : ' + fn;
  FlushSegs;
  RepaintSelectedSegs;
end;

//  :
procedure TForm1.Button6Click(Sender: TObject);
begin
  if ListBox2.ItemIndex < 0 then begin
    ErrorMessage('?..','  , .');
    exit;
  end;
  ListBox2.Items.Delete(ListBox2.ItemIndex);
  FlushSegs;
end;

procedure TForm1.Button7Click(Sender: TObject);
var t1s, t2s, shs, scs: string;
begin
  if (not Self.ValuesValid()) then exit;
  t1s:=T1Edit.Text;
  t2s:=T2Edit.Text;
  shs:=ShEdit.Text;
  scs:=ScEdit.Text;
  ListBox2.Items.Add('00:00:00,000..00:00:01,000, +00:00:00,000, x1.00000,  : '
    + ComboBox1.Text);
  ListBox2.ItemIndex:=ListBox2.Items.Count - 1;
  T1Edit.Text:=t1s;
  T2Edit.Text:=t2s;
  ShEdit.Text:=shs;
  ScEdit.Text:=scs;
  Button5Click(nil);
end;

procedure TForm1.Button8Click(Sender: TObject);
var
  sstart, send, dstart, dend, c, i: integer;
  y1, y2: boolean;
begin
  y1:=false;
  y2:=false;
  sstart:=MaxInt;
  send:=0;
  if Assigned(SrcSub) then
    For c:=0 to SrcSub.Count -1 do begin
      if CheckListBox2.Selected[c] then begin
        y1:=True;
        sstart:=min(sstart, StrToInt(Copy(SrcSub[c], 1, 10)));
        send:=max(send, StrToInt(Copy(SrcSub[c], 1, 10)) + StrToInt(Copy(SrcSub[c], 11, 10)) - 1);
      end;
    end;
  dend:=0;
  dstart:=MaxInt;
  if Assigned(RefSub) then
    For c:=0 to RefSub.Count - 1 do begin
      if RefSubCheckBox.Selected[c] then begin
        y2:=True;
        dstart:=min(dstart, StrToInt(Copy(RefSub[c], 1, 10)));
        dend:=max(dend, StrToInt(Copy(RefSub[c], 1, 10)) + StrToInt(Copy(RefSub[c], 11, 10)) - 1);
      end;
    end;
  if not y1 then begin
    ErrorMessage('!','  -   !');
    Exit;
  end;
{  if not y2 then begin
    ErrorMessage('!','      !');
    Exit;
  end; }
//(Sender as TButton).Caption:=Format ('%d   %d   %d   %d',[sstart,send, dstart, dend]);
  T1Edit.Text:=MsToSrtTime(sstart);
  T2Edit.Text:=MsToSrtTime(send);
  if y2
    then ShEdit.Text:=MsToSrtTime(abs(dstart - sstart))
    else ShEdit.Text:=MsToSrtTime(0);
  if dstart < sstart then ShEdit.Text:='-' + ShEdit.Text
                     else ShEdit.Text:='+' + ShEdit.Text;
  if y2
    then ScEdit.Text:=FloatToStr((dend - dstart) / max(1, send - sstart))
    else ScEdit.Text:=FloatToStr(1.0);
    
  if Sender = Button8 then Button7.Click
                      else Button5.Click;
  if (CheckBox3.Checked) then begin
    For c:=0 to CheckListBox2.Items.Count - 1 do
      CheckListBox2.Selected[c]:=False;
    if y2 then
      For c:=0 to RefSubCheckBox.Items.Count - 1 do
        RefSubCheckBox.Selected[c]:=False;
  end;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin

  FlushSegs;
  RepaintSelectedSegs;
end;

procedure TForm1.CheckBox1Change(Sender: TObject);
var i: integer;
begin
  i:=0;
  if CheckBox1.Checked then i:=1;
  Reg.Int['DeveloperModeByDefault']:=i;
  Reg.Flush;
end;

procedure TForm1.CheckBox2Change(Sender: TObject);
var i: integer;
begin
  i:=0;
  if CheckBox2.Checked then i:=1;
  Reg.Int['KillSrtTags']:=i;
  Reg.Flush;
end;

procedure TForm1.CheckBox3Change(Sender: TObject);
begin
  Project.Bool['ClearSelections']:=CheckBox3.Checked;
end;

procedure TForm1.CheckListBox1Click(Sender: TObject);
var
  c, n: integer;
begin
 With CheckListBox1 do For c:=0 to Items.Count - 1 do begin
   n:=ComboBox1.Items.IndexOf(Items[c]);
   if Checked[c] then begin
     if n < 0
       then ComboBox1.Items.Add(Items[c]);
   end
   else begin
     if n >= 0
       then ComboBox1.Items.Delete(n);
   end;
 end;
 Project.SetList('SelectedSourcesList', ComboBox1.Items);
 Project.Flush;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var
  c: integer;
  fn: string;
begin
  CheckListBox2.Clear;
  if Assigned(SrcSub) then begin
    SrcSub.Free;
    SrcSub:=nil;
  end;

  fn:={$ifdef unix}
        ExtractFilePath(Project.FileName)
      {$else}
        ExtractFilePath(Project.FileName)
//        Dir
      {$endif}
         + ComboBox1.Text;
  if not FileExists(fn) then begin
    ErrorMessage('  !', fn);
    Exit;
  end;
  
  Try
    SrcSub:=TScript.CreateFromFile(fn);
  Except
    ErrorMessage('  !', (ExceptObject as Exception).Message);
    Exit;
  End;
  SrcSub.Sort;
  For c:=0 to SrcSub.Count - 1 do
    CheckListBox2.Items.Add(SrcSub.GetRefLine(c));
{      MsToSrtTime(StrToInt(Copy(SrcSub.Strings[c],1,10)))
      + '  ' + SrcSub.GetText(c));//Copy(SrcSub.Strings[c], 21, Length(SrcSub.Strings[c]) - 20));
}
  RepaintSelectedSegs;
  Project[DestSrtNameEdit.Text + '/ActiveSource']:=ComboBox1.Text;
end;



procedure TForm1.DeleteDestSRTSafetyClampChange(Sender: TObject);
begin
  DeleteDestSRTButton.Enabled:=DeleteDestSRTSafetyClamp.Checked;
end;


procedure TForm1.DestFilesPageResize(Sender: TObject);
begin
  SrcFilesBox.Width:=(DestFilesPage.ClientWidth - 10) div 2;
  RipFilesBox.Width:=DestFilesPage.ClientWidth - (SrcFilesBox.Left + SrcFilesBox.Width) - 4;
  RipFilesBox.Left:=(SrcFilesBox.Left + SrcFilesBox.Width) + 2;
  RipFilesBox.Height:=(DestFilesPage.ClientHeight - RipFilesBox.Top) - 2;
  SrcFilesBox.Height:=(DestFilesPage.ClientHeight - SrcFilesBox.Top) - 2;
end;

procedure TForm1.DestSRTNameEditChange(Sender: TObject);
var
  e: boolean;
  c: integer;
begin
  e:=false;
  //Checking if the file name is valid
  with DestSRTNameEdit do
    if (Text > '') and (Text[1] in ['0'..'9', 'A'..'']) then begin
      e:=true;
      For c:=2 to length(Text) do
        if not (Text[c] in [' ','+','-','(',')','.',',','0'..'9', 'A'..''])
          then e:=False;
    end;
  AddDestSrtButton.Enabled:=e;
  Project['CurrentDestFile']:=DestSRTNameEdit.Text;
end;


procedure TForm1.DestSRTNameEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=13 then AddDestSRTButtonClick(Self);
end;

procedure TForm1.Form1ChangeBounds(Sender: TObject);
begin
  if Activated then begin
    if WindowState = wsMaximized then Reg.Int['FormMaximized']:=1
    else begin
      Reg.Int['FormWidth']:=Form1.Width;
      Reg.Int['FormHeight']:=Form1.Height;
      Reg.Int['FormTop']:=Form1.Top;
      Reg.Int['FormLeft']:=Form1.Left;
      Reg.Int['FormMaximized']:=0;
    end;
    Reg.Flush;
  end;
end;

procedure TForm1.Form1Close(Sender: TObject; var CloseAction: TCloseAction);
begin
  if Assigned(Form4) then Form4.Close;
end;


initialization
  {$I srtretimer_main.lrs}
finalization
  if assigned(project) then Project.Free;
  Reg.Free;
end.

