procedure Crash(text: string);
begin
  Raise Exception.Create(text);
end;

function GO: boolean;
var
  c, nfile, nseg: integer;
  Files, Segs: TStringList;
  Src, Dst: TSrtScript;
  Sstart, Send, Sshift, Pstart, Pduration: integer;
  Sscale: real;
  Sname, Ptext, DestDir: string;
begin

  if not Assigned(Project) then begin
    ErrorMessage('?..',',       , ?..');
    Exit;
  end;
  
  Result:=True;

{$ifdef guiversion}
  MainForm.Enabled:=False;
  Form3.Progress(1,0);
  Form3.Visible:=True;
{$endif}

  Files:=TStringList.Create;
  Segs:=TStringList.Create;

  DestDir:=ChangeFileExt(Project.Filename, '') + slash;

  Try
    //  
    Project.GetList('Rip/Script List', Files);
    if Files.Count = 0 then Crash ('  SRT !');
    if not DirectoryExists(DestDir) then Try
      CreateDir(DestDir)
    Except
      Crash(Format('    "%s".   : "%s"',
        [DestDir, (ExceptObject as Exception).Message]));
    End;
    For nfile:=0 to Files.Count - 1 do begin
      Project.GetList('Rip/' + Files[nfile], Segs);
      if Segs.Count = 0 then Crash (
        Format('       "%s"!',[Files[nfile]]));
      Dst:=TSrtScript.CreateNewFile(DestDir + Files[nfile]);
      Dst.Modified:=True;
      For nseg:=0 to Segs.Count - 1 do begin
        Sname:=Copy(Segs[nseg], 59, Length(Segs[nseg]) - 58);
        Src:= TSrtScript.CreateFromFile(
          ExtractFilePath(Project.FileName) + Sname);
{ :
00:00:00,000..00:01:01,152, +00:00:27,594, x1,00000, from ???????.srt}
        Sstart:=SrtTimeToMs(Copy(Segs[nseg], 1, 12));
        Send:=SrtTimeToMs(Copy(Segs[nseg], 15, 12));
        Sshift:=SrtTimeToMs(Copy(Segs[nseg], 30, 12));
        if Copy(Segs[nseg], 29, 1) = '-' then Sshift:= -SShift;
        Sscale:=StrToFloat(Copy(Segs[nseg], 45, 7));

          //   :
        For c:=0 to Src.Count - 1 do begin
          Pstart:=StrToInt(Copy(Src[c], 1, 10));
          Pduration:=StrToInt(Copy(Src[c], 11, 10));
          Ptext:=Copy(Src[c], 21, Length(Src[c]) - 20);
          if (Pstart >= Sstart) and (Pstart < Send) then begin
            //    ,    
            Pstart:=Trunc((Pstart - Sstart) * Sscale) + Sstart + SShift;
            Pduration:=Trunc(Pduration * Sscale);
            Dst.Add(Format('%.10d%.10d%s',
                           [Pstart, Pduration, Ptext]));
          end;
        end;
        Src.Free;
        Form3.Progress(Files.Count - 1, nfile);
        Application.ProcessMessages;
      end;
      Dst.Sort;
      Dst.Flush;
      Dst.Free;
    end;
  Except
    Result:=False;
  {$ifdef guiversion}
    Form3.Visible:=False;
    MainForm.Visible:=False;
    Application.ProcessMessages;
  {$endif}
    ErrorMessage(' !', (ExceptObject as Exception).Message);
  {$ifdef guiversion}
    MainForm.Visible:=True;
  {$endif}
  End;
 {$ifdef guiversion}
  MainForm.Enabled:=True;
  MainForm.SetFocus;
  Form3.Visible:=False;
 {$endif}
end;

procedure ErrorMessage(capt, txt: string);
begin
  {$ifdef win32}
   MessageBox(0, PChar(txt), PChar(Capt), MB_Iconerror);
  {$else}
    {$ifdef guiversion}
      Application.CreateForm(TForm2, Form2);
      Form2.Caption:=capt;
      Form2.Memo1.Lines.Text:=txt;
      Repeat
       Application.ProcessMessages
      until not Assigned(Form2);
    {$else}
      WriteLn;
      WriteLn;
      WriteLn(capt);
      WriteLn(txt);
      WriteLn;
      WriteLn(' Enter  .');
      ReadLn;
    {$endif}
  {$endif}
end;

Procedure InitRg;
begin
  DecimalSeparator:='.';
  StartDir:=ExtractFilePath(ParamStr(0));
  Reg:=TTeXtruct.Create(StartDir + 'RipRetimer.cfg');
end;


