(******************************************************************************
 *                                                                            *
 *      ,  2002                                 *
 *                                                                            *
 *  :       main.pas                                                      *
 *  :      DirectInput     *
 *                                                                            *
 ******************************************************************************)
unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, StdCtrls,
  ExtCtrls;

type
  TForm1 = class(TForm)
    gb1: TGroupBox;
    lbX0: TLabel;
    lbY0: TLabel;
    lbX: TLabel;
    lbY: TLabel;
    lb1: TLabel;
    lb2: TLabel;
    lb3: TLabel;
    lb4: TLabel;
    lbBtn1: TLabel;
    lbBtn2: TLabel;
    lbBtn3: TLabel;
    lbBtn4: TLabel;
    imCursor: TImage;
    lbEMail: TLabel;
    Label1: TLabel;
    lbZ: TLabel;
    imCursor1: TImage;
    imCursor2: TImage;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    lb1x: TLabel;
    lb1y: TLabel;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    lb2x: TLabel;
    lb2y: TLabel;
    GroupBox3: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    lb3x: TLabel;
    lb3y: TLabel;
    imCursor3: TImage;
    Label8: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Idle( Sender: TObject; var Done: Boolean );
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  DirectInput8;




//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
const
  CURSOR_SPEED = 2.0;

var
  lpDI8:       IDirectInput8       = nil;
  lpDIMouse: array of IDirectInputDevice8;
  MouseGUID: array of TGUID;

  dwMouseXPos: DWORD = 0;
  dwMouseYPos: DWORD = 0;
  dwMouseZPos: DWORD = 0;

  dwMouse1XPos: DWORD = 0;
  dwMouse1YPos: DWORD = 0;

  dwMouse2XPos: DWORD = 0;
  dwMouse2YPos: DWORD = 0;

  dwMouse3XPos: DWORD = 0;
  dwMouse3YPos: DWORD = 0;
//------------------------------------------------------------------------------
// :      DIEnumCallback()
// :     
//------------------------------------------------------------------------------
function DIEnumCallback( var lpddi: TDIDeviceInstanceA; pvRef: Pointer ):
  Integer; stdcall;
var
  desc: string;
begin
  //     .
  // :   DirectInput     
  //  , . .     .  
  // ""   ,    . ,
  //     DI8DEVTYPE_FLIGHT,    DI8DEVTYPE_GAMEPAD
  //     
  if GET_DIDEVICE_TYPE( lpddi.dwDevType ) = DI8DEVTYPE_MOUSE then begin
    SetLength(MouseGUID, Length(MouseGuid)+1);
    MouseGUID[High(MouseGUID)]:=lpddi.guidInstance;
  end;
  Result := DIENUM_CONTINUE;
end;


//------------------------------------------------------------------------------
// :      InitDirectInput()
// :    DirectInput  
//------------------------------------------------------------------------------
function InitDirectInput( hWnd: HWND ): Boolean;
var
  dipropdw: TDIPROPDWORD; //     
  i: integer;
begin
  Result := FALSE;

  //    DirectInput
  if FAILED( DirectInput8Create( GetModuleHandle( 0 ), DIRECTINPUT_VERSION,
                                 IID_IDirectInput8, lpDI8, nil ) ) then
     Exit;

   if FAILED( lpDI8.EnumDevices( DI8DEVCLASS_ALL, DIEnumCallback, nil,
                                DIEDFL_ALLDEVICES ) ) then
  begin
    MessageBox( Form1.Handle, '   !',
                '!', MB_ICONHAND );
    Form1.Close();
  end;

SetLength(lpDIMouse, Length(MouseGUID));
for i:=0 to High(MouseGUID) do begin
  //      
  if FAILED( lpDI8.CreateDevice( MouseGUID[i], lpDIMouse[i], nil ) ) then
     Exit;
  lpDIMouse[i]._AddRef();

  //    
  if FAILED( lpDIMouse[i].SetDataFormat( @c_dfDIMouse ) ) then
     Exit;

  //   
  if FAILED( lpDIMouse[i].SetCooperativeLevel( hWnd, DISCL_FOREGROUND or
                                                  DISCL_EXCLUSIVE ) ) then
     Exit;

  //  
  lpDIMouse[i].Acquire();
end;

  Result := TRUE;
end;




//------------------------------------------------------------------------------
// :      ReleaseDirectInput()
// :    DirectInput
//------------------------------------------------------------------------------
procedure ReleaseDirectInput();
var i: integer;
begin
  //      
 For i:=0 to High(lpDIMouse) do begin
  if lpDIMouse[i] <> nil then
  begin
    lpDIMouse[i].Unacquire();
    lpDIMouse[i]._Release();
    lpDIMouse[i] := nil;
  end;
end;

  //    DirectInput ( )
  if lpDI8 <> nil then
  begin
    lpDI8._Release();
    lpDI8 := nil;
  end;
end;




//------------------------------------------------------------------------------
// :      GetMouseCaps()
// :    ( - )
//------------------------------------------------------------------------------
procedure GetMouseCaps();
var
  lpCaps: TDIDEVCAPS; //       
begin
  //   TDIDEVCAPS (   )
  ZeroMemory( @lpCaps, SizeOf( TDIDEVCAPS ) );
  lpCaps.dwSize := SizeOf( TDIDEVCAPS );

  //   ,     lpCaps
  lpDIMouse[0].GetCapabilities( lpCaps );

  //  GUI   
  with Form1 do
  begin
    if lpCaps.dwButtons > 0 then
    begin
      lb1.Enabled := TRUE; lbBtn1.Enabled := TRUE;
    end;

    if lpCaps.dwButtons > 1 then
    begin
      lb2.Enabled := TRUE; lbBtn2.Enabled := TRUE;
    end;

    if lpCaps.dwButtons > 2 then
    begin
      lb3.Enabled := TRUE; lbBtn3.Enabled := TRUE;
    end;

    if lpCaps.dwButtons > 3 then
    begin
      lb4.Enabled := TRUE; lbBtn4.Enabled := TRUE;
    end;
  end;
end;




//------------------------------------------------------------------------------
// :      UpdateMouseState()
// :        
//------------------------------------------------------------------------------
function UpdateMouseState(n: integer; var(* *)x, y, z: DWORD ): Boolean;
var
  ms: TDIMOUSESTATE;
begin
  Result := FALSE;

  //    
  if lpDImouse[n].GetDeviceState( SizeOf( TDIMOUSESTATE ), @ms ) = DIERR_INPUTLOST then
  begin
    //  
    lpDIMouse[n].Acquire();
    //   ,  
    if FAILED( lpDImouse[n].GetDeviceState( SizeOf( TDIMOUSESTATE ), @ms ) ) then
       Exit;
  end;

  with Form1 do
  begin
    //         
    if ms.lX < 0 then ms.lX := Round( ms.lX * CURSOR_SPEED ) else
    if ms.lX > 0 then ms.lX := Round( ms.lX * CURSOR_SPEED );

    if ms.lY < 0 then ms.lY := Round( ms.lY * CURSOR_SPEED ) else
    if ms.lY > 0 then ms.lY := Round( ms.lY * CURSOR_SPEED );

    x := ms.lX ;
    y := ms.lY;
    z := ms.lZ;

    //------

    if ms.rgbButtons[ 0 ] = $080 then lbBtn1.Caption := ''
                                 else lbBtn1.Caption := '';
    if ms.rgbButtons[ 1 ] = $080 then lbBtn2.Caption := ''
                                 else lbBtn2.Caption := '';
    if ms.rgbButtons[ 2 ] = $080 then lbBtn3.Caption := ''
                                 else lbBtn3.Caption := '';
    if ms.rgbButtons[ 3 ] = $080 then lbBtn4.Caption := ''
                                 else lbBtn4.Caption := '';
  end;

  Result := TRUE;
end;




//------------------------------------------------------------------------------
// :      TForm1.Idle()
// :     
//------------------------------------------------------------------------------
procedure TForm1.Idle( Sender: TObject; var Done: Boolean );
var
  dwOffsX,
  dwOffsY,
  dwOffsZ: DWORD; //  
begin
  //       offsX  offsY
  if not UpdateMouseState(0, dwOffsX, dwOffsY, dwOffsZ ) then
  begin
    MessageBox( Form1.Handle, '   0!',
                '!', MB_ICONHAND );
    Form1.Close();
  end;
  Done := FALSE;
  //   
  Inc( dwMouseXPos, dwOffsX );
  Inc( dwMouseYPos, dwOffsY );
  Inc( dwMouseZPos, dwOffsZ );

  lbX.Caption := Format( '%d', [ dwMouseXPos ] );
  lbY.Caption := Format( '%d', [ dwMouseYPos ] );
  lbZ.Caption := Format( '%d', [ dwMouseZPos ] );

  imCursor.Left := 234 + dwMouseXPos; // 234 - ,   , 
  imCursor.Top  := 234 + dwMouseYPos; //        

  if High(lpdiMouse) < 1 then exit;
  if not UpdateMouseState(1, dwOffsX, dwOffsY, dwOffsZ ) then
  begin
    MessageBox( Form1.Handle, '   1!', '!', MB_ICONHAND );
    Form1.Close();
  end;
  Inc( dwMouse1XPos, dwOffsX );
  Inc( dwMouse1YPos, dwOffsY );
  imCursor1.Left := 234 + dwMouse1XPos;
  imCursor1.Top  := 234 + dwMouse1YPos;
  lb1X.Caption := Format( '%d', [ dwMouse1XPos ] );
  lb1Y.Caption := Format( '%d', [ dwMouse1YPos ] );

  if High(lpdiMouse) < 2 then exit;
  if not UpdateMouseState(2, dwOffsX, dwOffsY, dwOffsZ ) then
  begin
    MessageBox( Form1.Handle, '   1!', '!', MB_ICONHAND );
    Form1.Close();
  end;
  Inc( dwMouse2XPos, dwOffsX );
  Inc( dwMouse2YPos, dwOffsY );
  imCursor2.Left := 234 + dwMouse2XPos;
  imCursor2.Top  := 234 + dwMouse2YPos;
  lb2X.Caption := Format( '%d', [ dwMouse2XPos ] );
  lb2Y.Caption := Format( '%d', [ dwMouse2YPos ] );

  if High(lpdiMouse) < 3 then exit;
  if not UpdateMouseState(3, dwOffsX, dwOffsY, dwOffsZ ) then
  begin
    MessageBox( Form1.Handle, '   1!', '!', MB_ICONHAND );
    Form1.Close();
  end;
  Inc( dwMouse3XPos, dwOffsX );
  Inc( dwMouse3YPos, dwOffsY );
  imCursor3.Left := 234 + dwMouse3XPos;
  imCursor3.Top  := 234 + dwMouse3YPos;
  lb3X.Caption := Format( '%d', [ dwMouse3XPos ] );
  lb3Y.Caption := Format( '%d', [ dwMouse3YPos ] );

end;




//------------------------------------------------------------------------------
// :      TForm1.FormActivate()
// :   DirectInput   
//------------------------------------------------------------------------------
procedure TForm1.FormActivate(Sender: TObject);
begin
  if not InitDirectInput( Form1.Handle ) then
  begin
    MessageBox( Form1.Handle, '   DirectInput!',
                '!', MB_ICONHAND );
    Form1.Close();
  end;

  //    ( ?). ,    - 
  // ,     ?
  GetMouseCaps();

  //  UI   
  lbBtn1.Caption := '';
  lbBtn2.Caption := '';
  lbBtn3.Caption := '';
  lbBtn4.Caption := '';
  imCursor.Left := 184; //   
  imCursor.Top  := 184;

  Application.OnIdle := Idle;
end;




//------------------------------------------------------------------------------
// :      TForm1.FormKeyDown()
// :   
//------------------------------------------------------------------------------
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE then Form1.Close();
end;




//------------------------------------------------------------------------------
// :      TForm1.FormDestroy()
// :      
//------------------------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  ReleaseDirectInput();
end;

end.
