{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************
 
   This header contains OpenGL constants and function definitions
    converted manually from the OpenGL documentation available
    in the Internet

 **********************************************************************}

procedure CheckGlError;

type
  GLenum        = Cardinal;     PGLenum      = ^GLenum;
  GLboolean     = Byte;         PGLboolean   = ^GLboolean;
  GLbitfield    = Cardinal;     PGLbitfield  = ^GLbitfield;
  GLbyte        = ShortInt;     PGLbyte      = ^GLbyte;
  GLshort       = SmallInt;     PGLshort     = ^GLshort;
  GLint         = Integer;      PGLint       = ^GLint;
  GLsizei       = Integer;      PGLsizei     = ^GLsizei;
  GLubyte       = Byte;         PGLubyte     = ^GLubyte;
  GLushort      = Word;         PGLushort    = ^GLushort;
  GLuint        = Cardinal;     PGLuint      = ^GLuint;
  GLfloat       = Single;       PGLfloat     = ^GLfloat;      PPGLfloat = ^PGLfloat;
  GLclampf      = Single;       PGLclampf    = ^GLclampf;
  GLdouble      = Double;       PGLdouble    = ^GLdouble;
  GLclampd      = Double;       PGLclampd    = ^GLclampd;
                                PGLvoid      = Pointer;       PPGLvoid = ^PGLvoid;
  GLsizeiptrARB = Integer;
  GLintptrARB   = Integer;
  GLhandleARB   = Cardinal;     PGLHandleARB = ^GLHandleARB;
  GLcharARB     = Char;         PGLcharARB   = PChar;         PPGLcharARB = ^PGLcharARB;

  PVector3f = ^TVector3f;
  TVector3f = array [0..2] of GLfloat;
  PVector4f = ^TVector4f;
  TVector4f = array [0..3] of GLfloat;
  glFloatArray = array of glFloat; glFloat2dArray = array of glFloatArray;


const
  GL_ALPHA             = $1906;
  GL_RGB               = $1907;
  GL_RGBA              = $1908;
  GL_LUMINANCE         = $1909;
  GL_LUMINANCE_ALPHA   = $190A;
  GL_BGR               = $80E0;
  GL_BGRA              = $80E1;
  GL_RED               = $1903;
  GL_GREEN             = $1904;
  GL_BLUE              = $1905;
  GL_COLOR_INDEX       = $1900;
  GL_STENCIL_INDEX     = $1901;
  GL_DEPTH_COMPONENT   = $1902;


  GL_TEXTURE_1D  = $0DE0;
  GL_TEXTURE_2D  = $0DE1;
  GL_TEXTURE_3D  = $806F;

  GL_MAX_TEXTURE_SIZE     = $0D33;
  GL_MAX_3D_TEXTURE_SIZE  = $8073;

  GL_TEXTURE_DEPTH  = $8071;

  GL_TEXTURE_WRAP_S  = $2802;
  GL_TEXTURE_WRAP_T  = $2803;
  GL_TEXTURE_WRAP_R  = $8072;
  
  GL_CLAMP   = $2900;
  GL_REPEAT  = $2901;

  GL_NEAREST                 = $2600;
  GL_LINEAR                  = $2601;
  GL_NEAREST_MIPMAP_NEAREST  = $2700;
  GL_LINEAR_MIPMAP_NEAREST   = $2701;
  GL_NEAREST_MIPMAP_LINEAR   = $2702;
  GL_LINEAR_MIPMAP_LINEAR    = $2703;

  GL_TEXTURE_MAG_FILTER  = $2800;
  GL_TEXTURE_MIN_FILTER  = $2801;
  
  GL_UNSIGNED_BYTE  = $1401;
  GL_FLOAT          = $1406;
  GL_EXTENSIONS     = $1F03;
  
  GL_DEPTH_TEST  = $0B71;
  
  GL_VENDOR    = $1F00;
  GL_RENDERER  = $1F01;
  GL_VERSION   = $1F02;

  GL_ALPHA_TEST  = $0BC0;
  GL_BLEND       = $0BE2;
  GL_CULL_FACE   = $0B44;

  GL_NEVER     = $0200;
  GL_LESS      = $0201;
  GL_EQUAL     = $0202;
  GL_LEQUAL    = $0203;
  GL_GREATER   = $0204;
  GL_NOTEQUAL  = $0205;
  GL_GEQUAL    = $0206;
  GL_ALWAYS    = $0207;

  GL_ZERO                 = $0000;
  GL_ONE                  = $0001;
  GL_SRC_COLOR            = $0300;
  GL_ONE_MINUS_SRC_COLOR  = $0301;
  GL_SRC_ALPHA            = $0302;
  GL_ONE_MINUS_SRC_ALPHA  = $0303;
  GL_DST_ALPHA            = $0304;
  GL_ONE_MINUS_DST_ALPHA  = $0305;
  
  GL_POINTS          = $0000;
  GL_LINES           = $0001;
  GL_LINE_LOOP       = $0002;
  GL_LINE_STRIP      = $0003;
  GL_TRIANGLES       = $0004;
  GL_TRIANGLE_STRIP  = $0005;
  GL_TRIANGLE_FAN    = $0006;
  GL_QUADS           = $0007;
  GL_QUAD_STRIP      = $0008;
  GL_POLYGON         = $0009;



  GL_MODELVIEW    = $1700;
  GL_PROJECTION   = $1701;
  GL_TEXTURE      = $1702;
  
  GL_DEPTH_BUFFER_BIT = $0100;
  GL_COLOR_BUFFER_BIT = $4000;
  
  GL_TRUE   = $01;
  GL_FALSE  = $00;
  
  GL_FRONT = $0404;
  GL_BACK  = $0405;
  
  GL_LINE_SMOOTH = $0B20;
  GL_TEXTURE_MAX_ANISOTROPY_EXT = $84FE;

  GL_SCISSOR_TEST = $0C11;




var
  glGetString: function(name: GLenum): PChar; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetIntegerv: procedure(pname: GLenum; params: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetFloatv: procedure(pname: GLenum; params: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glTexImage2D: procedure(target: GLenum; level, internalformat: GLint; width, height: GLsizei; border: GLint; format, atype: GLenum; const pixels: PGLvoid); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glTexParameterf: procedure(target: GLenum; pname: GLenum; param: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex2f: procedure(x, y: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glAlphaFunc: procedure(func: GLenum; ref: GLclampf); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glBegin: procedure(mode: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glBindTexture: procedure(target: GLenum; texture: GLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glColor4f: procedure(red, green, blue, alpha: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glColor3f: procedure(red, green, blue: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glColor4fv: procedure(const v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glBlendFunc: procedure(sfactor, dfactor: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDeleteTextures: procedure(n: GLsizei; const textures: PGLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDisable: procedure(cap: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glEnd: procedure; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glEnable: procedure(cap: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGenTextures: procedure(n: GLsizei; textures: PGLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glLoadIdentity: procedure; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glMatrixMode: procedure(mode: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glNormal3f: procedure(nx, ny, nz: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glTexCoord2f: procedure(s, t: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glOrtho: procedure(left, right, bottom, top, zNear, zFar: GLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glViewport: procedure(x, y: GLint; width, height: GLsizei); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glLineWidth: procedure(width: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glFinish: procedure; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glFlush: procedure; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetError: function: GLenum; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glScissor: procedure(x, y: GLint; width, height: GLsizei); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;


  glVertex2fv: procedure(const v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex2i: procedure(x, y: GLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex2iv: procedure(const v: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex3f: procedure(x, y, z: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex3fv: procedure(const v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex3i: procedure(x, y, z: GLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex3iv: procedure(const v: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex4f: procedure(x, y, z, w: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex4fv: procedure(const v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex4i: procedure(x, y, z, w: GLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertex4iv: procedure(const v: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexPointer: procedure(size: GLint; atype: GLenum; stride: GLsizei; const pointer: Pointer); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;



  glClear: procedure(mask: GLbitfield); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glClearColor: procedure (red, green, blue, alpha: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glCullFace: procedure(mode: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDepthFunc: procedure(func: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDepthMask: procedure(flag: GLboolean); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glFrustum: procedure(left, right, bottom, top, zNear, zFar: GLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glPopMatrix: procedure; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glPushMatrix: procedure; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glRotatef: procedure(angle, x, y, z: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glScalef: procedure(x, y, z: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glTranslatef: procedure(x, y, z: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

const
  GL_ALPHA4                         = $803B;
  GL_ALPHA8                         = $803C;
  GL_ALPHA12                        = $803D;
  GL_ALPHA16                        = $803E;
  GL_LUMINANCE4                     = $803F;
  GL_LUMINANCE8                     = $8040;
  GL_LUMINANCE12                    = $8041;
  GL_LUMINANCE16                    = $8042;
  GL_LUMINANCE4_ALPHA4              = $8043;
  GL_LUMINANCE6_ALPHA2              = $8044;
  GL_LUMINANCE8_ALPHA8              = $8045;
  GL_LUMINANCE12_ALPHA4             = $8046;
  GL_LUMINANCE12_ALPHA12            = $8047;
  GL_LUMINANCE16_ALPHA16            = $8048;
  GL_INTENSITY                      = $8049;
  GL_INTENSITY4                     = $804A;
  GL_INTENSITY8                     = $804B;
  GL_INTENSITY12                    = $804C;
  GL_INTENSITY16                    = $804D;
  GL_R3_G3_B2                       = $2A10;
  GL_RGB4                           = $804F;
  GL_RGB5                           = $8050;
  GL_RGB8                           = $8051;
  GL_RGB10                          = $8052;
  GL_RGB12                          = $8053;
  GL_RGB16                          = $8054;
  GL_RGBA2                          = $8055;
  GL_RGBA4                          = $8056;
  GL_RGB5_A1                        = $8057;
  GL_RGBA8                          = $8058;
  GL_RGB10_A2                       = $8059;
  GL_RGBA12                         = $805A;
  GL_RGBA16                         = $805B;
  GL_TEXTURE_RED_SIZE               = $805C;
  GL_TEXTURE_GREEN_SIZE             = $805D;
  GL_TEXTURE_BLUE_SIZE              = $805E;
  GL_TEXTURE_ALPHA_SIZE             = $805F;
  GL_TEXTURE_LUMINANCE_SIZE         = $8060;
  GL_TEXTURE_INTENSITY_SIZE         = $8061;
  GL_PROXY_TEXTURE_1D               = $8063;
  GL_PROXY_TEXTURE_2D               = $8064;

  GL_DEPTH_COMPONENT16 = $81A5;
  GL_DEPTH_COMPONENT24 = $81A6;
  GL_DEPTH_COMPONENT32 = $81A7;

  GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = $84FF;

  // *************************    FBO    *********************************

const
  GL_FRAMEBUFFER_EXT  = $8D40;
  GL_RENDERBUFFER_EXT                     = $8D41;
  GL_STENCIL_INDEX1_EXT                   = $8D46;
  GL_STENCIL_INDEX4_EXT                   = $8D47;
  GL_STENCIL_INDEX8_EXT                   = $8D48;
  GL_STENCIL_INDEX16_EXT                  = $8D49;
  GL_RENDERBUFFER_WIDTH_EXT               = $8D42;
  GL_RENDERBUFFER_HEIGHT_EXT              = $8D43;
  GL_RENDERBUFFER_INTERNAL_FORMAT_EXT     = $8D44;
  GL_RENDERBUFFER_RED_SIZE_EXT            = $8D50;
  GL_RENDERBUFFER_GREEN_SIZE_EXT          = $8D51;
  GL_RENDERBUFFER_BLUE_SIZE_EXT           = $8D52;
  GL_RENDERBUFFER_ALPHA_SIZE_EXT          = $8D53;
  GL_RENDERBUFFER_DEPTH_SIZE_EXT          = $8D54;
  GL_RENDERBUFFER_STENCIL_SIZE_EXT        = $8D55;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT             = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT             = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT           = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT   = $8CD3;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT      = $8CD4;
  GL_COLOR_ATTACHMENT0_EXT    = $8CE0;
  GL_COLOR_ATTACHMENT1_EXT    = $8CE1;
  GL_COLOR_ATTACHMENT2_EXT    = $8CE2;
  GL_COLOR_ATTACHMENT3_EXT    = $8CE3;
  GL_COLOR_ATTACHMENT4_EXT    = $8CE4;
  GL_COLOR_ATTACHMENT5_EXT    = $8CE5;
  GL_COLOR_ATTACHMENT6_EXT    = $8CE6;
  GL_COLOR_ATTACHMENT7_EXT    = $8CE7;
  GL_COLOR_ATTACHMENT8_EXT    = $8CE8;
  GL_COLOR_ATTACHMENT9_EXT    = $8CE9;
  GL_COLOR_ATTACHMENT10_EXT   = $8CEA;
  GL_COLOR_ATTACHMENT11_EXT   = $8CEB;
  GL_COLOR_ATTACHMENT12_EXT   = $8CEC;
  GL_COLOR_ATTACHMENT13_EXT   = $8CED;
  GL_COLOR_ATTACHMENT14_EXT   = $8CEE;
  GL_COLOR_ATTACHMENT15_EXT   = $8CEF;
  GL_DEPTH_ATTACHMENT_EXT      = $8D00;
  GL_STENCIL_ATTACHMENT_EXT    = $8D20;
  GL_FRAMEBUFFER_COMPLETE_EXT                           = $8CD5;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT              = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT      = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT              = $8CD9;
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT                 = $8CDA;
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT             = $8CDB;
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT             = $8CDC;
  GL_FRAMEBUFFER_UNSUPPORTED_EXT                        = $8CDD;
  GL_FRAMEBUFFER_BINDING_EXT              = $8CA6;
  GL_RENDERBUFFER_BINDING_EXT             = $8CA7;
  GL_MAX_COLOR_ATTACHMENTS_EXT            = $8CDF;
  GL_MAX_RENDERBUFFER_SIZE_EXT            = $84E8;
  GL_INVALID_FRAMEBUFFER_OPERATION_EXT    = $0506;




var
  glIsRenderbuffer: function(renderbuffer: GLuint): GLboolean;  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glBindRenderbuffer: procedure(target: GLEnum; renderbuffer: GLuint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDeleteRenderbuffers: procedure(n: GLint; renderbuffers: PGluint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGenRenderbuffers: procedure (n: GLint; renderbuffers: PGLuint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glRenderbufferStorage: procedure (target, internalformat: GLEnum; width, height: GLint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetRenderbufferParameteriv: procedure (target, pname: GLenum; params: PGLint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glIsFramebuffer: function (framebuffer: GLuint): GLboolean;  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glBindFramebuffer: procedure (target: glEnum; framebuffer: GLuint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDeleteFramebuffers: procedure (n: GLint; framebuffers: PGLuint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGenFramebuffers: procedure (n: GLint; framebuffers: PGLuint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glCheckFramebufferStatus: function (target: GLenum): GLenum;  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glFramebufferTexture1D: procedure (target, attachment, textarget: GLenum; texture: GLuint; level: GLint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glFramebufferTexture2D: procedure (target, attachment, textarget: GLenum; texture: GLuint; level: GLint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glFramebufferTexture3D: procedure (target, attachment, textarget: GLenum; texture: GLuint; level, zoffset: GLint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glFramebufferRenderbuffer: procedure(target, attachment, renderbuffertarget: GLenum; renderbuffer: GLuint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetFramebufferAttachmentParameteriv: procedure (target, attachment, pname: GLenum; params: PGLint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGenerateMipmap: procedure(target: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  

  glAreTexturesResident: function(n: GLsizei; textures: PGLuint; residences: PGLBoolean): GLboolean; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  //GLboolean glAreTexturesResident ( GLsizei n, GLuint * textures, GLboolean * residences );

// *******************  GL_ARB_vertex_buffer_object  ************************

const
  GL_ARRAY_BUFFER_ARB          = $8892;
  GL_ELEMENT_ARRAY_BUFFER_ARB  = $8893;

  GL_ARRAY_BUFFER_BINDING_ARB                  = $8894;
  GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB          = $8895;
  GL_VERTEX_ARRAY_BUFFER_BINDING_ARB           = $8896;
  GL_NORMAL_ARRAY_BUFFER_BINDING_ARB           = $8897;
  GL_COLOR_ARRAY_BUFFER_BINDING_ARB            = $8898;
  GL_INDEX_ARRAY_BUFFER_BINDING_ARB            = $8899;
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB    = $889A;
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB        = $889B;
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB  = $889C;
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB   = $889D;
  GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB           = $889E;

  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB    = $889F;

  GL_STREAM_DRAW_ARB  = $88E0;
  GL_STREAM_READ_ARB  = $88E1;
  GL_STREAM_COPY_ARB  = $88E2;
  GL_STATIC_DRAW_ARB  = $88E4;
  GL_STATIC_READ_ARB  = $88E5;
  GL_STATIC_COPY_ARB  = $88E6;
  GL_DYNAMIC_DRAW_ARB = $88E8;
  GL_DYNAMIC_READ_ARB = $88E9;
  GL_DYNAMIC_COPY_ARB = $88EA;

  GL_READ_ONLY_ARB   = $88B8;
  GL_WRITE_ONLY_ARB  = $88B9;
  GL_READ_WRITE_ARB  = $88BA;

  GL_BUFFER_SIZE_ARB   = $8764;
  GL_BUFFER_USAGE_ARB  = $8765;
  GL_BUFFER_ACCESS_ARB = $88BB;
  GL_BUFFER_MAPPED_ARB = $88BC;

  GL_BUFFER_MAP_POINTER_ARB = $88BD;

var
  glBindBuffer: procedure(target: GLenum; buffer: GLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDeleteBuffers: procedure(n: GLint; const buffers: PGLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGenBuffers: procedure(n: GLint; buffers: PGLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glIsBuffer: function(buffer: GLuint): GLboolean; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glBufferData: procedure(target: GLenum; size: GLsizeiptrARB; data: PGLvoid; usage: GLenum); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glBufferSubData: procedure(target: GLenum; offset: GLintptrARB; size: GLsizeiptrARB; const data: PGLvoid); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetBufferSubData: procedure(target: GLenum; offset: GLintptrARB; size: GLsizeiptrARB; data: PGLvoid); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glMapBuffer: function(target, access: GLenum): PGLvoid; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  
  glUnmapBuffer: function(target: GLenum): GLboolean; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetBufferParameteriv: procedure(target, pname: GLenum; params: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetBufferPointerv: procedure(target, pname: GLenum; params: PGLvoid);{ void **params);} {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;



// **** GL_ARB_fragment_shader | GL_ARB_vertex_shader | GL_ARB_shader_object *****
//          1.4

const
  GL_VERTEX_SHADER_ARB   = $8B31;
  GL_FRAGMENT_SHADER_ARB   = $8B30;

  GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = $8B4A;
  GL_MAX_VARYING_FLOATS_ARB   = $8B4B;
  GL_MAX_VERTEX_ATTRIBS_ARB   = $8869;
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = $8B4C;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = $8B4D;

  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = $8B49;
  GL_MAX_TEXTURE_COORDS_ARB   = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS_ARB  = $8872;

  GL_GL_VERTEX_PROGRAM_POINT_SIZE_ARB  = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE_ARB  = $8643;

  GL_OBJECT_ACTIVE_ATTRIBUTES_ARB  = $8B89;
  GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = $8B8A;

  GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB  = $8622;
  GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB  = $8623;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB  = $8624;
  GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB  = $8625;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = $886A;
  GL_CURRENT_VERTEX_ATTRIB_ARB  = $8626;

  GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB  = $8645;

  GL_FLOAT_VEC2_ARB    = $8B50;
  GL_FLOAT_VEC3_ARB    = $8B51;
  GL_FLOAT_VEC4_ARB    = $8B52;
  GL_FLOAT_MAT2_ARB    = $8B5A;
  GL_FLOAT_MAT3_ARB    = $8B5B;
  GL_FLOAT_MAT4_ARB    = $8B5C;

  GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = $8B8B;
  
  GL_PROGRAM_OBJECT_ARB = $8B40;

  GL_OBJECT_TYPE_ARB = $8B4E;
  GL_OBJECT_SUBTYPE_ARB = $8B4F;
  GL_OBJECT_DELETE_STATUS_ARB = $8B80;
  GL_OBJECT_COMPILE_STATUS_ARB = $8B81;
  GL_OBJECT_LINK_STATUS_ARB = $8B82;
  GL_OBJECT_VALIDATE_STATUS_ARB = $8B83;
  GL_OBJECT_INFO_LOG_LENGTH_ARB = $8B84;
  GL_OBJECT_ATTACHED_OBJECTS_ARB = $8B85;
  GL_OBJECT_ACTIVE_UNIFORMS_ARB = $8B86;
  GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = $8B87;
  GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = $8B88;

  GL_SHADER_OBJECT_ARB = $8B48;


  GL_INT = $1404;
  GL_INT_VEC2_ARB = $8B53;
  GL_INT_VEC3_ARB = $8B54;
  GL_INT_VEC4_ARB = $8B55;
  GL_BOOL_ARB = $8B56;
  GL_BOOL_VEC2_ARB = $8B57;
  GL_BOOL_VEC3_ARB = $8B58;
  GL_BOOL_VEC4_ARB = $8B59;
  GL_SAMPLER_1D_ARB = $8B5D;
  GL_SAMPLER_2D_ARB = $8B5E;
  GL_SAMPLER_3D_ARB = $8B5F;
  GL_SAMPLER_CUBE_ARB = $8B60;
  GL_SAMPLER_1D_SHADOW_ARB = $8B61;
  GL_SAMPLER_2D_SHADOW_ARB = $8B62;
  GL_SAMPLER_2D_RECT_ARB = $8B63;
  GL_SAMPLER_2D_RECT_SHADOW_ARB = $8B64;

var
  glVertexAttrib1f: procedure(index: GLuint; v0: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib1s: procedure(index: GLuint; v0: GLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib1d: procedure(index: GLuint; v0: GLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib2f: procedure(index: GLuint; v0, v1: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib2s: procedure(index: GLuint; v0, v1: GLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib2d: procedure(index: GLuint; v0, v1: GLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib3f: procedure(index: GLuint; v0, v1, v2: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib3s: procedure(index: GLuint; v0, v1, v2: GLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib3d: procedure(index: GLuint; v0, v1, v2: GLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4f: procedure(index: GLuint; v0, v1, v2, v3: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4s: procedure(index: GLuint; v0, v1, v2, v3: GLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4d: procedure(index: GLuint; v0, v1, v2, v3: GLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4Nub: procedure(index: GLuint; x, y, z, w: GLubyte); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glVertexAttrib1fv: procedure(index: GLuint; v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib1sv: procedure(index: GLuint; v: PGLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib1dv: procedure(index: GLuint; v: PGLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib2fv: procedure(index: GLuint; v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib2sv: procedure(index: GLuint; v: PGLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib2dv: procedure(index: GLuint; v: PGLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib3fv: procedure(index: GLuint; v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib3sv: procedure(index: GLuint; v: PGLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib3dv: procedure(index: GLuint; v: PGLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4fv: procedure(index: GLuint; v: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4sv: procedure(index: GLuint; v: PGLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4dv: procedure(index: GLuint; v: PGLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4iv: procedure(index: GLuint; v: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4bv: procedure(index: GLuint; v: PGLbyte); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glVertexAttrib4ubv: procedure(index: GLuint; v: PGLubyte); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4usv: procedure(index: GLuint; v: PGLushort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4uiv: procedure(index: GLuint; v: PGLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glVertexAttrib4Nbv: procedure(index: GLuint; v: PGLbyte); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4Nsv: procedure(index: GLuint; v: PGLshort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4Niv: procedure(index: GLuint; v: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4Nubv: procedure(index: GLuint; v: PGLubyte); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4Nusv: procedure(index: GLuint; v: PGLushort); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glVertexAttrib4Nuiv: procedure(index: GLuint; v: PGLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glVertexAttribPointer: procedure(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; _pointer: PGLvoid); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glEnableVertexAttribArray: procedure(index: GLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDisableVertexAttribArray: procedure(index: GLuint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glBindAttribLocation: procedure(programObj: GLhandleARB; index: GLuint; name: PGLcharARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetActiveAttrib: procedure(programObj: GLhandleARB; index: GLuint; maxLength: GLsizei; length: PGLsizei; size: PGLint; _type: PGLenum; name: PGLcharARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetAttribLocation: function(programObj: GLhandleARB; name: PGLcharARB): GLint; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetVertexAttribdv: procedure(index: GLuint; pname: GLenum; params: PGLdouble); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetVertexAttribfv: procedure(index: GLuint; pname: GLenum; params: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetVertexAttribiv: procedure(index: GLuint; pname: GLenum; params: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetVertexAttribPointerv: procedure(index: GLuint; pname: GLenum; _pointer: PPGLvoid); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;


  glDeleteShader: procedure(obj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glDeleteProgram: procedure(obj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetHandle: function (pname: GLenum): GLhandleARB; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glDetachShader: procedure(containerObj, attachedObj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glCreateShader: function(shaderType: GLenum): GLhandleARB; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glShaderSource: procedure(shaderObj: GLhandleARB; count: GLsizei; _string: PPGLcharARB; length: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glCompileShader: procedure(shaderObj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glCreateProgram: function(): GLhandleARB; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glAttachShader: procedure(containerObj, obj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glLinkProgram: procedure(programObj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glUseProgram: procedure(programObj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glValidateProgram: procedure(programObj: GLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glUniform1f: procedure(location: GLint; v0: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform2f: procedure(location: GLint; v0, v1: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform3f: procedure(location: GLint; v0, v1, v2: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform4f: procedure(location: GLint; v0, v1, v2, v3: GLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glUniform1i: procedure(location, v0: GLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform2i: procedure(location, v0, v1: GLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform3i: procedure(location, v0, v1, v2: GLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform4i: procedure(location, v0, v1, v2, v3: GLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glUniform1fv: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform2fv: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform3fv: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform4fv: procedure(location: GLint; count: GLsizei; value: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glUniform1iv: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform2iv: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform3iv: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniform4iv: procedure(location: GLint; count: GLsizei; value: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glUniformMatrix2fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniformMatrix3fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glUniformMatrix4fv: procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetShaderParameteriv: procedure(obj: GLhandleARB; pname: GLenum; params: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetProgramParameteriv: procedure(obj: GLhandleARB; pname: GLenum; params: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetShaderInfoLog: procedure(obj: GLhandleARB; maxLength: GLsizei; length: PGLsizei; infoLog: PGLcharARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetProgramInfoLog: procedure(obj: GLhandleARB; maxLength: GLsizei; length: PGLsizei; infoLog: PGLcharARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetAttachedShaders: procedure(containerObj: GLhandleARB; maxCount: GLsizei; count: PGLsizei; obj: PGLhandleARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetUniformLocation: function(programObj: GLhandleARB; name: PGLcharARB): GLint; {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetActiveUniform: procedure(programObj: GLhandleARB; index: GLuint; maxLength: GLsizei; length: PGLsizei; size: PGLint; _type: PGLenum; name: PGLcharARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetUniformfv: procedure(programObj: GLhandleARB; location: GLint; params: PGLfloat); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetUniformiv: procedure(programObj: GLhandleARB; location: GLint; params: PGLint); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetShaderSource: procedure(obj: GLhandleARB; MaxLength: GLsizei; length: PGLsizei; source: PGLcharARB); {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;

  glGetObjectParameterfv: procedure(programObj: GLhandleARB; pname: GLenum; params: PGLfloat);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetObjectParameteriv: procedure(programObj: GLhandleARB; pname: GLenum; params: PGLint);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;
  glGetInfoLog: procedure(programObj: GLhandleARB; maxLength: GLsizei; length: PGLsizei; infoLog: PGLcharARB);  {$ifdef unix} cdecl {$else} stdcall {$endif} = nil;


