{
    This file is part of Chentrah,
    Copyright (C) 2004-2012 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************

    This file contains the definitions and initialization code
    for the functions exported from the mothe rmodule to the game module

 **********************************************************************}
{
 en_US:
    Generally, one should use interfaces
      in stead of such perversion.
      Alas, at the time I built this,
      FreePascal didn't yet support the interfaces well.

    Besides, I don't see the point of reworking this mechanism.
      It works, it works well, it is in a way more flexible
      than the interface mechanism, it is safe enough.
      In short, moving from it to interfaces would be just a waste of time.
      
    After reaching a stable version, this list will stop changing,
      except adding new functions maybe.

 ru_RU:
    Знаю, что изврат, но меня ТАК ДОСТАЛО поддерживать
     (а самое страшное - модифицировать) четыре разных
     списка одних и тех же функций в четырёх разных местах.
     Да ещё вручную следить, чтобы все изменения в них
     совпадали до точки...

    Всё худо-бедно держалось пока мне не пришлось массированно править
     списки параметров (переезд с String на PChar).
     Вот тут-то ад и разверсзя... =:(

 **********************************************************************}
{
    This header is used by both the mother executable and the module dlls.
     The mother definition style:
       function A (): integer;
       , so macros are: e_fun_1 = "function", e_fun_2 = "", e_cm = "".
     The module definition style:
       var A: function (): integer;
       , so macros are: e_fun_1 = "", e_fun_2 = ":function", e_cm = "".
     The core exporting proc definition style:
       3: p:=@A;
       , so macros are: e_fun_1 = "", e_fun2 = "", e_cm = ":p:=@"
     The module importing proc definition style:
       RegisterProc(3, @A);
       , so macros are: e_fun_1 = "RegisterProc(", e_fun2 = ")", e_cm = ",@"

 **********************************************************************}

// ---------------------- INTERFACING BETWEEN THE MODULE AND THE ENGINE -------

e_pro_1 {$ifndef header} 0003 e_cm {$endif}_ValidateVersion e_pro_2{$ifdef header}(m, n, b: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 0001 e_cm {$endif}_ValidateTypesets e_pro_2{$ifdef header}(i, n: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 0004 e_cm {$endif}_ValidateTypesetsEq e_pro_2{$ifdef header}(n: PAnsiChar; v1, v2: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 0002 e_cm {$endif}_ValidateTypesetsLe e_pro_2{$ifdef header}(n: PAnsiChar; v1, v2: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 0005 e_cm {$endif}_RequestExit e_pro_2{$ifdef header}(); cdecl{$endif};
e_fun_1 {$ifndef header} 0006 e_cm {$endif}GoingDownHard e_fun_2 {$ifdef header}(): boolean; cdecl{$endif};

e_pro_1 {$ifndef header} 0007 e_cm {$endif}_cgeSetBackground e_pro_2{$ifdef header}(FileName: PAnsiChar); cdecl{$endif};
e_pro_1 {$ifndef header} 0107 e_cm {$endif}_cgeSetBackgroundPtr e_pro_2{$ifdef header}(p: pointer; size: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 0108 e_cm {$endif}_cgeDrawBackground e_pro_2{$ifdef header}(); cdecl{$endif};
e_pro_1 {$ifndef header} 0008 e_cm {$endif}_cgeHeartBeat e_pro_2{$ifdef header}(); cdecl{$endif};

e_fun_1 {$ifndef header} 0015 e_cm {$endif}GetWindowExists e_fun_2 {$ifdef header}(): boolean; cdecl{$endif};

e_pro_1 {$ifndef header} 0017 e_cm {$endif}_SetConfigInt e_pro_2 {$ifdef header} (section, id: PAnsiChar; Value: integer); cdecl{$endif};
e_fun_1 {$ifndef header} 0018 e_cm {$endif}_GetConfigInt e_fun_2 {$ifdef header} (section, id: PAnsiChar): integer; cdecl{$endif};
e_fun_1 {$ifndef header} 0019 e_cm {$endif}_GetConfigIntCh e_fun_2 {$ifdef header} (section, id: PAnsiChar; min, max: integer): integer; cdecl{$endif};
e_pro_1 {$ifndef header} 0101 e_cm {$endif}_SetConfigStr e_pro_2 {$ifdef header} (section, id, Value: PAnsiChar); cdecl{$endif};
e_fun_1 {$ifndef header} 0102 e_cm {$endif}_GetConfigStr e_fun_2 {$ifdef header} (section, id: PAnsiChar): PAnsiChar; cdecl{$endif};

e_fun_1 {$ifndef header} 0020 e_cm {$endif}_GetCGM e_fun_2 {$ifdef header}(): integer; cdecl{$endif}; //reads the message queue;

e_pro_1 {$ifndef header} 0021 e_cm {$endif}_MakeSurePathExists e_pro_2 {$ifdef header} (path: PAnsiChar); cdecl{$endif};


// ------------------------------ LOG AND EXCEPTION HANDLING ------------------

e_fun_1 {$ifndef header} 1002 e_cm {$endif} {$ifdef cgekernel}_exp_StopDying{$else}StopDying{$endif} e_fun_2 {$ifdef header}(): PWideChar; cdecl{$endif};

e_pro_1 {$ifndef header} 1003 e_cm {$endif}DbgSayA e_pro_2 {$ifdef header}(Yell: PAnsiChar); cdecl{$endif};
//e_pro_1 {$ifndef header} 0044 e_cm {$endif}HostDieW e_pro_2 {$ifdef header}(txt: PWideChar); cdecl{$endif};
e_pro_1 {$ifndef header} 1004 e_cm {$endif}SetDying e_pro_2 {$ifdef header}(d: boolean); cdecl{$endif};

e_pro_1 {$ifndef header} 1005 e_cm {$endif}_HostDyellW e_pro_2 {$ifdef header}(txt: PWideChar); cdecl{$endif};
//e_pro_1 {$ifndef header} 0117 e_cm {$endif}HostRaiseException e_pro_2 {$ifdef header}(); cdecl{$endif};


e_pro_1 {$ifndef header} 1006 e_cm {$endif}_HostLogW e_pro_2 {$ifdef header}(txt: PWideChar); cdecl{$endif};
e_fun_1 {$ifndef header} 1007 e_cm {$endif}_HostMsg  e_fun_2 {$ifdef header}(M: TMessageId): PWideChar; cdecl{$endif};
e_pro_1 {$ifndef header} 1008 e_cm {$endif}AddLogOK  e_pro_2 {$ifdef header}(); cdecl{$endif};
(*{$ifdef windows}
//DONT NEED IT ANYMORE
e_pro_1 {$ifndef header} 1009 e_cm {$endif}CgeTryWrap e_pro_2 {$ifdef header}(backwrapperproc, calledproc: pointer); cdecl{$endif};
{$endif}*)

// --------------------------------- OPENGL HELPERS AND WRAPPERS --------------

e_pro_1 {$ifndef header} 2001 e_cm {$endif}_CgeSwapBuffers e_pro_2{$ifdef header}(); cdecl{$endif};
e_pro_1 {$ifndef header} 2002 e_cm {$endif}_CgeBuildAlphaMipmaps e_pro_2 {$ifdef header}(Width, Height: integer; Data: pointer); cdecl{$endif};
e_fun_1 {$ifndef header} 2004 e_cm {$endif}{$ifdef cgekernel}exGetGlProcAddress{$else}GetGLProcAddress{$endif} e_fun_2 {$ifdef header}(ProcName, Suffix: PAnsiChar): Pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 2005 e_cm {$endif}{$ifdef cgekernel}exGetGlProcAddress2{$else}GetGLProcAddress2{$endif} e_fun_2 {$ifdef header}(ProcName, Suffix1, Suffix2: PAnsiChar): Pointer; cdecl{$endif};

e_fun_1 {$ifndef header} 2006 e_cm {$endif}GetHigherPowerOf2 e_fun_2 {$ifdef header}(i: integer): integer; cdecl{$endif};
e_fun_1 {$ifndef header} 2007 e_cm {$endif}GetLowerPowerOf2 e_fun_2 {$ifdef header}(i: integer): integer; cdecl{$endif};


// --------------------------------- SOUND ------------------------------------
e_fun_1 {$ifndef header} 2101 e_cm {$endif}{$ifdef cgekernel}exGetALProcAddress{$else}GetALProcAddress{$endif} e_fun_2 {$ifdef header}(ProcName: PAnsiChar): Pointer; cdecl{$endif};
//the data format is always 16 bits stereo.
e_pro_1 {$ifndef header} 2102 e_cm {$endif}CgeNewSoundData e_pro_2{$ifdef header}(begins: TDateTime; samples, rate: integer; data: pointer); cdecl{$endif};
e_pro_1 {$ifndef header} 2103 e_cm {$endif}CgeSetSoundVolume e_pro_2{$ifdef header}(volume: float); cdecl{$endif};

e_pro_1 {$ifndef header} 2104 e_cm {$endif}_PlaySound e_pro_2{$ifdef header}(Wavfilename: PAnsiChar); cdecl{$endif};



//  -------------------------------- CGE-FILE MANAGEMENT ----------------------
// Rest in peace, paradigm.

//e_pro_1 {$ifndef header} 0049 e_cm {$endif}OpenCGEFileForWrite e_pro_2 {$ifdef header}(TargetName: PAnsiChar; version: AnsiChar); cdecl{$endif};
//e_pro_1 {$ifndef header} 0050 e_cm {$endif}OpenCGEFileForRead e_pro_2 {$ifdef header}(SourceName: PAnsiChar; var version: AnsiChar); cdecl{$endif};
//e_fun_1 {$ifndef header} 0051 e_cm {$endif}ReadFromCGEFile e_fun_2 {$ifdef header}(var BufferLen: integer): pointer; cdecl{$endif};
//e_fun_1 {$ifndef header} 0055 e_cm {$endif}AllocCGefileWriteBuffer e_fun_2 {$ifdef header}(var BufferLen: integer): pointer; cdecl{$endif};
//e_pro_1 {$ifndef header} 0052 e_cm {$endif}WriteToCGEFile e_pro_2 {$ifdef header} (BufferLen: integer); cdecl{$endif};
//e_pro_1 {$ifndef header} 0053 e_cm {$endif}CloseCGEFile e_pro_2 {$ifdef header} (FlushToFile: boolean; FileName: PAnsiChar); cdecl{$endif};
//e_pro_1 {$ifndef header} 0115 e_cm {$endif}EmergencyCloseCGEFile e_pro_2 {$ifdef header} (); cdecl{$endif};
//e_fun_1 {$ifndef header} 0069 e_cm {$endif}GetCGEFileSessionId e_fun_2 {$ifdef header}(): int64; cdecl{$endif};


//e_fun_1 {$ifndef header} 0071 e_cm {$endif}CgeFileExists e_fun_2 {$ifdef header}(name: PAnsiChar): boolean; cdecl{$endif};
//e_pro_1 {$ifndef header} 0072 e_cm {$endif}CgeFileRename e_pro_2 {$ifdef header} (fFrom, fTo: PAnsiChar); cdecl{$endif};
e_fun_1 {$ifndef header} 3001 e_cm {$endif}_UnmangleFileName e_fun_2{$ifdef header}(m: PAnsiChar): pAnsiChar; cdecl{$endif};
e_pro_1 {$ifndef header} 3002 e_cm {$endif}_GetFileHash e_pro_2{$ifdef header}(name: PAnsiChar; phash: pResourceHash); cdecl{$endif};
e_fun_1 {$ifndef header} 3003 e_cm {$endif}_GetFileDateTime e_fun_2{$ifdef header}(name: PAnsiChar): TDateTime; cdecl{$endif};
e_fun_1 {$ifndef header} 3004 e_cm {$endif}_GetIsHashvalid e_fun_2{$ifdef header}(phash: pMd5Digest): boolean; cdecl{$endif};


(*
e_fun_1 {$ifndef header} 3005 e_cm {$endif}_CreateContainer e_fun_2{$ifdef header}(Name: PAnsiChar; Size: integer): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 3006 e_cm {$endif}_GetContainer e_fun_2{$ifdef header}(Name: PAnsiChar): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 3007 e_cm {$endif}_GetContainerSize e_fun_2{$ifdef header}(Name: PAnsiChar): integer; cdecl{$endif};
e_pro_1 {$ifndef header} 3008 e_cm {$endif}_DeleteContainer e_pro_2{$ifdef header}(Name: PAnsiChar); cdecl{$endif};
e_pro_1 {$ifndef header} 3009 e_cm {$endif}_StoreContainerToFile e_pro_2 {$ifdef header} (Name, FileName: PAnsiChar); cdecl{$endif};
e_fun_1 {$ifndef header} 3010 e_cm {$endif}_CreateContainerFromFile e_fun_2 {$ifdef header}(Name, FileName: PAnsiChar; var Size: integer): pointer; cdecl{$endif};
*)
//--------------------------------- RESOURCE MANAGEMENT -----------------------

//e_fun_1 {$ifndef header} 0057 e_cm {$endif}GetCurrentSessionID e_fun_2 {$ifdef header}(): int64; cdecl{$endif};
//e_pro_1 {$ifndef header} 0058 e_cm {$endif}NewSessionID e_pro_2 {$ifdef header} (); cdecl{$endif};

(*
e_pro_1 {$ifndef header} 0111 e_cm {$endif}_CgeNewResource e_pro_2 {$ifdef header} (ResType: integer; pname: pinteger; ptoken: pResourceToken); cdecl{$endif};
e_pro_1 {$ifndef header} 0067 e_cm {$endif}_CgeDeleteResource e_pro_2 {$ifdef header} (ResType, name: integer; ptoken: PResourceToken); cdecl{$endif};
e_pro_1 {$ifndef header} 0062 e_cm {$endif}_UpdateResourceToken e_pro_2 {$ifdef header} (ResType, name: integer; ptoken: PResourceToken); cdecl{$endif};
e_pro_1 {$ifndef header} 0063 e_cm {$endif}_UnclaimResource e_pro_2 {$ifdef header} (ResType, name: integer; ptoken: PResourceToken); cdecl{$endif};
e_fun_1 {$ifndef header} 0064 e_cm {$endif}_ClaimResource e_fun_2 {$ifdef header} (ResType: integer; pname: pinteger; ptoken: pResourceToken): longbool; cdecl{$endif};
e_pro_1 {$ifndef header} 0065 e_cm {$endif}_ClearUnclaimedResourcesList e_pro_2 {$ifdef header} (); cdecl{$endif};
e_pro_1 {$ifndef header} 0066 e_cm {$endif}_DeleteUnclaimedResources e_pro_2 {$ifdef header} (); cdecl{$endif};
*)

e_pro_1 {$ifndef header} 4000 e_cm {$endif}GenHash e_pro_2 {$ifdef header} (phash: PResourceHash); cdecl{$endif};
e_pro_1 {$ifndef header} 4001 e_cm {$endif}StoreResource e_pro_2 {$ifdef header} (phandle: pDWORD; phash: PResourceHash); cdecl{$endif};
e_fun_1 {$ifndef header} 4002 e_cm {$endif}ClaimResource e_fun_2 {$ifdef header} (phash: PResourceHash): PRes; cdecl{$endif};
e_fun_1 {$ifndef header} 4003 e_cm {$endif}GetFirstResource e_fun_2 {$ifdef header} (): PRes; cdecl{$endif};
e_fun_1 {$ifndef header} 4004 e_cm {$endif}GetNextResource e_fun_2 {$ifdef header} (): PRes; cdecl{$endif};
e_pro_1 {$ifndef header} 4005 e_cm {$endif}ClearResourceList e_pro_2 {$ifdef header} (); cdecl{$endif};
e_fun_1 {$ifndef header} 4006 e_cm {$endif}HashesMatch e_fun_2 {$ifdef header} (a, b: PResourceHash): boolean; cdecl{$endif};

//These are used for storing the classes information:
e_fun_1 {$ifndef header} 3011 e_cm {$endif}CgeCreateMemoryStream e_fun_2 {$ifdef header}(): pointer; cdecl{$endif};
e_pro_1 {$ifndef header} 3012 e_cm {$endif}CgeDeleteMemoryStream e_pro_2 {$ifdef header}(s: pointer); cdecl{$endif};
e_pro_1 {$ifndef header} 3013 e_cm {$endif}CgeSeekMemoryStream e_pro_2 {$ifdef header}(s: pointer; pos: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 3014 e_cm {$endif}CgeWriteToMemoryStream e_pro_2 {$ifdef header}(s: pointer; buf: pointer; len: integer); cdecl{$endif};
e_fun_1 {$ifndef header} 3015 e_cm {$endif}CgeReadFromMemoryStream e_fun_2 {$ifdef header}(s: pointer; buf: pointer; len: integer): integer; cdecl{$endif};
e_pro_1 {$ifndef header} 3016 e_cm {$endif}CgeWriteIntToMemoryStream e_pro_2 {$ifdef header}(s: pointer; i: integer); cdecl{$endif};
e_fun_1 {$ifndef header} 3017 e_cm {$endif}CgeReadIntFromMemoryStream e_fun_2 {$ifdef header}(s: pointer): integer; cdecl{$endif};
e_fun_1 {$ifndef header} 3018 e_cm {$endif}CgeGetMemoryStreamMem e_fun_2 {$ifdef header}(s: pointer): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 3019 e_cm {$endif}CgeGetMemoryStreamSize e_fun_2 {$ifdef header}(s: pointer): integer; cdecl{$endif};
e_pro_1 {$ifndef header} 3020 e_cm {$endif}CgeMemoryStreamLoadFromFile e_pro_2 {$ifdef header}(s: pointer; name: PAnsiChar); cdecl{$endif};
e_pro_1 {$ifndef header} 3021 e_cm {$endif}CgeMemoryStreamSaveToFile e_pro_2 {$ifdef header}(s: pointer; name: PAnsiChar); cdecl{$endif};

//This is a per-module setting!
e_fun_1 {$ifndef header} 3022 e_cm {$endif}CgeGetCiMemoryStream e_fun_2 {$ifdef header}(): pointer; cdecl{$endif};
e_pro_1 {$ifndef header} 3023 e_cm {$endif}CgeSetCiMemoryStream e_pro_2 {$ifdef header}(s: pointer); cdecl{$endif};

e_fun_1 {$ifndef header} 3024 e_cm {$endif}CgeGetHostMem e_fun_2 {$ifdef header}(size: integer): pointer; cdecl{$endif};
e_pro_1 {$ifndef header} 3025 e_cm {$endif}CgeFreeHostMem e_pro_2 {$ifdef header}(p: pointer); cdecl{$endif};
e_fun_1 {$ifndef header} 3026 e_cm {$endif}CgeReallocHostMem e_fun_2 {$ifdef header}(p: pointer; newsize: integer): pointer; cdecl{$endif};


// -------------------------------- MOUSE POINTER -----------------------------

e_pro_1 {$ifndef header} 3201 e_cm {$endif}CgeLoadCursorFromFile e_pro_2 {$ifdef header}(FileName: PAnsiChar; xhotspot, yhotspot: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 3202 e_cm {$endif}CgeLoadCursorFromMemory e_pro_2 {$ifdef header}(pfile: pointer; size, xhotspot, yhotspot: integer); cdecl{$endif};
//Remember, kids! 32x32 only!
e_pro_1 {$ifndef header} 3203 e_cm {$endif}CgeLoadCursorFromRawPixmap e_pro_2 {$ifdef header}(pixels: pointer; xhotspot, yhotspot: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 3204 e_cm {$endif}CgeEmptyCursor e_pro_2 {$ifdef header}(); cdecl{$endif};
e_pro_1 {$ifndef header} 3205 e_cm {$endif}CgeStandardCursor e_pro_2 {$ifdef header}(); cdecl{$endif};
e_pro_1 {$ifndef header} 3206 e_cm {$endif}CgeHourglassCursor e_pro_2 {$ifdef header}(); cdecl{$endif};

// -------------------------------------- TIMER -------------------------------

//e_fun_1 {$ifndef header} 5001 e_cm {$endif}_CTimer e_fun_2 {$ifdef header} (): float; cdecl{$endif};
//e_fun_1 {$ifndef header} 5002 e_cm {$endif}{$ifdef cgekernel}_exp_Tick{$else}Tick{$endif}e_fun_2 {$ifdef header}(): longint; cdecl{$endif};
e_fun_1 {$ifndef header} 5003 e_cm {$endif}Second e_fun_2{$ifdef header}(): double; cdecl{$endif};
e_fun_1 {$ifndef header} 5004 e_cm {$endif}UsecByTsc e_fun_2{$ifdef header}(ptsc: pqword): double; cdecl{$endif};


//----------------------------------- VAMPYRE IMAGING -------------------------

//e_fun_1 {$ifndef header} 1014 e_cm {$endif}CgeNewPic e_fun_2 {$ifdef header} (): pointer; cdecl{$endif};
e_pro_1 {$ifndef header} 6000 e_cm {$endif}DeletePic e_pro_2 {$ifdef header} (name: pointer); cdecl{$endif};

//e_fun_1 {$ifndef header} 1001 e_cm {$endif}LoadNewPic e_fun_2 {$ifdef header} (FileName: PAnsiChar; phash: pResourceHash): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 6001 e_cm {$endif}LoadPic e_fun_2 {$ifdef header} (FileName: PAnsiChar): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 6002 e_cm {$endif}LoadPicAs e_fun_2 {$ifdef header} (FileName: PAnsiChar; format: GLenum): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 6003 e_cm {$endif}LoadPicFromMem e_fun_2 {$ifdef header} (p: pointer; size: integer): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 6004 e_cm {$endif}LoadPicFromMemAs e_fun_2 {$ifdef header} (p: pointer; size: integer; format: GLenum): pointer; cdecl{$endif};


e_fun_1 {$ifndef header} 6005 e_cm {$endif}CreatePic e_fun_2{$ifdef header}(width, height: integer; format: GLuint): pointer; cdecl{$endif};

e_pro_1 {$ifndef header} 6006 e_cm {$endif}SavePic e_pro_2{$ifdef header}(FileName: PAnsiChar; name: pointer); cdecl{$endif};

e_pro_1 {$ifndef header} 6007 e_cm {$endif}ResizePic e_pro_2{$ifdef header}(name: pointer; newwidth, newheight: integer); cdecl{$endif};
e_pro_1 {$ifndef header} 6008 e_cm {$endif}ResamplePic e_pro_2{$ifdef header}(name: pointer; newwidth, newheight: integer; wrap: boolean); cdecl{$endif};
e_fun_1 {$ifndef header} 6009 e_cm {$endif}ClonePic e_fun_2{$ifdef header}(name1: pointer): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 6010 e_cm {$endif}CloneResamplePic e_fun_2{$ifdef header}(name1: pointer; newwidth, newheight: integer; wrap: boolean): pointer; cdecl{$endif};

e_fun_1 {$ifndef header} 6011 e_cm {$endif}GetPicFmt e_fun_2 {$ifdef header} (name: pointer): GLuint; cdecl{$endif};
e_fun_1 {$ifndef header} 6012 e_cm {$endif}GetPicPixels e_fun_2 {$ifdef header} (name: pointer): pointer; cdecl{$endif};
e_fun_1 {$ifndef header} 6013 e_cm {$endif}GetPicWidth e_fun_2 {$ifdef header} (name: pointer): integer; cdecl{$endif};
e_fun_1 {$ifndef header} 6014 e_cm {$endif}GetPicHeight e_fun_2 {$ifdef header} (name: pointer): integer; cdecl{$endif};
e_fun_1 {$ifndef header} 6015 e_cm {$endif}GetPicBytes e_fun_2 {$ifdef header} (name: pointer): integer; cdecl{$endif};

// -------------------------------- FONT MANAGEMENT ---------------------------

e_pro_1 {$ifndef header} 7001 e_cm {$endif}cgeffSizeToFace e_pro_2{$ifdef header}(size: integer; face: Pinteger; zoom: PGLfloat); cdecl{$endif};
e_pro_1 {$ifndef header} 7002 e_cm {$endif}cgeffFitStringIntoRectangle e_pro_2{$ifdef header}(Size, numChars, numLines, Width, Height: integer; fit: PStringFitRec);  cdecl{$endif};
e_fun_1 {$ifndef header} 7003 e_cm {$endif}cgeffGetStringWidth e_fun_2 {$ifdef header} (Size, numChars: integer): GLfloat; cdecl{$endif};
e_fun_1 {$ifndef header} 7004 e_cm {$endif}cgeffGetStringHeight e_fun_2 {$ifdef header} (Size, numLines: integer): GLfloat; cdecl{$endif};

//the caller is responsible for switching to FFP and setting the ortho projection!
e_pro_1 {$ifndef header} 7005 e_cm {$endif}cgeffSetRenderState e_pro_2{$ifdef header}(noshadow: boolean); cdecl{$endif};
e_pro_1 {$ifndef header} 7006 e_cm {$endif}cgeffRenderString e_pro_2{$ifdef header}(fit: PStringFitRec; Left, Top: glFloat; w: PWideChar); cdecl{$endif};


(*
e_fun_1 {$ifndef header} 7007 e_cm {$endif}cgeGetProportionalFontName e_fun_2 {$ifdef header} (index: integer): PAnsiChar; cdecl{$endif};
e_pro_1 {$ifndef header} 7008 e_cm {$endif}cgeCalcWordMetrics e_pro_2 {$ifdef header} (
  chars: PWideChar; len, font_index, size, diminish: integer; width, width_condensed: PInteger; UV, UV_condensed: PGLfloat); cdecl{$endif};

*)
(*


//the fonts CGE loads by itself: 0=ChebStyle, 1=Nimbus Sans L.
e_fun_1 {$ifndef header} 2007 e_cm {$endif}_foGetSysFont e_fun_2 {$ifdef header} (index: integer): integer; cdecl{$endif};

//all objects should be created prior, via CgeNewResource(CGE_RESOURCE_FONT, ...)
e_fun_1 {$ifndef header} 2001 e_cm {$endif}_foLoadFont e_fun_2 {$ifdef header} (FileName: PAnsiChar; name: integer): boolean; cdecl{$endif};
e_fun_1 {$ifndef header} 2008 e_cm {$endif}_foGetFontname e_fun_2 {$ifdef header} (index: integer): PAnsiChar; cdecl{$endif};

//This one performs the actual width high and low calculations
//Returns the *actual* character size (culled to min..max supported by the font)
//The array receiving the data must be pre-allocated.
//The string must *not* contain spaces.
e_fun_1 {$ifndef header} 2006 e_cm {$endif}_foCalcWord e_fun_2 {$ifdef header}
  (chars: PWideChar; len, font, size: integer; bold, italic, condensed: boolean; word: PiCharArray;
   texture, shadow: pGLuint): integer; cdecl{$endif};
*)




