
procedure CP_UIntToFixed32 (PField: pointer; Tind1, Tind2: integer); register;
var
  i1: byte;
  i2: word;
  i4: dword;
  i8: qword;
begin
  case Types[DH.B_ToGtind[Tind1]].size of
    1: begin
       ReadField(@i1, Tind1);
       i8:=i1;
     end;
    2: begin
       ReadField(@i2, Tind1);
       i8:=i2;
     end;
    4: begin
       ReadField(@i4, Tind1);
       i8:=i4;
     end;
    8: ReadField(@i8, Tind1);
  end;
  fixed32(PField^) := i8;
end;

procedure CP_IntToFixed32 (PField: pointer; Tind1, Tind2: integer); register;
var
  i1: shortint;
  i2: smallint;
  i4: longint;
  i8: Int64;
begin
  case Types[DH.B_ToGtind[Tind1]].size of
    1: begin
       ReadField(@i1, Tind1);
       i8:=i1;
     end;
    2: begin
       ReadField(@i2, Tind1);
       i8:=i2;
     end;
    4: begin
       ReadField(@i4, Tind1);
       i8:=i4;
     end;
    8: ReadField(@i8, Tind1);
  end;
  fixed32(PField^):= i8;
end;

procedure CP_SingleToFixed32 (PField: pointer; Tind1, Tind2: integer); register;
var
  s: Single;
begin
  ReadField(@s, Tind1);
  fixed32(PField^):= s;
end;

procedure CP_DoubleToFixed32 (PField: pointer; Tind1, Tind2: integer); register;
var
  d: Double;
begin
  ReadField(@d, Tind1);
  fixed32(PField^):= d;
end;

procedure CP_Fixed32ToSingle (PField: pointer; Tind1, Tind2: integer); register;
var
  f: fixed32;
begin
  ReadField(@f, Tind1);
  single(PField^):= f;
end;

procedure CP_Fixed32ToDouble (PField: pointer; Tind1, Tind2: integer); register;
var
  f: fixed32;
begin
  ReadField(@f, Tind1);
  double(PField^):= f;
end;

procedure CP_Fixed32ToInt (PField: pointer; Tind1, Tind2: integer); register;
var
  f: fixed32;
  tb: Int64;
begin
  ReadField(@f, Tind1);
  tb:= f;
//addlog(' cp_singletoint %0', [s]);
  Move(tb, PField^, Types[Tind2].Size);
end;

procedure CP_Fixed32ToUInt (PField: pointer; Tind1, Tind2: integer); register;
var
  f: fixed32;
  tb: qword;
begin
  ReadField(@f, Tind1);
  tb:= f;
//addlog(' cp_singletoint %0', [s]);
  Move(tb, PField^, Types[Tind2].Size);
end;


