// http://gafferongames.com/networking-for-game-programmers/floating-point-determinism/

type

  fixed32 = packed object
    i: longint;
    function sin(): fixed32;
    function cos(): fixed32;
    function sqr(): fixed32;
    function sqrt(): fixed32;
{    case integer of
    0: (i: longint);
    1: (ifrac: word; iint: smallint);
}
  end;


  fixed64 = packed object
    i: int64;
    function sin(): fixed64;
    function cos(): fixed64;
    function sqr(): fixed64;
    function sqrt(): fixed64;
  end;


  fixedFake = packed object
    f: single;
    function sin(): single;
    function cos(): single;
    function sqr(): single;
    function sqrt(): single;
{    case integer of
    0: (i: longint);
    1: (ifrac: word; iint: smallint);
}
  end;

  fixed = fixed32;

  operator := (f: fixed32) s: single;
//  operator := (f: fixed64) s: single;
  operator := (f: fixed32) d: double;
//  operator := (f: fixed64) d: double;


  operator := (f: fixed32) i: int64;
  operator := (f: fixed32) i: qword;
  operator := (f: fixed32) i: longint;
  operator := (f: fixed32) i: dword;
  operator := (f: fixed32) i: smallint;
  operator := (f: fixed32) i: word;
  operator := (f: fixed32) i: shortint;
  operator := (f: fixed32) i: byte;

  operator := (i: int64) f: fixed32;
  operator := (i: qword) f: fixed32;
  operator := (i: longint) f: fixed32;
  operator := (i: dword) f: fixed32;
  operator := (i: smallint) f: fixed32;
  operator := (i: word) f: fixed32;
  operator := (i: shortint) f: fixed32;
  operator := (i: byte) f: fixed32;


  operator := (s: single) f: fixed32;
  operator := (d: double) f: fixed32;
//  operator := (s: single) f: fixed64;
//  operator := (d: double) f: fixed64;

  operator * (a, b: fixed32) z: fixed32;
  operator / (a, b: fixed32) z: fixed32;
  operator + (a, b: fixed32) z: fixed32;
  operator - (a, b: fixed32) z: fixed32;


  //Since we have boolean re-defined as longbool, it says Error: Comparative operator must return a boolean value
  operator = (a, u: fixed32) b: System.boolean;
  operator < (a, u: fixed32) b: System.boolean;
  operator > (a, u: fixed32) b: System.boolean;
  operator >= (a, u: fixed32) b: System.boolean;
  operator <= (a, u: fixed32) b: System.boolean;

function FixedToStr(Value: fixed32): string; overload;
function FixedToStr(Value: fixed32; const FormatSettings: TFormatSettings): string; overload;

