{
    This file is part of chepersy
    Copyright (c) 2004-2008 by Anton Rzheshevski (chebmaster@mail.ru),

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

  var
    wmSet, wmClear: dword;

  procedure WalkMark(o: TManagedObject);
  begin
    if Assigned(o)
      then o.CpsMask:= (o.CpsMask or wmset) and not (wmClear);
  end;

  function CpsMarkupGraph(o: TManagedObject; SetMaskBits, ClearMaskBits: dword): longbool;
  begin
    Assert ((SetMaskBits and CPS_RESERVED_MASK) = 0, 'Attempt to set the reserved bits of Cpsmask');
    Assert ((ClearMaskBits and CPS_RESERVED_MASK) = 0, 'Attempt to clear the reserved bits of Cpsmask');
    wmSet:= SetMaskBits;
    wmClear:= ClearMaskBits;
    Result:= CpsWalkGraph(o, @WalkMark);
  end;

  function CpsWalkGraph(o: TManagedObject; proc: TcustomWalkProc): longbool;
  begin
    result:= true;
    ValidateChepersyState('CpsWalkGraph()');
    CpsCriticalSection.Enter;
    CpsError.Clear;
    try
      try
        dec(CpsWalkMarkVal);
        if CpsWalkMarkVal = low(integer) + 1
          then CpsWalkMarkVal:= -1;
        CurrentWalkProc:= proc;
        WalkPersistent(o);
      except
       {$ifndef cge}
        try
       {$endif}
        Die(RuEn('Ошибка при обходе объектного графа','Error walking the object graph'));
       {$ifndef cge}
        except end;
        result:=false;
       {$endif}
      end;
    finally
      CpsCriticalSection.Leave;
    end;
  end;

  {
  function CpsListOjects(o: TObject; var List: array of TObject): boolean;
  begin
    CpsCriticalSection.Enter;
    try

    finally
      CpsCriticalSection.Leave;
    end;
  end;

  function CpsGetNameHash(name: string): integer;
  begin
    CpsCriticalSection.Enter;
    try

    finally
      CpsCriticalSection.Leave;
    end;
  end;

  function CpsGetField(NameHash: integer): Variant;
  begin
    CpsCriticalSection.Enter;
    try

    finally
      CpsCriticalSection.Leave;
    end;
  end;
   }

