{
    This file is part of chepersy
    Copyright (c) 2004-2008 by Anton Rzheshevski (chebmaster@mail.ru),

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
  TFieldsList = Class(TDyna)
    Function Add(i: TFieldInfo): integer; virtual;
    procedure ClearMem; override;
  Protected
    m: packed array of TFieldInfo;
    function _Read(ind: cardinal): TFieldInfo;
    procedure _Write(ind: cardinal; p: TFieldInfo);
    function _ReadDPTR: pointer; override;
    function _ReadLast: TFieldInfo;
    function _ReadNext: TFieldInfo;
    function _ReadFirst: TFieldInfo;
    procedure _WriteLast(p: TFieldInfo);
    procedure _Resize(L: integer); override;
  Public
    procedure Save(); override;
    procedure Load(Lsz: integer); override;
    property D[index: cardinal]:TFieldInfo read _Read write _Write; DEFAULT;
    property Last:TFieldInfo read _ReadLast write _WriteLast;
    property First: TFieldInfo read _ReadFirst;
    property Next: TFieldInfo read _ReadNext;
  End;
  TFieldInfos = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    a: array of pointer;
    function _Read(ind: cardinal): TFieldsList;
    procedure _Write(ind: cardinal; p: TFieldsList);
    function _ReadLast: TFieldsList;
    procedure _WriteLast(z: TFieldsList);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    procedure Save(); override;
    procedure Load(Lsz: integer); override;
    property D[index: cardinal]:TFieldsList read _Read write _Write; DEFAULT;
    property Last:TFieldsList read _ReadLast write _WriteLast;
  End;
  TTypeRegistry = Class(TDyna)
    Function Add(i: TTypeRecord): integer; virtual;
    procedure ClearMem; override;
  Protected
    m: packed array of TTypeRecord;
    function _Read(ind: cardinal): TTypeRecord;
    procedure _Write(ind: cardinal; p: TTypeRecord);
    function _ReadDPTR: pointer; override;
    function _ReadLast: TTypeRecord;
    function _ReadNext: TTypeRecord;
    function _ReadFirst: TTypeRecord;
    procedure _WriteLast(p: TTypeRecord);
    procedure _Resize(L: integer); override;
  Public
    procedure Save(); override;
    procedure Load(Lsz: integer); override;
    property D[index: cardinal]:TTypeRecord read _Read write _Write; DEFAULT;
    property Last:TTypeRecord read _ReadLast write _WriteLast;
    property First: TTypeRecord read _ReadFirst;
    property Next: TTypeRecord read _ReadNext;
  End;
  TArrayOfDyna = Class(TDyna)
    Function Add(i: TDyna): integer; virtual;
    procedure ClearMem; override;
  Protected
    a: array of pointer;
    function _Read(ind: cardinal): TDyna;
    procedure _Write(ind: cardinal; p: TDyna);
    function _ReadDPTR: pointer; override;
    function _ReadLast: TDyna;
    function _ReadNext: TDyna;
    function _ReadFirst: TDyna;
    procedure _WriteLast(p: TDyna);
    procedure _Resize(L: integer); override;
  Public
    Container: boolean;
    procedure Save(); override;
    procedure Load(Lsz: integer); override;
    property D[index: cardinal]:TDyna read _Read write _Write; DEFAULT;
    property Last:TDyna read _ReadLast write _WriteLast;
    property First: TDyna read _ReadFirst;
    property Next: TDyna read _ReadNext;
  End;

