{
    This file is part of the Cheb's persistence system (Chepersy),
    Copyright (c) 2004-2014 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the class headers.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

type

  TChepersyType = class;

  TChepersy = class
  protected
    Ftypes: array of TChepersyType;
  public
    function AddType(t: TChepersyType): integer;
    property types: array of TChepersyType read Ftypes; default;
  end;

  TChepersyManager = class (TManagedObject)
  protected
    RootObject: TManagedObject;
    GarbageCollector: TGarbageCollector;
  public
    constructor Create(o: TManagedObject);
  end;

  TChepersyType = class
  private
    finfo: PTypeInfo;
    function FindClosestMatch: TChepersyType;
  public
    constructor Create(name: AnsiString); //used when registering types
    constructor Load(stream: TStream); virtual; abstract; //used when parsing database header
    procedure Save(stream: TStream); virtual; abstract;
    function IsBinaryBlob: boolean; virtual; abstract;
    procedure LoadValue(stream: TStream; pvalue: pointer); virtual; abstract;
    procedure LoadValue((stream: TStream); virtual; abstract; //into some internal buffer, to return for other type by demand
    procedure SaveValue(stream: TStream; pvalue: pointer);  virtual; abstract;
    procedure LoadValueAs(stream: TStream; pvalue: pointer; formerType: TChepersyType); virtual; abstract;
    property TypeInfo: PTypeInfo read finfo;
  end;

  TChepersyTypeRecord = class(TChepersyType)
  end;

  TChepersyTypeClass = class(TChepersyTypeRecord)
  private
    fclass: CManagedObject;
  public
    property
  end;
