{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************}

  var pfd: array [0..5] of integer =
    (GLX_RENDER_TYPE, GLX_RGBA, GLX_DOUBLEBUFFER, GLX_DEPTH_SIZE, 0, 0);//GLX_DEPTH_SIZE, 16, 0);
    {We don't need a depth buffer because the scene will be
      rendered into a FBO with its own depth buffer}

  procedure TWindowManager.InitGL;
  var
    rr, rg, rb, ra, rd, rs,  vhi, vmed: integer;
  begin
    if GLInitialized then Exit;

    InitOpenGL;

    Visual:=GlXChooseVisual(Display, screen, @(pfd[0]));
      if not Assigned(Visual) then
        Die(MI_ERROR_CANTINITOPENGL,['glXChooseVisual() returned NULL']);
    {Had we need to support FSAA, the pixel format selection would
     be much more elaborate. But as we use manual oversampling via
     rendering into an oversized texture instead, no FSAA is required.}


    context:= glXCreateContext(Display, Visual, nil, false);
      if not Assigned(context)
        then Die(MI_ERROR_CANTINITOPENGL,['glXCreateContext() returned NULL']);

    if not glXMakeCurrent(Display, Windowhandle, context)
      then Die(MI_ERROR_CANTINITOPENGL,['glXMakeCurrent() returned FALSE']);
      
    CheckGLVersion;

    glXGetConfig(Display, Visual, GLX_RED_SIZE, rr);
    glXGetConfig(Display, Visual, GLX_GREEN_SIZE, rg);
    glXGetConfig(Display, Visual, GLX_BLUE_SIZE, rb);
    glXGetConfig(Display, Visual, GLX_ALPHA_SIZE, ra);
    glXGetConfig(Display, Visual, GLX_DEPTH_SIZE, rd);
    glXGetConfig(Display, Visual, GLX_STENCIL_SIZE, rs);
    AddLog(MI_LOG_Screen_format, [MotherState.DisplayWidth, MotherState.DisplayHeight, rr, rg, rb, ra, rd, rs]);

    GLInitialized:=Yes;

    if Assigned(@glXSwapIntervalSGI) then begin
      if glXSwapIntervalSGI(1) > 0
        then GivePeriodicWarning(1.0, 'unable-to-turn-vsync-off', MI_WARN_WARNING,
              MI_SWAP_CRAP, [RuEn(
             'OpenGL отказалась отключить Vsync.'
            ,'OpenGL refused to switch Vsync off.')])
        else
          if MotherState.DebugMode then AddLog('Vsync disabled.');
    end
    else GivePeriodicWarning(7.0, 'unable-to-turn-vsync-off', MI_WARN_WARNING,
              MI_SWAP_CRAP, [RuEn(
               'Не поддерживается GLX_SGI_swap_control',
               'GLX_SGI_swap_control not supported')]);
  end;




  Procedure TWindowManager.CloseGL;
  begin
    if not GLInitialized then Exit;

    if MotherState.DebugMode then AddLog('ClosingOpenGL...');

    if not GoingDownHard and MotherState.WindowExists
      then GLXDestroyContext(Display, context);

    //выгружаем DLL
    CloseOpenGL;

    if MotherState.DebugMode then AddLogOk;
  end;



