//a bit unorthodoxal part: in the fullscreen AGL mode,
// the application doesn't have a window.


{	EventRecord = record
		what: EventKind;
		message: UInt32;
		when: UInt32;
		where: Point;
		modifiers: EventModifiers;
	end;}


  Procedure TWindowManager.OneCycle;
  var
    hk, hm: boolean;
    procedure ConvertMouseCoordinates;
    begin
      f_MouseX:=event.where
      f_MouseY:=event.where


    end;
  begin
    _CheckCursorMode();
    while GetNextEvent (kEventClassAppleEvent, event) do AEProcessAppleEvent(event);
    while GetNextEvent (kEventClassApplication, event) do begin
      case event.what of
        kEventAppActivated: begin
          HasFocus:= True;
        end;
        kEventAppDeactivated: begin
          if f_FullScreen then begin
            LogGoDownM('kEventAppDeactivated');
            ExitRequested:= yes;
          end;
        end;
        kEventAppQuit: begin
          LogGoDownM('kEventAppQuit');
          ExitRequested:= yes;
        end;
      end;
    end;
    while GetNextEvent (kEventClassWindow, event) do begin
      case event.what of
        kEventWindowUpdate: begin
//*************************************** ОБНОВИТЬ РАЗМЕР ОКНА ***********************
        end;
        //there's no window in the fullscreen mode, so no need to check for f_IsFullScreen
        kEventWindowDeactivated: HasFocus:= no;
        kEventWindowActivated: HasFocus:= yes;
      end;
    end;
    repeat
      hm:= GetNextEvent (kEventClassMouse, event);
      if hm then
        case event.what of
          kEventMouseDown: begin

          end;
          kEventMouseUp: begin

          end;
          kEventMouseWheelMoved: begin

          end;
          kEventMouseEntered: begin
            MotherState.MouseIsBeyondOurWindow:= false;
            ConvertMouseCoordinates;
            OnMouseMove;
          end;
          kEventMouseExited: begin
            MotherState.MouseIsBeyondOurWindow:= true;
          end;
        end;
      hk:= GetNextEvent (kEventClassKeyboard, event);
      if hk then
        case event.what of
          kEventRawKeyDown
          kEventRawKeyUp
        end;
    until not hk and not hm
  end;

//procedure GetMouse( var mouseLoc: Point ); external name '_GetMouse';

(*
http://www.idevgames.com/forum/showthread.php?t=5190
How to get mouse events in fullscreen AGL? -    2003.10.08, 07:53 AM
   I've been working on something similar that I want to upload as sample code when I am done. Just do something like this:
Code:
EventHandlerRef		gMouseEventHandlerRef		= NULL;
OSStatus	ErrCode;
    // Mouse Events (Sent before the tab control switches its control value):
    static const EventTypeSpec mouseControlEvents[] =
    {
    { kEventClassMouse,		kEventMouseDown },
    { kEventClassMouse,		kEventMouseUp },
    { kEventClassMouse,		kEventMouseMoved },
    { kEventClassMouse,		kEventMouseDragged },
    { kEventClassMouse,		kEventMouseEntered },
    { kEventClassMouse,		kEventMouseExited },
    { kEventClassMouse,		kEventMouseWheelMoved }
    };
    ErrCode = InstallEventHandler( GetApplicationEventTarget(), NewEventHandlerUPP( MouseEventHandlerProc ), GetEventTypeCount(mouseControlEvents), mouseControlEvents, 0, &gMouseEventHandlerRef );
    if ( ErrCode != noErr ) FatalAlert( "Error in InitializeCarbonEvents(): Unable to install Mouse Event handler.", (int) ErrCode );
and then

mouseControlEvents: array [0..6] of EventTypeSpec = (
    ( eventClass: kEventClassMouse;  eventKind: kEventMouseDown ),
    ( eventClass: kEventClassMouse;  eventKind: kEventMouseUp ),
    ( eventClass: kEventClassMouse;  eventKind: kEventMouseMoved ),
    ( eventClass: kEventClassMouse;  eventKind: kEventMouseDragged ),
    ( eventClass: kEventClassMouse;  eventKind: kEventMouseEntered ),
    ( eventClass: kEventClassMouse;  eventKind: kEventMouseExited ),
    ( eventClass: kEventClassMouse;  eventKind: kEventMouseWheelMoved ));

    if noErr <> InstallEventHandler( GetApplicationEventTarget(),
       NewEventHandlerUPP( MouseEventHandlerProc ), 6, @mouseControlEvents, NIL, NIL )
    then
      Die('Unable to install the application mouse event handler');

    InstallEventHandler( GetApplicationEventTarget(), NewEventHandlerUPP( MouseEventHandlerProc ), GetEventTypeCount(mouseControlEvents), mouseControlEvents, 0, &gMouseEventHandlerRef );

Code:
static pascal OSStatus MouseEventHandlerProc( EventHandlerCallRef inCallRef, EventRef inEvent, void *inUserData )
{
   //UInt32	eventClass    = GetEventClass( inEvent );
    UInt32	eventKind     = GetEventKind( inEvent );
    //EventTime	timeInSeconds = GetEventTime( inEvent );
    //EventTime	currentTime   = GetCurrentEventTime(); // Seconds since system startup.
    //EventRecord event;
    //Boolean     ConvertEventRefToEventRecord( EventRef inEvent, EventRecord event );
    Point	where;
    switch(eventKind)
    {
        case kEventMouseDown:		// A mouse button was pressed.
            printf("MouseDown.\n");
            GetEventParameter( inEvent, kEventParamWindowMouseLocation, typeQDPoint, NULL, sizeof(Point), NULL, &where );
            // kEventMouseButtonPrimary   -- Left button.
            // kEventMouseButtonSecondary -- Right button.
            // kEventMouseButtonTertiary  -- Middle button.
            // kEventParamMouseLocation (display coordinates), kEventParamWindowMouseLocation (window coordinates).
            //UInt32 GetCurrentEventButtonState(void);
            //Bit zero indicates the state of the primary button, bit one the state of the secondary button, and so on.
            break;
        case kEventMouseUp:		// A mouse button was released.
            printf("MouseUp.\n");
            break;
        case kEventMouseMoved:		// The mouse was moved.
           // printf("MouseMoved.\n");
            GetEventParameter( inEvent, kEventParamMouseLocation, typeQDPoint, NULL, sizeof(Point), NULL, &where );
           GetEventParameter( inEvent, kEventParamMouseDelta, typeQDPoint, NULL, sizeof(Point), NULL, &where );
            break;
        case kEventMouseDragged:	// The mouse was moved, and a button was down.
            printf("MouseDragged.\n");
            break;
        case kEventMouseEntered:	// The mouse entered a tracking area.
            printf("MouseEntered.\n");
            break;
        case kEventMouseExited:		// The mouse exited a tracking area.
            printf("MouseExited.\n");
            break;
        case kEventMouseWheelMoved:	// The mouse wheel was moved. (Mac OS X only)
            printf("MouseWheelMoved.\n");
            //kEventMouseWheelAxisX -- The X axis (left or right).
            //kEventMouseWheelAxisY -- The Y axis (up or down).
            break;
    };
    return( eventNotHandledErr ); // Use default handlers for things like kHICommandBringAllToFront.
}
When you are done with your application, release the mouse event handler:

Code:
RemoveEventHandler( gMouseEventHandlerRef );

You can do that for windows events, application events, control and menu events and so on.
*)



(*
        GetWindowPortBounds(win, &rectPort);
        w = rectPort.right - rectPort.left;
        h = rectPort.bottom - rectPort.top;

*)


