{
    This file is part of Chentrah,
    Copyright (C) 2004-2012 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************}

unit cl_winedetect;

{$ifdef fpc}
  {$mode delphi}
  {$longstrings on} //by default, fpc emulates Turbo Pascal (backward compatibility is a sacred thing). Modern features have to be enabled explicitly
{$endif}

interface

uses
  Windows, Classes, SysUtils;
  
function RunningInWine: longbool;
function GetZIsRoot: longbool;
  var WineVersionString: AnsiString = '';

implementation
  Const WineSig: string = 'Wine placeholder DLL';

  var
    Performed: boolean = false;
    Detected: boolean = false;

  function RunningInWine: longbool;
  var
    buf: string;
    S: TFileStream;
    i: integer;
    sd: string;
    ntdll: cardinal;
    vWineGetVersion :function :PChar; stdcall;
  begin
    if Performed then begin
      Result:=Detected;
      Exit;
    end;
    Result:=False;
    Try
      SetLength(sd, 1000);
      FillChar(sd[1], 1000, 0);
      GetSystemDirectory(@sd[1], 1000);
      sd:=Trim(sd);
      S:=TFileStream.Create(sd + '\kernel32.dll', fmOpenRead);
      SetLength(buf, 1000);
      S.ReadBuffer(buf[1], Length(buf));
      S.Free;
      For i:=1 to length(buf) - length(WineSig) do
        if copy (buf, i, length(WineSig)) = WineSig then begin
          Result:=True;
          Break;
        end;
    Except
    End;
    Detected:=Result;
    Performed:=true;

    if Detected then WineVersionString:= 'Wine' else Exit;
    Try
      ntdll:= LoadLibrary('ntdll.dll');
      if ntdll > 0 then begin
        vWineGetVersion := GetProcAddress(ntdll, 'wine_get_version');
        if Assigned(vWineGetVersion) then WineVersionString:= WineVersionString + ' ' + vWineGetVersion();
        FreeLibrary(ntdll);
      end;
    Except
    End;


    Try
      S:=TFileStream.Create('z:\etc\issue', fmOpenRead);
      i:= min(S.Size, 300);
      SetLength(sd, i);
      S.ReadBuffer(sd[1], i);
      S.Free;
      sd:= StringReplace(sd, '\n', ' ', [rfReplaceAll, rfIgnoreCase]);
      sd:= StringReplace(sd, '\l', ' ', [rfReplaceAll, rfIgnoreCase]);
      sd:= StringReplace(sd, #10, ' ', [rfReplaceAll, rfIgnoreCase]);
      sd:= StringReplace(sd, #13, ' ', [rfReplaceAll, rfIgnoreCase]);
      sd:= trim(sd);
      if sd <> '' then WineVersionString:= WineVersionString + ' / ' + sd;
    Except
    End;

  end;

  function GetZIsRoot: longbool;
  begin
    Result:= //FileExists('z:\etc\fstab') or
             FileExists('z:\usr\lib\libc.dylib')
          or FileExists('z:\usr\lib\libc.so');
  end;
end.

