{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************}
const

  { the following two headers are built by the
    TMessageContainer.LoadFiles() method using the
    un.texsages.h header as a reference

    Did you ever see a program that modifies its own sources, huh? ^_^ }

  BuiltInRussianMessages: array[MI_CGE_TITLE..MI_LAST_BUILTIN_MESSAGE] of WideString = (
    {$include cl_msg_ru.h}
    '');
    
  BuiltInEnglishMessages: array[MI_CGE_TITLE..MI_LAST_BUILTIN_MESSAGE] of WideString = (
    {$include cl_msg_en.h}
    '');


type
  TMessageContainer = class
    constructor Create;
    procedure LoadFiles;
  protected
    M: array of array [TMessageID] of WideString;
    LID: array of AnsiString;
    CurrentLang, SubstituteLang: integer;
    function _GetMessage(index: TMessageID): WideString;
    function _ReadLid(i: integer): AnsiString;
  public
    property CurrentLanguage: integer read CurrentLang;
    property SubstituteLanguage: integer read SubstituteLang;
    property Msg[index: TMessageID]: WideString read _GetMessage; default;
    function GetMessage(LangInd: integer; ind: TMessageID): WideString;
    property LanguageID[index: integer]: AnsiString read _ReadLid;
    function LanguageName(LangInd: integer): WideString; overload;
    function LanguageName: WideString; overload;
    procedure SetLanguage(i: integer);
    function NumLanguages(): integer;
  end;

var
  MessageContainer: TMessageContainer;
  
  
