procedure TMotherSoundMan.TestGong;
begin
  if NowRestarting or (MotherState.InstallPath = '') then Exit;
  PlayWav('logo.wav');
end;

procedure TMotherSoundMan.PlayWav(filename: ansistring);
var
  s: TFileStream;
begin
  try
    s:= TFileStream.Create(MotherState.InstallPath + SoundsDir + filename, fmOpenRead);
    f_vawdata:= DecodeWav(s);
    s.Free;
    if Length(f_vawdata) = 0 then raise Exception.Create('Unsupported format: not a 16-bit mono PCM!');
    PlaySound(Length(f_vawdata) - 1, word(f_vawdata[0]), @f_vawdata[1]);
  except
    AddLog(RuEn(
      'Не удалось воспроизвести звук!'#10#13'  %0',
      'Failed to play the sound!'#10#13'  %0'),[{(ExceptObject as Exception).Message}StopDying()]);
  end;
end;

(*
double cubicInterpolate (double p[4], double x) {
	return p[1] + 0.5 * x*(p[2] - p[0] + x*(2.0*p[0] - 5.0*p[1] + 4.0*p[2] - p[3] + x*(3.0*(p[1] - p[2]) + p[3] - p[0])));
}
*)

function CubicInterpolateInt16Ar(data: Pointer; xi: Float; maxInd: integer): SmallInt;
  var
    p: array[0..3] of PSmallInt;
    j: integer;
    x: float;
begin
  for j:= 0 to 3 do
    Pointer(p[j]):= data + max(0, min(Trunc(xi) - 1 + j, maxInd)) * SizeOf(SmallInt); // * 2
  x:= Frac(xi);
  Result:= Round(Random() + 1.0 * p[1]^ + 0.5 * x*(p[2]^ - p[0]^ + x*(2.0*p[0]^ - 5.0*p[1]^ + 4.0*p[2]^ - p[3]^ + x*(3.0*(p[1]^ - p[2]^) + p[3]^ - p[0]^))));
//  return p[1] + 0.5 * x*(p[2] - p[0] + x*(2.0*p[0] - 5.0*p[1] + 4.0*p[2] - p[3] + x*(3.0*(p[1] - p[2]) + p[3] - p[0])));
end;

procedure TMotherSoundMan._Resample(src_ptr, dst_ptr: pointer; src_samples, dst_samples: integer);
var
  i, j: integer;
  f, fracp, ratio: float;
begin
AddLog('-- Resample %0 to %1', [src_samples, dst_samples]);
  for i:= 1 to dst_samples - 1 do
    SmallInt((dst_ptr + i*2)^):= SmallInt((src_ptr + Trunc(i * (src_samples / dst_samples))*2)^);
//    CubicInterpolateInt16Ar(src_ptr, i * (src_samples / dst_samples), src_samples - 1);
  (*
  ratio:= (src_samples - 1) / (dst_samples - 1);
  word(dst_ptr^):= word(src_ptr^);
  for i:= 1 to dst_samples - 1 do begin
    f:= i * ratio;
    fracp:= Frac(f);
    j:= Trunc(f);
    word((dst_ptr + i*2)^):= Trunc(
      word((src_ptr + j*2)^)*f*f*f
      + word((src_ptr + j*2 + 2)^)*f*f
      + word((src_ptr + j*2 + 4)^)*f
      + word((src_ptr + j*2 + 6)^)*f
    )
  end;
  word((dst_ptr + (dst_samples - 1) * SizeOf(word))^):= word((src_ptr + (src_samples - 1) * SizeOf(word))^)
  *)
end;


