  Procedure ClearWarningQueue;
  begin
    WarningQueue.Length:=0;
  end;

  Function IsWarningQueueEmpty: boolean;
  begin
    Result:=(WarningQueue.Length = 0);
  end;

  Function PullWarningsFromQueue: WideString;
  var
    i: integer;
    r: WideString;
  begin
    r:='';
    For i:=WarningQueue.High downto 0 do begin
      r:=r + WarningQueue[i];
      if i > 0 then r:=r + #10#13#10#13;
    end;
    ClearWarningQueue;
    Result:=r;
  end;

  var CachedLog: array of WideString;

  procedure WriteLogToFile(u: WideString; EraseLF: boolean);
  var
    a: AnsiString;
    f: file;
    i: integer;
    var cl: array of WideString;
  begin
    if u = '' then Exit;
    if DontWriteALog then begin
      if EraseLF and (Length(CachedLog) > 0)
        then CachedLog[High(CachedLog)]+= u
        else begin
          SetLength(CachedLog, Length(CachedLog) + 1);
          CachedLog[High(CachedLog)]:= u;
        end;
    end else begin
      if Length(CachedLog) > 0 then begin
        cl:= CachedLog;
        SetLength(CachedLog, 0);
        for i:= 0 to High(cl) do begin
          WriteLogToFile(cl[i], false);
          cl[i]:= '';
        end;
      end;
      AssignFile(f, MotherState.HomePath + 'LOG');
      if not fileexists(MotherState.HomePath + 'LOG')
        then begin
          Rewrite(f, 1);
          u:=#$FEFF + u;//unicode text signature (zero-width space)
        end
        else begin
          Reset(f, 1);
          if EraseLF then Seek(f, FileSize(f) - 2)
                     else Seek(f, FileSize(f) - 1)
        end;
      a:=Utf8Encode(u);
      BlockWrite(f, a[1], length(a));
      CloseFile(f);
    end;
  end;

  Procedure AddLog(U: WideString; Param: array of const);
  begin
    U:= PervertedFormat(U, Param);
    EnterCriticalsection(MotherState.CriticalSection);
     {$ifdef unix}
      WriteLn;
      Writeln;
      Write(TrimRight(Utf8Encode(U)));
     {$endif}

      U:=U + #10#13;

      if not DontWriteALog then begin //a special case. We don't want to ruin
                                    //the log of an already running instance.
        if Assigned(Console) then begin
          Console.Add(WideToCp1251(U));
    //       if CurrentOwner = NOT_A_MODULE then _cgeHeartBeat;
        end;
        WriteLogToFile(u, No);
      end;
    LeaveCriticalSection(MotherState.CriticalSection);
  end;

  Procedure AddLogComment(U: WideString; Param: array of const);
  begin
    U:= PervertedFormat(U, Param);
    EnterCriticalsection(MotherState.CriticalSection);
      {$ifdef unix}
      Write(TrimRight(Utf8Encode(u)));
      {$endif}
      U:=U + #10#13;

      if Assigned(Console) then begin
        Console.AddComment(WideToCp1251(U));
  {      if Console.Count > 0
          then Console[Console.Count - 1]
            := Copy(Console[Console.Count - 1], 1, Length(Console[Console.Count - 1]) - 2) + WideToAnsi(U)
          else Console.Add(WideToAnsi(U));}
  //       if CurrentOwner = NOT_A_MODULE then _cgeHeartBeat;
      end;
      if not DontWriteALog then WriteLogToFile(u, Yes);
    LeaveCriticalSection(MotherState.CriticalSection);
  end;

  Procedure AddLog(S: Ansistring; Param: array of const);
  begin
    AddLog(AnsiToWide(S), Param);
  end;

  Procedure AddLog(mID: TMessageID; Param: array of const);
  begin
    AddLog(MessageContainer[mID], Param);
  end;

  Procedure AddLog(mID: TMessageID);
  begin
    AddLog(MessageContainer[mID], []);
  end;

  Procedure AddLogComment(S: AnsiString; Param: array of const);
  begin
    AddLogComment(AnsiToWide(S), Param);
  end;

  Procedure AddLogComment(mID: TMessageID; Param: array of const);
  begin
    AddLogComment(MessageContainer[mID], Param);
  end;

  Procedure AddLogComment(S: AnsiString);
  begin
    AddLogComment(S,[]);
  end;

  Procedure AddLogComment(U: WideString);
  begin
    AddLogComment(U,[]);
  end;


  Procedure AddLogComment(mID: TMessageID);
  begin
    AddLogComment(mID,[]);
  end;


  Procedure AddLogOK; cdecl;
  begin
    AddLogComment(MessageContainer[MI_LOG_SUCCESS]);
  end;

  Procedure AddLog(S: AnsiString);
  begin
    AddLog(S, []);
  end;

  Procedure AddLog(U: WideString);
  begin
    AddLog(U, []);
  end;

  procedure VerboseLog(mID: TMessageID; Param: array of const);
  begin
    if MotherState.DebugMode then AddLog(mID, param);
  end;

  Procedure VerboseLogOk;
  begin
    if MotherState.DebugMode then AddLogOk;
  end;

  procedure VerboseLog(mID: TMessageID);
  begin
    if MotherState.DebugMode then AddLog(mID, []);
  end;


  Procedure VerboseLog(S: AnsiString; Param: array of const);
  begin
    if MotherState.DebugMode then AddLog(S, Param);
  end;

  Procedure VerboseLog(S: AnsiString);
  begin
    if MotherState.DebugMode then AddLog(S, []);
  end;

