{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************

    This file contains a template for dynamic array wrapper classes.

 **********************************************************************}
{$include cl_dyna_1template.inc}

{$ifdef header}
  type2name = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of typename;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): typename;
    procedure _Write(ind: cardinal; p: typename);
    function _ReadLast: typename;
    procedure _WriteLast(z: typename);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:typename read _Read write _Write; DEFAULT;
    property Last:typename read _ReadLast write _WriteLast;
  End;

{$else header}

function type2name._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function type2name._Read(ind: cardinal): typename;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=typename(a[ind]);
end;

procedure type2name._Write(ind: cardinal; p: typename);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure type2name._Resize(L: integer);
var j: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin typename(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(typename.Create);
//WriteLn('*** 3');
end;

function type2name._ReadLast: typename;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=typename(a[s-1]);
end;

procedure type2name._WriteLast(z: typename);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure type2name.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure type2name.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}

