{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 **********************************************************************}

Type
{
  TAOP = array of pointer;
  TAOC = array of cardinal;
  TAOI = array of integer;
  TAOS = array of string;
  TAOB = array of LongBool;
  TAOO = array of TObject;
  T2DAOI = array of array of Integer;
  T2DAOS = array of array of String;
  T2DAOO = array of array of TObject;
}

  TDyna = Class(TObject)
    Constructor Create;
    Destructor Destroy; Override;
    procedure Resize(NewLen: integer);
    procedure Increment;
    procedure Decrement;
    procedure ClearMem; virtual; abstract;
    procedure SetRect(a, b: integer); virtual;
  Protected
    s, sm, es: integer;
    function GetSize: integer;
    function GetHigh: integer;
    procedure _Resize(L: integer); virtual; abstract;
    function _ReadDPTR: pointer; virtual; abstract;
  Public
    property High: integer read GetHigh;
    property Length: integer read s write Resize;
    property DPTR:pointer read _ReadDPTR;
  End;

// Gee! Look, people! Now you can use templates in Pascal!
// (though, in somewhat perverted way - through macros and compiler
//  directives - but it works nevertheless!..)

{$ifdef fpc}
  {$include cl_dyna_freepascal.h}
{$else}
  //Delphi, such an asshole, doesn't support macros!
  //use CFDD to utility to auto-convert
  //  cl_dyna_freepascal.h into cl_dyna_delphi.h.
  {$include cl_dyna_h_delphi.inc}
{$endif}
