  function NoDsHint: TMessageId;
  begin
    if MotherState.OS in WindowsEmulators
      then Result:= MI_HINT_NO_DSOUND8_WINE
      else
        if MotherState.OS in WindowsShouldHaveBuiltInOpenAL
          then Result:= MI_HINT_NO_DSOUND8_VISTAANDUP
          else Result:= MI_HINT_NO_DSOUND8_XPANDBELOW;
  end;


  function GetDSProcAddress(ProcName: ansistring): Pointer;
  var
    baseaddr: pointer;
    exename: string;
  begin
    Result:= GetProcAddress(DirectSoundDll, PChar(ProcName));
    if Assigned(Result) and MotherState.DebugMode then begin
      {$ifdef cpu64}
      AddLog('  %0() at %1', [ProcName, Result]);
      {$else}
      GetModuleByAddr(Result, baseaddr, exename);
      AddLog('  %0() at %1 in %2', [ProcName, Result, exename]);
      {$endif}
    end;
    if not Assigned(Result)
      then Die(MI_ERROR_DIRECTSOUND8_FUNCTION_NOT_FOUND,
        [ProcName + '()', DirectSoundDllName, MessageContainer[NoDsHint()]]);
  end;

 Procedure InitDirectSound;
    function LoadDSLibrary: boolean;
    begin
      DirectSoundDllName:= config.path['DirectX','DirectSound8dll'];
      if DirectSoundDllName='' then DirectSoundDllName:='NULL';
      if MotherState.DebugMode then AddLog('  Loading %0...', [DirectSoundDllName]);
      DirectSoundDll:= LoadLibrary(PChar(DirectSoundDllName));
      Result:= DirectSoundDll <> 0;
      if MotherState.DebugMode then
        if not result then AddLogComment('FAILED.')
                      else AddLogComment('Ok.');
    end;
  begin
    if MotherState.DebugMode then AddLog('Init DirectSound 8...');
    if not LoadDsLibrary()
      then Die(MI_ERROR_DIRECTSOUND8NOTFOUND,
                 [DirectSoundDllName, MessageContainer[NoDsHint()]]);

    if MotherState.DebugMode then AddLog('  Loading the procedure addresses from the DLL...');
    //DirectSoundCreate:= GetDSProcAddress('');
    pointer(DirectSoundEnumerateW):= GetDSProcAddress('DirectSoundEnumerateW');
    //DirectSoundEnumerateA:= GetDSProcAddress('');
//    DirectSoundCaptureEnumerateW:=
    //DirectSoundCaptureEnumerateA:=
    pointer(DirectSoundCreate8):= GetDSProcAddress('DirectSoundCreate8');
    pointer(GetDeviceID):= GetDSProcAddress('GetDeviceID');
  end;

  Procedure CloseDirectSound;
  begin
    If LibAL <> 0 then FreeLibrary(LibAL);
  end;

  function DSErrorString(h: HRESULT): widestring;
  begin
    case h of
      DS_OK, DS_NO_VIRTUALIZATION: Result:='';
      DSERR_ALLOCATED: Result:='DSERR_ALLOCATED: '#10#13'  The call failed because resources (such as a priority level)'#10#13'  were already being used by another caller';
      DSERR_CONTROLUNAVAIL: Result:='DSERR_CONTROLUNAVAIL: '#10#13'  The control (vol, pan, etc.) requested by the caller is not available';
      DSERR_INVALIDPARAM: Result:='DSERR_INVALIDPARAM: '#10#13'  An invalid parameter was passed to the returning function';
      DSERR_INVALIDCALL: Result:='DSERR_INVALIDCALL: '#10#13'  This call is not valid for the current state of this object';
      DSERR_GENERIC: Result:='DSERR_GENERIC: '#10#13'  An undetermined error occurred inside the DirectSound subsystem';
      DSERR_PRIOLEVELNEEDED: Result:='DSERR_PRIOLEVELNEEDED: '#10#13'  The caller does not have the priority level required for the function to'#10#13'  succeed';
      DSERR_OUTOFMEMORY: Result:='DSERR_OUTOFMEMORY: '#10#13'  Not enough free memory is available to complete the operation';
      DSERR_BADFORMAT: Result:='DSERR_BADFORMAT: '#10#13'  The specified WAVE format is not supported';
      DSERR_UNSUPPORTED: Result:='DSERR_UNSUPPORTED: '#10#13'  The function called is not supported at this time';
      DSERR_NODRIVER: Result:='DSERR_NODRIVER: '#10#13'  No sound driver is available for use';
      DSERR_ALREADYINITIALIZED: Result:='DSERR_ALREADYINITIALIZED: '#10#13'  This object is already initialized';
      DSERR_NOAGGREGATION: Result:='DSERR_NOAGGREGATION: '#10#13'  This object does not support aggregation';
      DSERR_BUFFERLOST: Result:='DSERR_BUFFERLOST: '#10#13'  The buffer memory has been lost, and must be restored';
      DSERR_OTHERAPPHASPRIO: Result:='DSERR_OTHERAPPHASPRIO: '#10#13'  Another app has a higher priority level, preventing this call from'#10#13'  succeeding';
      DSERR_UNINITIALIZED: Result:='DSERR_UNINITIALIZED: '#10#13' This object has not been initialized';
      DSERR_NOINTERFACE: Result:='DSERR_NOINTERFACE: '#10#13'  The requested COM interface is not available';
      DSERR_ACCESSDENIED: Result:='DSERR_ACCESSDENIED: '#10#13'  Access is denied';
      DSERR_BUFFERTOOSMALL: Result:='DSERR_BUFFERTOOSMALL: '#10#13'  Tried to create a DSBCAPS_CTRLFX buffer shorter than DSBSIZE_FX_MIN milliseconds';
      DSERR_DS8_REQUIRED: Result:='DSERR_DS8_REQUIRED: '#10#13'  Attempt to use DirectSound 8 functionality on an older DirectSound object';
      DSERR_SENDLOOP: Result:='DSERR_SENDLOOP: '#10#13'  A circular loop of send effects was detected';
      DSERR_BADSENDBUFFERGUID: Result:='DSERR_BADSENDBUFFERGUID: '#10#13'  The GUID specified in an audiopath file does not match a valid MIXIN buffer';
      DSERR_OBJECTNOTFOUND: Result:='DSERR_OBJECTNOTFOUND: '#10#13'  The object requested was not found';
      DSERR_FXUNAVAILABLE: Result:='DSERR_FXUNAVAILABLE: '#10#13'The effects requested could not be found on the system, or they were found'#10#13'  but in the wrong order, or in the wrong hardware/software locations.';
    else
      Result:= RuEn('Unknown error code ','Неизвестный код ошибки ') + IntToHex(h, 8) + 'h';
    end;
  end;


