{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 ********************************************************************** 

   This file contains the graphical console class header.

 **********************************************************************}

  const
   ntz = 256; { procedural texture dimensions for the "static" effect
                on the Blue Screen of Death.}
   Logo_fadein = 0.35; //its share of the animation period
   Logo_fadeout = 0.5; //ditto
   logo_size = 256;

 type
   TDefaultBGs = (dbTitle, dbError, dbWarning, dbInstalling, dbShutdown);

     { TConsole }
 type
   TConsole = class (TStringList)
   private
     f_texture, f_bgtex, f_bsodtexture, f_noisetexture: glUint;
     f_logotex: array of glUint;
     f_limit,
     f_hidetime,
     f_fadetime,
     f_tostretch: integer;
     f_fade: GLfloat; //background only
     f_vis: boolean;
     f_sb: integer;
     f_lasttime: TDateTime;
     f_fadeline: integer;
     f_logoframe: integer;
     f_noisearray: packed array[0..(ntz div 4)-1, 0..ntz-1] of byte;
     f_bgname: string;
     f_bgptr: pointer;
     f_bgmip: integer;
     procedure _SetVisible(b: boolean);
     procedure _ApplyBg(var b: TImageData);
     function _RequiredBgmip(): integer;
   public
     Constructor Create;
     procedure Draw (Clearbackground, DrawBg: boolean);
     procedure DrawBackground();
     procedure DrawLogo();
     procedure SetBg (name: string);
     procedure SetBgPtr (p: pointer; size: integer);
     procedure SetDefaultBg (bg: TDefaultBGs);
     procedure SetFadeIn(f: GLfloat);
     procedure InitAnimatedLogo;
     procedure Add (S: AnsiString);
     procedure AddComment(S: AnsiString);
     procedure Fade();
     procedure InitGL;
     procedure Delete (i: integer); override;
     property Scrolledback: integer read f_sb write f_sb;
     Property AlwaysVisible: boolean read f_vis write _SetVisible;
   end;

 var
   Console: TConsole;


 var
   ConsoleCharWidth: integer = 9;
   ConsoleCharHeight: integer = 13;
   ConsoleCharXstep: integer = 256 div 16;
   ConsoleImageWidth: GLfloat = 256.0;
   ConsoleCharOffsetS: GLfloat = 4;
   ConsoleCharOffsetT: GLfloat = 2;
   ConsoleBorders: GLfloat = 5.0;//0;//5.0;
   ConsoleUseCondensedFont: boolean = No;

