
{
    This file is part of Chentrah,
    Copyright (C) 2004-2008 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 ********************************************************************** 

    This file contains configuration manager class header.

 **********************************************************************}

 type
   TConfigManager = class
   protected
     Ini: array[0..1] of TIniFile;
     wherefound: integer;
     function _Find(s, i: string): string;
     function _ReadStr(s, i: string): string;
     function _ReadPath(s, i: string): string;
     function _ReadBool(s, i: string): boolean;
     function _ReadInt(s, i: string;  min, max: integer): integer; OVERLOAD;
     function _ReadInt(s, i: string): integer; OVERLOAD;
     function _ReadFloat(s, i: string): float;
     function _ReadIntChk(s, i: string; min,max: integer): integer;
     function _ReadFloatChk(s, i: string; min,max: float): float;
     procedure _WriteStr(s,i,d: string);
     procedure _WriteInt(s,i: string; v:integer);
     procedure _WriteFloat(s,i: string; v:float);
     procedure _WriteIntChk(s,i: string; min, max, v:integer);
     procedure _WriteFloatChk(s,i: string; min, max, v:float);
     procedure _WriteBool(s,i: string; b: boolean);
     procedure _WritePath(s,i,d: string);
     procedure ScreamLimitsRead(fnum: integer; s,i: string; val, min, max: integer); overload;
     procedure ScreamLimitsRead(fnum: integer; s,i: string; val, min, max: float); overload;
     //procedure ScreamLimitsWrite;
   public
     SilentCorrectionsOnWrite,
     StrictLimitsCheck: boolean;
     Constructor Create;
     Destructor Destroy; OVERRIDE;
     procedure LoadMainFile;
     procedure LoadUserFile;
     function Wherefoundname: WideString;
     Property Int[sect, id: string]: integer read _ReadInt write _WriteInt; DEFAULT;
     Property IntChk[sect, id: string; min, max: integer]: integer read _ReadIntChk write _WriteIntChk;
     Property FloatChk[sect, id: string; min, max: float]: float read _ReadFloatChk write _WriteFloatChk;
     Property Bool[sect, id: string]: boolean read _ReadBool write _WriteBool;
     Property Str[sect, id: string]: string read _ReadStr write _WriteStr;
     Property Path[sect, id: string]: string read _ReadPath write _WritePath;
   end;

 var
   Config: TConfigManager;

