var
  LibAL: {$ifdef use_dynlibs} THandle {$else} Pointer {$endif} ;
  LibALName: string;


  function NoALHint: TMessageId;
  begin
    {$ifdef unix}
      {$ifdef darwin}
        Result:= MI_HINT_NO_OPENAL_MACOSX;
      {$else}
        Result:= MI_HINT_NO_OPENAL_LINUX;
      {$endif}
    {$else}
      if MotherState.OS in WindowsEmulators
        then Result:= MI_HINT_NO_OPENAL_WINE
        else
          if MotherState.OS in WindowsShouldHaveBuiltInOpenAL
            then Result:= MI_HINT_NO_OPENAL_VISTAANDUP
            else Result:= MI_HINT_NO_OPENAL_XPANDBELOW;
    {$endif}
  end;

  function GetALProcAddress(ProcName: ansistring): Pointer;
  var
    baseaddr: pointer;
    exename: string;
  begin
    {$ifndef use_dynlibs}
      Result:=dlsym(LibAL, PChar(ProcName));
    {$else}
      Result:=GetProcAddress(LibAL, PChar(ProcName));
    {$endif}
    if Assigned(Result) and MotherState.DebugMode then begin
      {$ifdef cpu64}
      AddLog('  %0() at %1', [ProcName, Result]);
      {$else}
      GetModuleByAddr(Result, baseaddr, exename);
      AddLog('  %0() at %1 in %2', [ProcName, Result, exename]);
      {$endif}
    end;
    if not Assigned(Result)
      then Die(MI_ERROR_AL_FUNCTION_NOT_FOUND,
        [ProcName + '()', utf8Decode(LibAlName), MessageContainer[NoAlHint()]]);
  end;

  function exGetALProcAddress(ProcName: PAnsiChar): Pointer; cdecl;
  begin
   try
    Result:=GetALProcAddress(PCharToString(ProcName));
   except
    ProcessGuardedException();
   end;
  end;

  Procedure InitOpenAL;
  var
    cw: word;
    i: integer;
    al_name,
    al_name0: string;
    function LoadALLibrary: boolean;
    begin
      if MotherState.DebugMode then AddLog('  Loading %0...', [al_name]);
     {$ifdef use_dynlibs}
      LibAL:=LoadLibrary(PChar(al_name)); //Windows and MacOS X
      Result:= LibAL <> 0;
     {$else}
      LibAL := dlopen(PChar(al_name), RTLD_NOW); //Linux
      Result:= Assigned(LibAL);
     {$endif}
     LibAlName:= al_name;
     if MotherState.DebugMode then
       if not result then AddLogComment('FAILED.')
                     else AddLogComment('Ok.');
    end;
  begin
    if MotherState.DebugMode then AddLog('Init OpenAL...');

    al_name0:= Config.Str['openal', 'AL_' + SystemSuffix + '_0'];
    i:=0;
    repeat
      al_name:= Config.Str['openal', 'AL_' + SystemSuffix + '_' + IntToStr(i)];
      if al_name=''
        then Die(MI_ERROR_OPENALDLLNOTFOUND,
                 [utf8Decode(al_name0), MessageContainer[NoAlHint()]]);
      if LoadALLibrary() then break;
      inc(i);
    until false;

    if MotherState.DebugMode then AddLog('  Loading the procedure addresses from the DLL...');
    InitALProcAddresses;

  end;


  Procedure CloseOpenAL;
  begin
   {$ifndef use_dynlibs}
     If Assigned(LibAL) then dlClose(LibAL);
   {$else}
     If LibAL <> 0 then FreeLibrary(LibAL);
   {$endif}
  end;

//exGetGlProcAddress
