{
    This file is part of Chentrah,
    Copyright (C) 2004-2009 Anton Rzheshevski (chebmaster@mail.ru).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/

 ********************************************************************** }
 {Dependencies:
  Linux:
   static:
    libc.so.6
    libdl.so.2
    libX11.so.6
    libXi.so.6 //purely for the pen tablet support. TO DO: change to dynamic, for better compatibility

   dynamic:
     libGL.so OR libGL.so.2 OR libGL.so.1.2 OR libGL.so.1 -- whichever is found first. Required.
     libopenal.so OR libopenal.so.0 OR libopenal.so.1 -- whichever is found first.  Required or optional, depending on the settings

  Windows:
   static:
    kernel32.dll
    advapi32.dll  //GetUserNameW() only
    gdi32.dll     //SwapBuffers() only
    oleaut32.dll
    user32.dll    //GetDC() only
    winmm.dll     //timeBeginPeriod() only

   dynamic:
    wintab.dll   -- optional, for pen tablet support
    opengl32.dll -- required
    openal32.dll OR dsound.dll -- depending on the settings. Required or optional, depending on the settings
 }

  {$ifndef fpc}
    {$fatal NOT COMPATIBLE WITH DELPHI. Use FreePascal 2.6.0 or higher.}
    <<<<<<<<<<<<
  {$endif}

  {$ifdef windows}
    {$memory 100000000, 10000} // 100 Mbytes stack, 10 Kbytes heap.
  {$endif}
 {  Note: the heap size doesn't really affect anything,
      it'll grow automatically anyway.
    The stack size, on the other hand, is an absolute limit.
      reach it - and you crash with "unknown run-time error 202"
      (aka stack overflow). We need a lot of stack space
      since the game modules use Chepersy
      that relies on heavy recursive algorithms.
    In Linux the stack limit is chosen by the Kernel
      according some obscure settings I know nothing about.
  }
  
  program chentrah;
  {$mode objfpc}
  {$longstrings on}
  {$codepage utf-8}
  {$ifdef windows}
    {$apptype gui}
    {$ifdef cge_rc_directly}
      {$r chentrah.rc}
      //2013: abandoned Linux, developing on Windows now. The problem not actual.
    {$else}
      {$r chentrah.res} {  the application icon.
        NOTE: although fpc 2.2.0 and up allows to invoke a *.rc
          file directly, it just calls on windres,
          but windres CRASHES in Wine.
        So, the only way is to compile the icon into a *.res
          is using some third-party resource compiler that
          *does* work in Wine (such as one from
          http://www.jorgon.freeserve.co.uk/ )
         Sept. 2012: switched to using wrc (Wine Resource Compiler) adding a call to it into build.sh
      }
    {$endif}
  {$endif}
  {$ifdef darwin}
    {r chentrah_macosx.rc}
  {$endif}

  uses sysutils, cge;//, OpenJpeg;
  
{$IFDEF WINDOWS}{R manifest.rc}{$ENDIF}

  begin
    main();
  end.



