program cachecastrator;

{$mode objfpc}{$H+}

{$ifdef silent}
  {$APPTYPE GUI}
{$else}
  {$APPTYPE CONSOLE}
{$endif}

uses
  Classes, SysUtils, Windows;

{$ifdef silent}
Procedure Die(ErrorMessage: string);
begin
  Errormessage:=Errormessage + #10#13#10#13 + 'Make sure you running CacheCastrator with administrator privileges!';
  MessageBox(0, PChar(ErrorMessage), 'CacheCastrator crashed!', MB_ICONERROR);
  Halt(0);
end;
{$else}
Procedure Die(ErrorMessage: string);
begin
  WriteLn(errormessage);
  WriteLn('Make sure you running cachecastrator with administrator privileges!');
  Readln; Halt(0);
end;
{$endif}


type
  PSystemCacheInformation = ^TSystemCacheInformation;
  TSystemCacheInformation = packed record
    CurrentSize,
    PeakSize,
    PageFaultCount,
    MinimumWorkingSet,
    MaximumWorkingSet: cardinal;
    Unused: packed array[0..3] of cardinal;
  end;

function NtQuerySystemInformation(
   SystemInformationClass: cardinal;
   var SystemInformation: TSystemCacheInformation;
   SystemInformationLength: cardinal;
   var ReturnLength: cardinal): cardinal; stdcall; external 'ntdll.dll';
   
function NtSetSystemInformation(
   SystemInformationClass: cardinal;
   var SystemInformation: TSystemCacheInformation;
   SystemInformationLength: cardinal): cardinal; stdcall; external 'ntdll.dll';

const SYSTEMCACHEINFORMATION = $15;

type
  TPrivileges = packed record
    Count: DWORD;
    LUID: Int64;
    Attributes: DWORD;
  end;

procedure SetPrivileges;
var
  Token: THandle;
  Privileges: TPrivileges;
begin
  if not OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_PRIVILEGES OR TOKEN_QUERY, Token)
    then Die('ERROR! Calling the OpenProcessToken() function failed.');
  Privileges.Count:=1;
  if not LookupPrivilegeValue(nil, SE_INCREASE_QUOTA_NAME, @(Privileges.luid))
    then Die('ERROR! Calling the LookupPrivilegeValue() function failed.');
  Privileges.Attributes:=SE_PRIVILEGE_ENABLED;
  if not AdjustTokenPrivileges(Token, False, @Privileges, 0, nil, nil)
    then Die('ERROR! Calling the AdjustTokenPrivileges() function failed.');
  if not SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS)
    then Die('ERROR! Calling the SetPriorityClass() function failed.');
end;
   
var
  Info: TSystemCacheInformation;
  l: cardinal;
  period: integer = 1000;
  AllowedMax: cardinal;

begin
  SetPrivileges;
  
{$ifndef silent}
  WriteLn;
  WriteLn('          *** CACHE CASTRATOR! ***');
  WriteLn('             An agressive tool');
  WriteLn('   for taming the pig-headed Windows XP');
  WriteLn;
  WriteLn('     Created by Cheb from the sources');
  WriteLn('                   of the');
  WriteLn('    infamous CacheSet by Mark Russinovich');
  WriteLn('         (http://www.ntinternals.com),');
  WriteLn('     translated from C to FreePascal 2.0');
  Writeln;
{$endif}
  Try
    AllowedMax:=StrToInt(ParamStr(1));
  Except
    Die('ERROR! Invalid command line parameter!'#10#13'Usage: cachecastrator <file cache limit in megabytes>'#10#13'(Note: the number must be an integer one!');
  End;
{$ifndef silent}
  WriteLn('       The maximum allowed size of the');
  WriteLn('   file cache will henceforth be limited to');
  WriteLn('                ',AllowedMax,' megabytes!');
  Writeln;
{$endif}
  repeat
    FillChar(Info, SizeOf(Info), 0);
    if NtQuerySystemInformation(SYSTEMCACHEINFORMATION, Info, SizeOf(Info), l) <> 0
      then Die('ERROR! Calling the NtQuerySystemInformation() function failed.');

    if (Info.CurrentSize div (1024*1024)) > AllowedMax then begin
{$ifndef silent}
      WriteLn('.. Castrated at ', Info.CurrentSize div (1024 *1024), 'Mb ');
{$endif}
      Info.MaximumWorkingSet:=AllowedMax * (1024*1024 div 2);
      Info.MinimumWorkingSet:=Info.MaximumWorkingSet div 4;
      if NtSetSystemInformation(SYSTEMCACHEINFORMATION, Info, SizeOf(Info)) <> 0
        then Die('ERROR! Calling the NtSetSystemInformation() function failed.');
      Period:=200;
    end
    else begin
      Inc(Period, 5); If Period > 500 then Period:=500;
    end;
    Sleep(period);
  until false;
end.
