{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains  wide string handling routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


 procedure InitUnicode;
 var
   j: integer;
   a: AnsiChar;
 begin
   For j:=0 to 127 do _UniToAnsiTable[j]:=chr(j);
   For j:=128 to $FFFF do _UniToAnsiTable[j]:='?'; //everything else is undefined at first.
   For a:=#0 to #127 do _AnsiToUnitable[a]:={$ifdef fpc}a;{$else}WideChar(ord(a));{$endif}//Dumb Delphi! :(
   
   //Russian alphabet:
   // "a" to "ya", capitals then smalls, 32 + 32 characters
   For j:=$0410 to $044F do _UniToAnsiTable[j]:=chr($C0 + j - $0410);
   //33st character, "yo":
   _UniToAnsiTable[$0401]:=chr($A8); //capital
   _UniToAnsiTable[$0451]:=chr($B8); //small
   
   For a:=#128 to #$DF do _AnsiToUnitable[a]:='?';
   //Russian alphabet again...
   For a:=#$C0 to #$FF do _AnsiToUnitable[a]:=WideChar($0410 + ord(a) - $C0);
   //"yo":
   _AnsiToUnitable[#$A8]:=WideChar($0401);
   _AnsiToUnitable[#$B8]:=WideChar($0451);
 end;
 
 function WideToAnsi(u: WideString): AnsiString;
 var
   j: integer;
 begin
   SetLength(Result, Length(u));
   For j:=1 to Length(u) do Result[j]:= _UniToAnsiTable[ord(u[j])];
 end;

 function AnsiToWide(a: AnsiString): WideString;
 var
   j: integer;
 begin
   SetLength(Result, Length(a));
   For j:=1 to Length(a) do Result[j]:= _AnsiToUniTable[a[j]];
 end;

 function TrimWideString (u: WideString): WideString;
 var j, a, b: integer;
 begin
   Result:='';
   a:=1;
   While (a < length(u)) and (ord(u[a]) <= 32) do inc(a);
   b:=length(u);
   While (b > 1) and (ord(u[a]) <= 32) do dec(b);
   if a > b then exit
   else
     For j:=a to b do Result:=Result + u[j - a + 1];
 end;

 function WideReplace(u: WideString; a, b: AnsiString): WideString; OVERLOAD;
 begin
   Result:=WideReplace(u, AnsiToWide(a), AnsiToWide(b));
 end;
 
 function WideReplace(u: WideString; a: AnsiString; b: WideString): WideString; OVERLOAD;
 begin
   Result:=WideReplace(u, AnsiToWide(a), b);
 end;


function WideCOPY(s: WideString; pos, len: integer): WideString;
var i: integer;
begin
  Result:='';
  For i:=pos to pos + len - 1 do begin
    if i > Length(s) then Exit;
    Result:=Result + s[i];
  end;
end;

function WideReplace(u, a, b: WideString): WideString; OVERLOAD;
var p: integer;
    s: WideString;
begin
  s:=u;
  p:=WidePos(a, s);
  While p > 0 do begin
    s:=WideCOPY(s, 1, p - 1) + b + WideCOPY(s, p + Length(a), Length(s));
    p:=Pos(a, s);
  end;
  Result:=s;
end;

 function WidePos(a, u: WideString): integer;
 var
   j, i: integer;
 begin
   Result:=-1;
   For j:=1 to length(u) do begin
     i:=1;
     While (i < Length(a) + 1) and (a[i] = u[i + j - 1]) do inc(i);
     if i = (Length(a) + 1) then begin
       Result:=j;
       Exit;
     end;
   end;
 end;




