{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains  global type definitions.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}


{$minenumsize 4}
{$ifndef fpc}
  {$typeinfo on}
{$endif}

unit un_typedefs;

interface
  Type
    float = single;
    boolean = longbool;
    {$ifndef fpc}
      winbool = longbool;
      dword = cardinal;
    {$endif}

    TCbMessage = (
      Re_OnGetFocus, Re_OnLoseFocus, Re_OnMouseMove,
      Re_OnResize, Re_OnPress, Re_OnRelease, Re_OnType,
      Re_OnCreate, Re_OnDestroy, Re_OnCycle, Re_OnUnload, Re_OnLoad, Re_TexturesDeleted, Re_Stub);

    TImageMode = (Im_RGB, Im_RGBA, Im_Gray{, Im_GrayAlpha});

    TIntegerArray = array of integer;

 Const

  {$include un_keys.inc}

  {$ifdef cge}
    {$ifndef win32}
      {$fatal AS OF JUNE 2006 LINUX SUPPORT IS TEMPORARILY DOWN}
      {$ifndef linux}
        {$fatal NOT PORTED TO THIS PLATFORM YET!}
      {$endif}
    {$endif}
  {$endif}

  AlignGranularity = 4;
  (*
    TO DO LATER:
    FIND A WAY TO DEFINE IT WHEN COMPILING FOR A 64-BIT PLATFORM.
    const
       MaxInt  = MaxLongint;
       AlignGranularity = 8;
    type
       Integer  = longint;
       PInteger = ^Integer;
       IntegerArray  = array[0..$effffff] of Integer;
       TIntegerArray = IntegerArray;
       PIntegerArray = ^IntegerArray;

       Cardinal = dword;
   *)

  VersionMajor = 0;
  VersionMinor = 13; // do NOT forget to reset the build number in build.h
{$ifdef fpc}
  CompileDate = {$I %DATE%};
  CompileTime = {$I %TIME%};
  CompilerVersion = 'Free Pascal ' + {$I %FPCVERSION%};
  CompileTarget = {$I %FPCTARGET%};
{$else}
  CompileDate = 'n/a';
  CompileTime = 'n/a';
  CompilerVersion = 'Delphi';
  CompileTarget = 'i586';
{$endif}

  Yes=True;
  No=False;

  PathSlash = {$ifdef win32}'\'{$else}'/'{$endif};

  Slash = PathSlash;

  SystemSuffix = {$ifdef win32}'win32'{$else}'linux'{$endif};
  DllExtension = {$ifdef win32}'.dll'{$else}'.so'{$endif};

  ImgModeBpp: array [TImageMode] of integer = (3, 4, 1{, 2});

  //This is a very important function.
  //It calculates the position of the next
  //  field in a class, taking aligning into account.
  //Used by TRegistrator class (unit mo_classes, mo_registrator.inc)
  //
  //Current version is designed for Win32 platform anf FPC 2.0.x.
  //  It may be required to adapt this function for different platforms,
  //  or even for different compiler versions.
  //
  //Parameters: a - previous field address,
  //            s - previous field size,
  //            s2 - current field size,
  //Returns: address of the next field.
  function NFA_A(a, s, s2: cardinal): cardinal;

  //Calculates align granularity for the given field size.
  function AG_A(s: cardinal): cardinal;

  var
    BottleNeckCounter1, BottleNeckCounter2: int64;

  function BoolChars(b: boolean):string;

implementation

function AG_A(s: cardinal): cardinal;
begin
  if s = 8 then Result:=8 else Result:=4;
end;


function NFA_A(a, s, s2: cardinal): cardinal;
var
  ag: cardinal;
begin
  ag:=AG_A(s2);
  Result:=(((a + s-1) div ag) + 1) * ag;
end;

function BoolChars(b: boolean):string;
begin
  if b then result:='true' else result:='false';
end;


end.

