{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the various type information functions.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{$MACRO ON}
{$MODE DELPHI}
{$RANGECHECKS OFF}

unit mo_typinfo2;

interface
  uses SysUtils,
       Classes,
       un_Typedefs,
       typinfo;

  function SizeByType(p: PTypeInfo): integer;

implementation

  function SizeByType(p: PTypeInfo): integer;
  var
    d: PTypeData;
  begin
    d:=GetTypeData(p);
    Case p^.Kind of
       tkLString, tkWString, tkAString, tkClass, tkObject, tkDynArray:
          Result:=SizeOf(pointer);
       tkFloat:
          case d^.FloatType of
            ftSingle: Result:=SizeOf(single);
            ftDouble: Result:=SizeOf(double);
            ftExtended: Result:=SizeOf(extended);
            ftComp: Result:=SizeOf(Comp);
            ftCurr: Result:=SizeOf(Currency);
          else
            Result:=0;
          end;
       tkInteger, tkEnumeration:
          case d^.OrdType of
            otSByte: Result:=SizeOf(shortint);
            otUByte: Result:=SizeOf(byte);
            otSWord: Result:=SizeOf(smallint);
            otUWord: Result:=SizeOf(word);
            otSLong: Result:=SizeOf(longint);
            otULong: Result:=SizeOf(dword);
          else
            Result:=0;
          end;
       tkInt64: Result:=SizeOf(Int64);
    else
      Result:=0;
    end;
  end;
  
  function HasGenericSavingMethod(p: PTypeInfo): boolean;
  var
    d: PTypeData;
  begin
    d:=GetTypeData(p);
    Case p^.Kind of
       tkWString, tkAString, tkObject:
          Result:=Yes;
       tkFloat:
          case d^.FloatType of
            ftSingle, ftDouble, ftExtended, ftComp, ftCurr:
              Result:=Yes;
          else
            Result:=No;
          end;
       tkInteger:
          case d^.OrdType of
            otSByte, otUByte, otSWord, otUWord, otSLong, otULong:
              Result:=Yes;
          else
            Result:=No;
          end;
       tkInt64: Result:=Yes;
       tkEnumeration: Result:=Yes;
    else
      Result:=No;
    end;
  end;
end.

