

function MsgRaw(M: TMessageId): string;
begin
  Case M of
    Mi_:;
    MI_CGEFILE_UNSUPPORTED: Result:='Unsupported version of cge-file "%0" (v%1). The file cannot be read.';
    MI_CGEFILE_ERROR_WRITE: Result:='Crashed at writing the cge-file "%0"';
    MI_CGEFILE_CORRUPT: Result:='The cge-file "%0" is corrupt and cannot be read. %1.';
    MI_CGEFILE_ERROR_READ: Result:='Crashed at reading the cge-file "%0"';
    MI_ERROR_PROGRAMMER_NO_BAKA: Result:='Programmer''s error.'#10#13#10#13'%0';
    MI_BASKET_NOT_EVERYTHING_IS_FINE_AND_DANDY: Result:='/~ There were warnings during parsing the basket: ~\'#10#13'%0'#10#13'\~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~/';
    MI_BASKET_FAIL_LOAD: Result:='Failed retrieving data from the basket.';
    MI_BASKET_EXPLAIN_UNKNOWN: Result:='Probably the data file was generated by a newer or incompatible version of program.';
    MI_BASKET_UNKNOWN_CLASS: Result:='Unknown class "%0".';
    MI_BASKET_UNKNOWN_TYPE : Result:='Unknown data type "%0".';
    MI_BASKET_TYPE_SIZE_MISMATCH: Result:='Sizes mismatch for the data type "%0".'#10#13'In the current program version it has size of %1, but the basket stores the check value of %2.';
    MI_BASKET_UNKNOWN_OBJECT_FIELD: Result:='Class "%0" does not have field "%1" of object type "%2". Since omitting objects while reading is not allowed, loading had been terminated.';
    MI_BASKET_WRONG_FIELD_TYPE: Result:='Class "%0": field "%1" is of type "%3", not "%2". Omitted.';
    MI_BASKET_UNKNOWN_FIELD: Result:='Class "%0": unknown field "%1" of type "%2". Omitted.';
    MI_BASKET_MISSING_FIELD: Result:='Class "%0": missing field "%1" of type "%2". Filled with zeroes.';
    MI_BASKET_UNKNOWN_ENUM: Result:='Enum. type "%0": unknown value "%1". Replaced with "%2".';
    MI_BASKET_ENUM_CHANGED: Result:='Enum. type "%0": the values order or cast has changed.';
    MI_BASKET_CONVERSION: Result:='Class "%0": loading requires coversion.';
    MI_ERROR_SAVING: Result:='Error saving to %0';
    MI_ERROR_LOADING: Result:='Error loading from %0';
    //: Result:='';
    //: Result:='';
    //: Result:='';
    //: Result:='';
    //: Result:='';
    //: Result:='';

    
    
  end;
end;


function RuEn(ru, en: AnsiString): AnsiString;
begin
  Result:=en;
end;


  function PCharToString(P: PAnsiChar): AnsiString;
  var
    i: integer;
    p2: PAnsiChar;
  begin
    if not Assigned(p) then Result:=''
    else begin
      p2:=p;
      i:=0;
      While p2^ <> #0 do begin
        inc(p2);
        inc(i);
      end;
      SetLength(Result, i);
      Move(p^, Result[1], i);
    end;
  end;

  function PWideCharToWideString(P: PWideChar): WideString;
  var
    i: integer;
    p2: PWideChar;
  begin
    if not Assigned(p) then Result:=''
    else begin
      p2:=p;
      i:=0;
      While p2^ <> #0 do begin
        inc(p2);
        inc(i);
      end;
      SetLength(Result, i);
      Move(p^, Result[1], i*2);
    end;
  end;

  function VarRecToWide(V: TVarRec): WideString;
  begin
    Case V.Vtype of
      vtInteger:    Result := IntToStr(V.VInteger);
      vtBoolean:    Result := BoolChars(V.VBoolean);
      vtChar:   Result := V.VChar;
      vtWideChar:   Result:=V.VWideChar;
      vtExtended:   Result := FloatToStr(V.VExtended^);
      vtAnsiString: Result := AnsiString(V.VAnsiString);
      vtWideString: Result := WideString(V.VWideString);
      vtPChar:  Result := PCharToString(V.VPChar);
      vtPWideChar:  Result := PWideCharToWideString(V.VPWideChar);
      vtObject:     Result := V.VObject.ClassName;
      vtClass:      Result := V.VClass.ClassName;
      vtPointer: begin
        if Assigned(V.VPointer) then Result:= Format('%Ph',[V.VPointer])
                                else Result:='NIL';
      end;

      //not supported in the FreePascal 1.0.6:
      vtCurrency:   Result := CurrToStr(V.VCurrency^);
      vtVariant:    Result := string(V.VVariant^);

      vtInt64:      Result := IntToStr(V.VInt64^);
    else
      Result:='?unknown VarRec type?';
    end;
  end;
  

 function WidePos(a, u: WideString): integer;
 var
   j, i: integer;
 begin
   Result:=-1;
   For j:=1 to length(u) do begin
     i:=1;
     While (i < Length(a) + 1) and (a[i] = u[i + j - 1]) do inc(i);
     if i = (Length(a) + 1) then begin
       Result:=j;
       Exit;
     end;
   end;
 end;
 

function WideCOPY(s: WideString; pos, len: integer): WideString;
var i: integer;
begin
  Result:='';
  For i:=pos to pos + len - 1 do begin
    if i > Length(s) then Exit;
    Result:=Result + s[i];
  end;
end;


function WideReplace(u, a, b: WideString): WideString; OVERLOAD;
var p: integer;
    s: WideString;
begin
  s:=u;
  p:=WidePos(a, s);
  While p > 0 do begin
    s:=WideCOPY(s, 1, p - 1) + b + WideCOPY(s, p + Length(a), Length(s));
    p:=WidePos(a, s);
  end;
  Result:=s;
end;


  function PervertedFormat(U: WideString; P: array of const): WideString; //OVERLOAD;
  var
    j: integer;
    R, b, e: WideString;
  begin
    e:='';
    For j:=0 to High(p) do begin
      b:=VarRecToWide(P[j]);
      if WidePos('%' + IntToStr(j), U) < 1
        then e:=e + '  [' + b + ']  '
        else u:=WideReplace(u, '%' + IntToStr(j), b);
    end;
    if e <> '' then begin
      e:=' +FORMAT ERROR!! ' + e;
    end;
    Result:=u + e;
  end;
  
  function MsgFormat(M: TMessageId; Param: array of const): WideString;
  begin
    Result:=PervertedFormat(MsgRaw(M), param);
  end;



  Procedure Die(YellID :TMessageID; Param: array of const);
  begin
    AddLog(YellID, Param);
    Raise Exception.Create(MsgFormat(YellID, Param));
  end;

  Procedure Die(u: WideString; Param: array of const);
  begin
    AddLog(u, Param);
    Raise Exception.Create(PervertedFormat(u, Param));
  end;


  Procedure Die(YellID :TMessageID);
  begin
    Die(YellId, []);
  end;


  Procedure Die(u: WideString);
  begin
    Die(u, []);
  end;


  Procedure AddLog(U: WideString; Param: array of const);
  begin
    WriteLn(PervertedFormat(u, Param));
  end;

  Procedure AddLog(mID: TMessageID; Param: array of const);
  begin
    WriteLn(MsgFormat(mID, Param));
  end;

  Procedure AddLog(mID: TMessageID);
  begin
    AddLog(mID, []);
  end;


  Procedure AddLog(U: WideString);
  begin
    AddLog(U, []);
  end;
  
  procedure AddLogOk;
  begin
    AddLog('Ok.');
  end;

