{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the type and field registration routines.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

type TestEnum = (ff_guu, ff_gaa);

  procedure ClassesRegistrationStart;//constructor Create;
  begin
    if VerboseLog  then AddLog('Classes registration start');
    Fields:= TFieldInfos.Create;
    SaveableFields:= TFieldInfos.Create;
    Classes:= TAOI.Create;
    NameSpace:=TNameSpace.Create;
    // Delphi/FPC compatibility:
    NameSpace.Add('LONGINT', 'INTEGER');
    NameSpace.Add('LONGWORD', 'CARDINAL');
    NameSpace.Add('ANSISTRING', 'STRING');

    TypeNameSpace:=TNameSpace.Create;
    ClassNameSpace:=TNameSpace.Create;
    Types:=TTypeRegistry.Create;
    Enums:=T2DAOI.Create;
    CurrentObject:= TArrayOfTrulyPersistent.Create;
    CurrentObjectInd:= TAOI.Create;

    InitializeVmtxxxConsts;
    
      //since the class field containing the index is in fact
      //  a virtual method pointer, it does initially contain
      //  some value - so we need to store it for future reference,
      //  to discern non-registered classes from registered ones.
      //we don't need to worry about it matching with a real class index,
      //  because this value will be very big (positive or negative),
      //  out of any reasonable scope of class indices.
    InvalidClassIndex:=TTrulyPersistent.ClassIndex();
    if VerboseLog then AddLog('  InvalidClassIndex =%0', [InvalidClassIndex]);

  {$ifdef fpc}
    RegType(TypeInfo(pointer));
  //  RegType(TypeInfo(TDwordArray), @RP_ArrayOfDWORD);
  {$else}
   //E2134 Type 'Pointer' has no type info
    RegType(PTypeInfo(nil));
  // E2134 Type 'TDwordArray' has no type info
  //  RegType(nil, @RP_ArrayOfDWORD);
  {$endif}
    RegType(TypeInfo(byte), SizeOf(byte));
    RegType(TypeInfo(shortint), SizeOf(shortint));
    RegType(TypeInfo(word), SizeOf(word));
    RegType(TypeInfo(smallint), SizeOf(smallint));
    RegType(TypeInfo(dword), sizeof(dword));
    RegType(TypeInfo(integer), sizeof(integer));
    RegType(TypeInfo(int64), SizeOf(int64));

    RegType(TypeInfo(float));//single, a.k.a glFloat.
    RegType(TypeInfo(double), SizeOf(double));
    RegType(TypeInfo(extended), SizeOf(extended));
    RegType(TypeInfo(comp), SizeOf(comp));

    {$ifdef fpc}
      RegType(TypeInfo(boolean), SizeOf(boolean));
    {$else}
      RegType(TypeInfo(boolean), @RP_LONGBOOL);
    {$endif}

    RegType(TypeInfo(T2DArrayOfDword), @RP_2dArrayOfDword);
    RegType(TypeInfo(AnsiString), @RP_AnsiString);
    RegType(TypeInfo(WideString), @RP_WideString);

    RegType(TypeInfo(TAOI), @RP_TAOI);
    RegType(TypeInfo(T2DAOI), @RP_T2DAOI);
    RegType(TypeInfo(TAOC), @RP_TAOC);
    RegType(TypeInfo(T2DAOC), @RP_T2DAOC);
    RegType(TypeInfo(TAOF), @RP_TAOF);
    RegType(TypeInfo(T2DAOF), @RP_T2DAOF);
    RegType(TypeInfo(TAOS), @RP_TAOS);
    RegType(TypeInfo(T2DAOS), @RP_T2DAOS);
    RegType(TypeInfo(TAOW), @RP_TAOW);
    RegType(TypeInfo(T2DAOW), @RP_T2DAOW);
{    RegType(TypeInfo(T), @RP_T);
    RegType(TypeInfo(T2D), @RP_T2D);}
    RegType(TypeInfo(TArrayOfDyna), @RP_TArrayOfDyna);
    RegType(TypeInfo(TArrayOfTrulyPersistent), @RP_TArrayOfTrulyPersistent);

    RegClass(TTrulyPersistentTester); //since the zero index should never be
                                      //used for real, we need to "stub" it
                                      //                       with something.
  end;

 var
   FakeTypeInfoForPointer: TTypeInfo = ( Kind: tkUnknown; Name: 'POINTER');
    type
      TArrayOf1000Pointers = packed Array[0..1000] of pointer;
      PArrayOf1000Pointers = ^TArrayOf1000Pointers;

    function FindOffset(K: TTrulyPersistent; s: string): integer;
    var
      p: PArrayOf1000Pointers;
      p2: pointer;
      i: integer;
    begin
      p:=pointer(Cardinal(K.ClassType) );//- vmtSelfPtr);
      p2:=K.MethodAddress(s);
      For i:=0 to 1000 do
        if p^[i] = p2 then begin
          Result:=i * SizeOf(pointer);
          if VerboseLog then AddLog('  %0 : VMT + %1',[s, Result]);
          Exit;
        end;
      Die('Unable to place the custom fields in the class VMT!')
    end;

    procedure InitializeVmtxxxConsts;
    var
      K: TTrulyPersistent;
    begin
      K:=TTrulyPersistent.Generate;
      vmtMyClassIndex:= FindOffset(K, '_MyClassIndex');
      vmtMyScenarioIndex:= FindOffset(K, '_MyScenarioIndex');
      vmtMyFieldsList:= FindOffset(K, '_MyFieldsList');
      vmtMyLocalFieldsList:= FindOffset(K, '_MyLocalFieldsList');
      vmtMyLocalClassIndex:= FindOffset(K, '_MyLOcalClassIndex');
      K.TechnicalDestroy;
    end;


  function ClassIndex(C: TClass): integer;
  var i: integer;
  begin
    Result:= -1;
    For i:=0 to Classes.High do
      if Types[Classes[i]]._class = C then begin
        Result:=i;
        Break;
      end;
  end;

  procedure DieTypeFailed(T: TTypeRecord; reason: string);
  begin
    Die(MI_ERROR_PROGRAMMER_NO_BAKA,
      ['Type "' + NameSpace[T.name] + '" of kind "'
       + GetEnumName(TypeInfo(TTypeKind), ord(T.Info^.Kind))
       + '" failed its registration.'#10#13 + reason]);
  end;


{   This bunny registers binary types (i.e. ones that could be
      dumped into a stream directly, without caring about their structure).
      ...I wish TypeInfo or TypeData structures had a size field
      so that pointing it manually would be unnecessary. Dreams, dreams... :(  }
  procedure RegType(Info: PTypeInfo; Size: Integer);  overload;
  var
    T: TTypeRecord;
    var tn: string;
  begin
    T.size:=Size;
    T.Info:=Info;
    T.Data:=GetTypeData(T.Info);

    tn:=UpperCase(AnsiString(Info^.Name));

    if TypeNameSpace.Ind(tn) >=0 then begin
      //T.name:=NameSpace.Ind(Info^.Name); //needed for the error message
      if VerboseLog then AddLog('HINT: Type "%0" is alraedy registered! (index %1)', [tn, NameSpace.Ind(tn)]);
      EXIT;
    end;
    T.name:=NameSpace.Add(tn);
    TypeNameSpace.Add(tn);
    T.proc:=nil;
    case Info^.Kind of
      tkFloat: begin
          T.Kind:=fk_Float;
          //One of the reasons why float and integer aren't just marked
          //  as binary fields is a chance (like that of a snow flake
          //  in hell) that the support of 64-bit platforms will be added,
          //  where (maybe?) the glUint and glFloat will be not the
          //  DWord and Single, but QWord and Double, respectively,
          //  and we'll have to convert them "on the fly" while reading
          //  from the basket.
        end;
      tkInteger, tkInt64{$ifdef fpc}, tkQWord{$endif}: begin
          T.Kind:=fk_Integer;
        end;
      //Delphi: Record types do not generate type information
      tkRecord{, tkArray}:
        //T.Kind:=fk_binary;
        DieTypeFailed(T, RuEn(
          '  .'#10#13
         +' #1:   Delphi,      RTTI.'#10#13
         +' #2:        64-bit/little-endian  -  .   - " ",      , ,    .'#10#13
         ,'Record types are prohibited.'#10#13
         +'Reason #1: compiler compatibility. Delphi doesn''t support RTTI for them.'#10#13
         +'Reason #2: better flexibility and possibility of support 64-bit/little-endian somewhere in the future. Records are a black boxes dependent on field sizes, alignments, and other fickle matter.'
         ))
    else
      DieTypeFailed(T, 'Wrong version of RegType() was called for this type.')
    end;
    Types.Add(T);
    if VerboseLog then AddLog('  New type: %0 (%1 / %2)'
      ,[NameSpace[T.name], T.size, GetEnumName(TypeInfo(TFieldKind), ord(T.Kind))]);
  end;

{   This bunny registers array types.
      Since the lack of RTTI it goes via string IDs.}
  procedure RegType(StringID: ansistring; Info: PTypeInfo; Size: Integer);  overload;
  var
    T: TTypeRecord;
    i: integer;

  begin
    StringID:=UpperCase(StringID);
    if TypeNameSpace.Ind(StringID) >=0 then begin
      //T.name:=NameSpace.Ind(Info^.Name); //needed for the error message
      if VerboseLog then AddLog('HINT: Type "%0" is alraedy registered! (index %1)', [stringId, NameSpace.Ind(Info^.Name)]);
      EXIT;
    end;
    i:=TypeNameSpace.Ind(AnsiString(Info^.Name));
    if i < 0 then
      DieTypeFailed(T, 'The base type '+Info^.Name+' is not registered.');

    T.BaseTypeInd:= i;
    T.size:=Size;
    if (Size mod Types[i].Size) <> 0 then
      DieTypeFailed(T, format(
        'Size/alignment mismatch. Size=%d, ElementSize(%s)=%d',
        [Size, AnsiString(Info^.Name), Types[i].Size]));
    T.Length:= Size div Types[i].Size;
    T.Info:=New(PTypeInfo);
    T.Info^.Kind:=tkArray;
    T.Info^.Name:=StringID;
    T.Data:=nil;

    T.name:=NameSpace.Add(StringId);
    TypeNameSpace.Add(StringId);
    T.proc:=nil;
    T.Kind:=fk_binary;

    Types.Add(T);
    if VerboseLog then AddLog('  New type: %0 (%1 / %2)'
      ,[NameSpace[T.name], T.size, GetEnumName(TypeInfo(TFieldKind), ord(T.Kind))]);
  end;

{   This bunny acts the same as the one above, with two following exceptions:
      A). It assumes type size is equal to pointer size (4 bytes), and
      B). It could be used to register enumeration types which need
          a special approach (saved as DWORDs, loaded either as
          DWORDs or via special converting routine - depending on the
          parsing results).
        (Do NOT forget to use the $MINENUMSIZE 4 compiler directive!)}
  procedure RegType(Info: PTypeInfo);  overload;
  var
    T: TTypeRecord;
  begin
    T.size:=4;
    {$ifndef fpc}
    if not Assigned(Info) then begin
      T.Info:=@FakeTypeInfoForPointer;
      T.Data:=nil;
    end
    else
    {$endif}
    begin
      T.Info:=Info;
      T.Data:=GetTypeData(T.Info);
    end;
    T.Proc:=nil;
    if TypeNameSpace.Ind(String(T.Info^.Name)) >=0 then begin
      //T.name:=NameSpace.Ind(Info^.Name); //needed for the error message
      if VerboseLog then AddLog('HINT: Type "%0" is alraedy registered! (index %1)', [string(Info^.Name), NameSpace.Ind(Info^.Name)]);
      EXIT;
    end;
    T.name:=NameSpace.Add(AnsiString(T.Info^.Name));
    TypeNameSpace.Add(AnsiString(T.Info^.Name));

    case T.Info^.Kind of
      tkFloat: begin
        if T.Data.FloatType = ftSingle then begin
          T.Kind:=fk_Float;
        end
        else
          DieTypeFailed(T, 'Wrong version of RegType() was called for this type.');
      end;
      tkEnumeration: begin
        T.Kind:=fk_Enum;
        T.Proc:=@RP_Enum;
        Enums.Length:=Types.Length + 1;
        _RegEnum(T);
      end;
    else
      if (UpperCase(T.Info^.Name) = 'POINTER') and (Types.Length = 0)
        then T.Kind:=fk_notsupported
        else DieTypeFailed(T, 'Wrong version of RegType() was called for this type.')
    end;
    Types.Add(T);
    if VerboseLog then AddLog('  New type: %0 (%1 / %2)'
      ,[NameSpace[T.name], T.size, GetEnumName(TypeInfo(TFieldKind), ord(T.Kind))]);
  end;


{   This bunny allows to deal with complex types like strings,
      dynamic arrays - even non-persistent objects! - by introducing
      a custom processing procedure (see template in mo_typeprocs.inc).
    Its only limitation is that it assumes base type to be a pointer,
      so field size is always pointer-sized (4 bytes on 32-bit platform).}
  procedure RegType(Info: PTypeInfo; Proc: TCustomTypeProcessingProc);
  var
    T: TTypeRecord;
  begin
    T.size:=4;
    T.Info:=Info;
    T.Data:=GetTypeData(T.Info);
    if TypeNameSpace.Ind(Info^.Name) >=0 then begin
      //T.name:=NameSpace.Ind(Info^.Name); //needed for the error message
      if VerboseLog then AddLog('HINT: Type "%0" is alraedy registered! (index %1)', [string(Info^.Name), NameSpace.Ind(Info^.Name)]);
      EXIT;
    end;
    T.name:=NameSpace.Add(AnsiString(Info^.Name));
    TypeNameSpace.Add(AnsiString(Info^.Name));
    T.proc:=Proc;
    case Info^.Kind of
      TkClass: begin
        //FUCK. I have no other words to describe it.
        //Why does the fucking InheritsFrom() ALWAYS RETURN FALSE?!!!
        T.Kind:=fk_CustomClass;
      end;
      tkWString:
        T.Kind:=fk_String;
      {$ifdef fpc}tkAString{$else}tkLstring{$endif}:
        T.Kind:=fk_8bit_string;
      tkArray, tkDynArray:
        T.Kind:=fk_Array;
    else
      if UpperCase(T.Info^.Name) = 'LONGBOOL'
        then T.Kind:=fk_integer
      else
        DieTypeFailed(T, 'Wrong version of RegType() was called for this type.')
    end;
    Types.Add(T);
    if VerboseLog then AddLog('  New type: %0 (%1 / %2)'
      ,[NameSpace[T.name], GetEnumName(TypeInfo(TFieldKind), ord(T.Kind)), @T.Proc]);
  end;


{procedure RegType(C: CDyna; Proc: TCustomTypeProcessingProc);
var
  T: TTypeRecord;
begin
  T.size:=Sizeof(pointer);
  New(T.Info);
  T.Info^.Name:=C.ClassName;
  T.Info^.Kind:=tkClass;
  T.Data:=GetTypeData(T.Info);
  if NameSpace.Ind(T.Info^.Name) >=0 then begin
    //T.name:=NameSpace.Ind(Info^.Name); //needed for the error message
    if VerboseLog then AddLog('HINT: Type "%0" is alraedy registered! (index %1)', [string(T.Info^.Name), NameSpace.Ind(T.Info^.Name)]);
    EXIT;
  end;
  T.name:=NameSpace.Add(AnsiString(T.Info^.Name));
  TypeNameSpace.Add(AnsiString(T.Info^.Name));
  T.proc:=@RP_Dyna;
  T.Kind:=fk_Dyna;
  Types.Add(T);
  if VerboseLog then AddLog('  Registered type: %0 (size=%1, field kind=%2, proc=%3)'
    ,[NameSpace[T.name], T.size, GetEnumName(TypeInfo(TFieldKind), ord(T.Kind)), @T.Proc]);
end;
}

procedure RegType(C: CTrulyPersistent);
var
  T: TTypeRecord;
begin
  T.size:=Sizeof(pointer);
  New(T.Info);
  T.Info^.Name:=C.ClassName;
  T.Info^.Kind:=tkClass;
  T.Data:=GetTypeData(T.Info);
  if TypeNameSpace.Ind(T.Info^.Name) >=0 then begin
    //T.name:=NameSpace.Ind(Info^.Name); //needed for the error message
    if VerboseLog then AddLog('HINT: Type "%0" is alraedy registered! (index %1)', [string(T.Info^.Name), NameSpace.Ind(T.Info^.Name)]);
    EXIT;
  end;
  T.name:=NameSpace.Add(AnsiString(T.Info^.Name));
  TypeNameSpace.Add(AnsiString(T.Info^.Name));
  T.proc:=RP_Persistent;
  T.Kind:=fk_Class;
  T._class:=C;
  T.ClassName:=ClassNameSpace.Add(AnsiString(C.ClassName));
  Types.Add(T);
  if VerboseLog then AddLog('  New type: %0 (%1 / %2 / %3)'
    ,[NameSpace[T.name], T.size, GetEnumName(TypeInfo(TFieldKind), ord(T.Kind)), @T.Proc]);
end;

var
  FieldsRegistrationInProgress: boolean = No;

procedure ResetPrevRec;
var
  pi: PTypeInfo;
begin
  {$ifdef fpc}
  prevOffset:=@(CurrentObject.Last._BasketIndex) - pointer(CurrentObject.Last);
  {$else}
  prevOffset:=cardinal(@(CurrentObject.Last._BasketIndex)) - cardinal(CurrentObject.Last);
  {$endif}
  prevSize:=SizeOf(CurrentObject.Last._BasketIndex);
  prevName:=NameSpace.Add('_BasketIndex');
  pi:=TypeInfo(integer);
  prevType:=NameSpace.Add(pi^.Name);
end;

procedure RegBegin(C: TObject);
var
  i: integer;
begin
  if VerboseLog then AddLog('Class registration start: %0',[AnsiString(C.ClassName)]);
  if FieldsRegistrationInProgress then Die(MI_ERROR_PROGRAMMER_NO_BAKA, [RuEn(
    '  RegisterFields()     !',
    'Classes in RegisterFields() should be registered BEFORE all the fields!')]);
  if ClassIndex(C.ClassType) >= 0
    then Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['Class ' + C.ClassName + ' is already registered!']);
  CurrentObject.Add (C as TTrulyPersistent);
  Classes.Add(TypeNameSpace.Ind(C.ClassName));
  Fields.Increment;
  SaveableFields.Increment;
  CurrentObjectInd.Add(Fields.High);
  CurrentObject.Last._RegisterMyIndex(Classes.High);
  ResetPrevRec;
end;


procedure RegEnd;
begin
 //,   ""   
 if CurrentObject.Last.InstanceSize > NFA_A(prevOffset, prevSize, 0)
  then
    Die (MI_ERROR_PROGRAMMER_NO_BAKA,
      ['Class '+CurrentObject.Last.ClassName + ' failed its registration.'#10#13
     + '  "' + NameSpace[prevName] + '": offset=' + IntToStr(prevOffset)
     + ', size=' + IntToStr(prevSize)+', type=' + NameSpace[prevType] + #10#13
     + '  Alignment=' + IntToStr(AlignGranularity) +#10#13
     + '  InstanceSize=' + IntToStr(CurrentObject.Last.InstanceSize) +#10#13
     + '  No man''s bytes at the end='
     + IntToStr(CurrentObject.Last.InstanceSize - NFA_A(prevOffset, prevSize, 0))
      ]);
  if Fields[CurrentObjectInd.Last].Length = 0
    then
      Die (MI_ERROR_PROGRAMMER_NO_BAKA,
        ['Class '+CurrentObject.Last.ClassName + ' failed its registration.'#10#13
       + '  It hasn''t registered any fields!']);
  CurrentObject.Last._SetMyFieldsList(Fields[CurrentObjectInd.Last]);
  if VerboseLog then AddLog('Class registration end: %0',[AnsiString(CurrentObject.Last.ClassName)]);
  CurrentObject.Decrement;
  CurrentObjectInd.Decrement;
  FieldsRegistrationInProgress:=No;
  
  if CurrentObject.Length > 0 then ResetPrevRec; //added support for nested registration.
end;

procedure RegClass(C: CTrulyPersistent);
var
  R: TTrulyPersistent;
begin
  RegType(C);
  R:=C.Register();   //constructor call
  R.TechnicalDestroy;
end;

procedure __RegisterField(name: string; Pf: pointer; tnu: integer; SkipIt: boolean);
var
  i, a, b: integer;
  f: TFieldInfo;
  PI: PTypeInfo;
begin
  FieldsRegistrationInProgress:=Yes;
  a:=NameSpace.ind(TypeNameSpace[tnu]);
  PI:=Types[tnu].Info;
  For i:=0 to Types.High do
    if a = Types[i].Name then begin
      b:=i;
      Break;
    end;
  f.Tind:=b;
  f.name:=NameSpace.Add(name);
  {$ifdef fpc}
  f.offset:=Pf - pointer(CurrentObject.Last);
  {$else}
  f.offset:=cardinal(Pf) - cardinal(CurrentObject.Last);
  {$endif}
  if Assigned(Types[f.Tind].Proc) 
    then f.haspp:=1 
    else f.haspp:=0;
  if (f.offset <> NFA_A(prevOffset, prevSize, Types[f.Tind].size))
    then Die (MI_ERROR_PROGRAMMER_NO_BAKA,
      ['Class '+CurrentObject.Last.ClassName + ' failed its registration.'#10#13
     + '  "' + NameSpace[prevName] + '": offset=' + IntToStr(prevOffset)
     + ', size=' + IntToStr(prevSize)+', type=' + NameSpace[prevType] + #10#13
     + '  "' + NameSpace[f.name] + '": offset=' + IntToStr(f.offset)
     + ', size=' + IntToStr(Types[f.Tind].size)+', type=' + Types[f.Tind].Info^.Name + #10#13
     + '  Alignment=' + IntToStr(AG_A(Types[f.Tind].size)) +#10#13
     + '  InstanceSize=' + IntToStr(CurrentObject.Last.InstanceSize) +#10#13
     + '  Gap=' + IntToStr(f.offset - (NFA_A(prevOffset, prevSize, Types[f.Tind].size)))
      ]);
  prevOffset:=f.offset;
  prevName:=f.name;
  prevSize:=Types[f.Tind].size;
  prevType:=NameSpace.Ind(Types[f.Tind].Info^.Name);
  if (Types[f.Tind].Info^.Kind = tkClass) then begin
    if Types[f.Tind].Kind = fk_Class //._class.InheritsFrom(TTrulyPersistent)
     // or Types[f.Tind]._class.InheritsFrom(TDyna)
      then SaveableFields[CurrentObjectInd.Last].Add(f);(*
      else Die (MI_ERROR_PROGRAMMER_NO_BAKA,
         ['Class '+CurrentObject.Last.ClassName + ' failed its registration.'#10#13
           + '  Field "' + NameSpace[prevName] + '" is object of improper type "'
           + NameSpace[Types[f.Tind].Name] +'".'#10#13
           + '  Pointers and unsupported classes must be skipped via RegSkipPtr()']);*)
    if SkipIt then Die (MI_ERROR_PROGRAMMER_NO_BAKA,
         ['Class '+CurrentObject.Last.ClassName + ' failed its registration.'#10#13
           + '  Attempt to skip the field "' + NameSpace[prevName] + '".'#10#13
           + '  Saveable object fields cannot be skipped!']);
    f.Skip:=No;
    Fields[CurrentObjectInd.Last].Add(f);
    if VerboseLog then AddLog('  field "%0": %1 / %2.',
      [NameSpace[f.name],f.offset, NameSpace[Types[f.Tind].Name]]);
  end
  else begin
    if (f.Tind = 0) and not SkipIt
      then Die (MI_ERROR_PROGRAMMER_NO_BAKA,
        ['Class '+CurrentObject.Last.ClassName + ' failed its registration.'#10#13
        + '  Field "' + NameSpace[prevName] + '" is a pointer.'#10#13
        + '  Pointers and unsupported classes must be skipped via RegSkipPtr()']);
    f.skip:=SkipIt;
    Fields[CurrentObjectInd.Last].Add(f);
    if VerboseLog then
      if SkipIt then
        AddLog('  field "%0": %1 / %2 / %3, skipped.',
          [NameSpace[f.name],f.offset,Types[f.Tind].size, NameSpace[Types[f.Tind].Name]])
      else
        AddLog('  field "%0": %1 / %2 / %3.',
          [NameSpace[f.name],f.offset,Types[f.Tind].size, NameSpace[Types[f.Tind].Name]]);
  end;
end;

procedure _RegisterField(name: string; Pf: pointer; PI: PTypeInfo; SkipIt: boolean);
var i: integer;
begin
  i:=TypeNameSpace.Ind(PI^.Name);
  if i < 0 then Die(MI_ERROR_PROGRAMMER_NO_BAKA,
     ['Unknown type "' + UpperCase(PI^.Name)+'", not present in the registry!"']);

  __RegisterField(name, Pf, i, SkipIt);
end;

procedure _RegEnum(T: TTypeRecord);
var
  i, m, n: integer;
begin
  if T.Data^.MinValue <> 0 then DieTypeFailed(T, 'MinValue <> 0. Please note that the mechanism for storing enumerated types was NOT meant for the SUBRANGE types.');
  m:=T.Data^.MaxValue;
  if m > 1000 then DieTypeFailed(T, 'MaxValue > 1000. Please note that the mechanism for storing enumerated types was NOT meant for the SUBRANGE types.');
  Enums.Last.Length:=m + 1;
  For i:=0 to m do
    Enums.Last[i]:=NameSpace.Add(GetEnumName(T.Info, i));
end;

procedure RegField(name: string; Pf: pointer; TypeString: string); overload;
var i: integer;
begin
  i:=TypeNameSpace.Ind(UpperCase(TypeString));
  if i < 0 then Die(MI_ERROR_PROGRAMMER_NO_BAKA,
     ['Unknown type "' + UpperCase(TypeString)+'", not present in the registry!"']);

  __RegisterField(name, pf, i, No);
end;

procedure RegField(name: string; Pf: pointer; PI: PTypeInfo); overload;
begin
  _RegisterField(name, pf, PI, No);
end;


procedure RegSkip(name: string; Pf: pointer; TypeString: string); overload;
var i: integer;
begin
  i:=TypeNameSpace.Ind(UpperCase(TypeString));
  if i < 0 then Die(MI_ERROR_PROGRAMMER_NO_BAKA,
     ['Unknown type "' + UpperCase(TypeString)+'", not present in the registry!"']);

  __RegisterField(name, pf, i, Yes);
end;

procedure RegSkip(name: string; Pf: pointer; PI: PTypeInfo); overload;
var
  f: TFieldInfo;
begin
  _RegisterField(name, pf, PI, Yes);
end;

procedure RegSkipPtr(name: string; Pf: pointer);
var
  f: TFieldInfo;
begin
  FieldsRegistrationInProgress:=Yes;
  _RegisterField(name, pf,
    {$ifdef fpc}
    TypeInfo(pointer)
    {$else}
    @FakeTypeInfoForPointer
    {$endif}
    , Yes);
end;
