{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the picture processing classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

unit mo_pictures;

interface
  uses un_typedefs, mo_hub;


type
  TImage = class
  protected
    f_Data: pointer;
    f_Width, f_Height: integer;
    f_format: TImageMode;
  public
    property Data: pointer read f_Data;
    property Width: integer read f_Width;
    property Height: integer read f_Height;
    property format: TImageMode read f_format;
    function Red(x,y: integer): integer;
    function Green(x,y: integer): integer;
    function Blue(x,y: integer): integer;
    function Alpha(x,y: integer): integer;
    procedure ConvertToGray;
    constructor CreateFromFile(FileName: AnsiString);
    constructor Create(w, h: integer; f: TImageMode);
    destructor Destroy;
  end;
  

implementation

  function TImage.Red(x,y: integer): integer;
  begin
    Case f_format of
      Im_RGB: Result:=Byte(pointer(cardinal(f_data) + (f_width * y + x) * 3)^);
      Im_Gray: Result:=Byte(pointer(cardinal(f_data) + f_width * y + x)^);
      Im_RGBA: Result:=Byte(pointer(cardinal(f_data) + (f_width * y + x) * 4)^);
    end;
  end;

  function TImage.Green(x,y: integer): integer;
  begin
    Case f_format of
      Im_RGB: Result:=Byte(pointer(cardinal(f_data) + (f_width * y + x) * 3 + 1)^);
      Im_Gray: Result:=Byte(pointer(cardinal(f_data) + f_width * y + x)^);
      Im_RGBA: Result:=Byte(pointer(cardinal(f_data) + (f_width * y + x) * 4 + 1)^);
    end;
  end;

  function TImage.Blue(x,y: integer): integer;
  begin
    Case f_format of
      Im_RGB: Result:=Byte(pointer(cardinal(f_data) + (f_width * y + x) * 3 + 2)^);
      Im_Gray: Result:=Byte(pointer(cardinal(f_data) + f_width * y + x)^);
      Im_RGBA: Result:=Byte(pointer(cardinal(f_data) + (f_width * y + x) * 4 + 2)^);
    end;
  end;

  function TImage.Alpha(x,y: integer): integer;
  begin
    Case f_format of
      Im_RGB, Im_Gray: Result:=255;
      Im_RGBA: Result:=Byte(pointer(cardinal(f_data) + (f_width * y + x) * 4 + 3)^);
    end;
  end;
  
  constructor TImage.CreateFromFile(FileName: AnsiString);
  var
    stub: integer;
  begin
    if FileName[1] <> '$' then begin
      CreateContainerFromFile('$ct', PChar(FileName), stub);
      PrepareToDecodePic ('$ct', f_width, f_height, f_format);
    end
    else
      PrepareToDecodePic (PChar(FileName), f_width, f_height, f_format);
    GetMem(f_data, f_width * f_height * ImgModeBpp[f_format]);
    DecodePic(f_data);
    if FileName[1] <> '$'
      then DeleteContainer('$ct');
  end;

  constructor TImage.Create(w, h: integer; f: TImageMode);
  begin
    GetMem(f_data, w* h * ImgModeBpp[f]);
    f_format:= f;
    f_width:= w;
    f_height:= h;
  end;
  
  procedure TImage.ConvertToGray;
  var
    i: integer;
    p: pointer;
  begin
    case f_format of
      Im_Gray: Exit;
      Im_RGB: begin
        GetMem (p, f_Width * f_Height);
        For i:=0 to f_Width * f_Height - 1 do
          byte(pointer(cardinal(p) + i)^):=Round(byte(pointer(cardinal(f_data) + i * 3)^) * 0.3 + byte(pointer(cardinal(f_data) + i * 3 + 1)^) * 0.5 + byte(pointer(cardinal(f_data) + i * 3 + 2)^) * 0.2);
        FreeMem(f_Data);
        f_Data:=p;
      end;
      Im_RGBA: begin
        GetMem (p, f_Width * f_Height);
        For i:=0 to f_Width * f_Height - 1 do
          byte(pointer(cardinal(p) + i)^):=Round(byte(pointer(cardinal(f_data) + i * 4)^) * 0.3 + byte(pointer(cardinal(f_data) + i * 4 + 1)^) * 0.5 + byte(pointer(cardinal(f_data) + i * 4 + 2)^) * 0.2);
        FreeMem(f_Data);
        f_Data:=p;
      end;

    end;
  end;

  destructor TImage.Destroy;
  begin
    FreeMem(f_data);
  end;



end.
