{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the mipmap building code, assembly language version.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


Const TrTable: packed array[0..511] of DWORD = (
$3FFF3FFF, $3FFF3FFF, $3FC03FC0, $3FC03FC0, $1FE01FE0, $1FE01FE0, $15401540, $15401540, $0FF00FF0, $0FF00FF0, $0CC00CC0, $0CC00CC0, $0AA00AA0, $0AA00AA0, $091B091B, $091B091B,
$07F807F8, $07F807F8, $07150715, $07150715, $06600660, $06600660, $05CC05CC, $05CC05CC, $05500550, $05500550, $04E704E7, $04E704E7, $048E048E, $048E048E, $04400440, $04400440,
$03FC03FC, $03FC03FC, $03C003C0, $03C003C0, $038B038B, $038B038B, $035B035B, $035B035B, $03300330, $03300330, $03090309, $03090309, $02E602E6, $02E602E6, $02C602C6, $02C602C6,
$02A802A8, $02A802A8, $028D028D, $028D028D, $02740274, $02740274, $025C025C, $025C025C, $02470247, $02470247, $02330233, $02330233, $02200220, $02200220, $020E020E, $020E020E,
$01FE01FE, $01FE01FE, $01EF01EF, $01EF01EF, $01E001E0, $01E001E0, $01D201D2, $01D201D2, $01C501C5, $01C501C5, $01B901B9, $01B901B9, $01AD01AD, $01AD01AD, $01A201A2, $01A201A2,
$01980198, $01980198, $018E018E, $018E018E, $01850185, $01850185, $017C017C, $017C017C, $01730173, $01730173, $016B016B, $016B016B, $01630163, $01630163, $015B015B, $015B015B,
$01540154, $01540154, $014D014D, $014D014D, $01460146, $01460146, $01400140, $01400140, $013A013A, $013A013A, $01340134, $01340134, $012E012E, $012E012E, $01290129, $01290129,
$01230123, $01230123, $011E011E, $011E011E, $01190119, $01190119, $01150115, $01150115, $01100110, $01100110, $010C010C, $010C010C, $01070107, $01070107, $01030103, $01030103,
$00FF00FF, $00FF00FF, $00FB00FB, $00FB00FB, $00F700F7, $00F700F7, $00F400F4, $00F400F4, $00F000F0, $00F000F0, $00ED00ED, $00ED00ED, $00E900E9, $00E900E9, $00E600E6, $00E600E6,
$00E300E3, $00E300E3, $00E000E0, $00E000E0, $00DD00DD, $00DD00DD, $00DA00DA, $00DA00DA, $00D700D7, $00D700D7, $00D400D4, $00D400D4, $00D100D1, $00D100D1, $00CF00CF, $00CF00CF,
$00CC00CC, $00CC00CC, $00C900C9, $00C900C9, $00C700C7, $00C700C7, $00C500C5, $00C500C5, $00C200C2, $00C200C2, $00C000C0, $00C000C0, $00BE00BE, $00BE00BE, $00BC00BC, $00BC00BC,
$00B900B9, $00B900B9, $00B700B7, $00B700B7, $00B500B5, $00B500B5, $00B300B3, $00B300B3, $00B100B1, $00B100B1, $00AF00AF, $00AF00AF, $00AE00AE, $00AE00AE, $00AC00AC, $00AC00AC,
$00AA00AA, $00AA00AA, $00A800A8, $00A800A8, $00A700A7, $00A700A7, $00A500A5, $00A500A5, $00A300A3, $00A300A3, $00A200A2, $00A200A2, $00A000A0, $00A000A0, $009E009E, $009E009E,
$009D009D, $009D009D, $009B009B, $009B009B, $009A009A, $009A009A, $00990099, $00990099, $00970097, $00970097, $00960096, $00960096, $00940094, $00940094, $00930093, $00930093,
$00920092, $00920092, $00900090, $00900090, $008F008F, $008F008F, $008E008E, $008E008E, $008D008D, $008D008D, $008B008B, $008B008B, $008A008A, $008A008A, $00890089, $00890089,
$00880088, $00880088, $00870087, $00870087, $00860086, $00860086, $00850085, $00850085, $00840084, $00840084, $00830083, $00830083, $00820082, $00820082, $00810081, $00810081,
$00800080, $00800080, $007F007F, $007F007F, $007E007E, $007E007E, $007D007D, $007D007D, $007C007C, $007C007C, $007B007B, $007B007B, $007A007A, $007A007A, $00790079, $00790079,
$00780078, $00780078, $00770077, $00770077, $00760076, $00760076, $00750075, $00750075, $00750075, $00750075, $00740074, $00740074, $00730073, $00730073, $00720072, $00720072,
$00710071, $00710071, $00710071, $00710071, $00700070, $00700070, $006F006F, $006F006F, $006E006E, $006E006E, $006E006E, $006E006E, $006D006D, $006D006D, $006C006C, $006C006C,
$006B006B, $006B006B, $006B006B, $006B006B, $006A006A, $006A006A, $00690069, $00690069, $00690069, $00690069, $00680068, $00680068, $00670067, $00670067, $00670067, $00670067,
$00660066, $00660066, $00650065, $00650065, $00650065, $00650065, $00640064, $00640064, $00640064, $00640064, $00630063, $00630063, $00620062, $00620062, $00620062, $00620062,
$00610061, $00610061, $00610061, $00610061, $00600060, $00600060, $005F005F, $005F005F, $005F005F, $005F005F, $005E005E, $005E005E, $005E005E, $005E005E, $005D005D, $005D005D,
$005D005D, $005D005D, $005C005C, $005C005C, $005C005C, $005C005C, $005B005B, $005B005B, $005B005B, $005B005B, $005A005A, $005A005A, $005A005A, $005A005A, $00590059, $00590059,
$00590059, $00590059, $00580058, $00580058, $00580058, $00580058, $00570057, $00570057, $00570057, $00570057, $00560056, $00560056, $00560056, $00560056, $00550055, $00550055,
$00550055, $00550055, $00550055, $00550055, $00540054, $00540054, $00540054, $00540054, $00530053, $00530053, $00530053, $00530053, $00520052, $00520052, $00520052, $00520052,
$00520052, $00520052, $00510051, $00510051, $00510051, $00510051, $00500050, $00500050, $00500050, $00500050, $00500050, $00500050, $004F004F, $004F004F, $004F004F, $004F004F,
$004E004E, $004E004E, $004E004E, $004E004E, $004E004E, $004E004E, $004D004D, $004D004D, $004D004D, $004D004D, $004D004D, $004D004D, $004C004C, $004C004C, $004C004C, $004C004C,
$004C004C, $004C004C, $004B004B, $004B004B, $004B004B, $004B004B, $004B004B, $004B004B, $004A004A, $004A004A, $004A004A, $004A004A, $004A004A, $004A004A, $00490049, $00490049,
$00490049, $00490049, $00490049, $00490049, $00480048, $00480048, $00480048, $00480048, $00480048, $00480048, $00470047, $00470047, $00470047, $00470047, $00470047, $00470047,
$00460046, $00460046, $00460046, $00460046, $00460046, $00460046, $00450045, $00450045, $00450045, $00450045, $00450045, $00450045, $00450045, $00450045, $00440044, $00440044,
$00440044, $00440044, $00440044, $00440044, $00430043, $00430043, $00430043, $00430043, $00430043, $00430043, $00430043, $00430043, $00420042, $00420042, $00420042, $00420042,
$00420042, $00420042, $00420042, $00420042, $00410041, $00410041, $00410041, $00410041, $00410041, $00410041, $00410041, $00410041, $00400040, $00400040, $00400040, $00400040);

  function Hbit(i: integer): integer;
  begin
    if i=0 then Result:=0
    else begin
      asm
        MOV EDX, [i]
        BSR ECX, EDX
        MOV [i], ECX
      end;
      Result:=i+1;
    end;
  end;


type
  P2array = ^T2array;
  T2array = packed array[0..0] of DWORD;

  procedure cgeBuildAlphaCorrectedMipmaps(Width, Height, InternalFormat: integer; Data: pointer); //an exported function!
  var
    j, x, y, mn, mw, mh, h: integer;
    M: array [0..31] of P2Array;
    d, dp, a: pointer;
  begin
    glTexImage2D(GL_TEXTURE_2D, 0, InternalFormat, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, Data);
    h:=Hbit(min(Width, Height));
    FillChar(M, Sizeof(M), 0);
    mw:=Width;
    mh:=Height;
    For j:=0 to h-1 do begin
      mw:=mw shr 1;
      mh:=mh shr 1;
      if j>0 then d:=@M[j-1, 0] else d:=Data;
      x:=mw*mh;
      if x=0 then Break;
      GetMem(M[j], x*Sizeof(DWORD));
      For y:=0 to mh-1 do begin
        a:=@M[j]^[y*mw];
        dp:=pointer(DWORD(d)+ y*mw*16);
        asm
          PUSH ESI
          PUSH EDI
          PUSH EBX
          PUSH EBP
          CLD;
          MOV EAX, [a]
          MOV EDX, [dp]
          MOV ECX, [mw]
          LEA EDI, [EDX + ECX*8]
          PXOR MM0, MM0
          MOVQ MM1, MM0
          MOVQ MM2, MM0
          MOVQ MM2, MM0
          MOV ESI, $FFFF0000
          MOVD MM7, ESI
          PSLLQ MM7, 32
          //MM7:=$FFFF000000000000
          MOV ESI, 0
          @m1:
            MOVD MM6, [ESI*8 + EDX]
            PUNPCKLBW MM0, MM6
            MOVD MM5, [ESI*8 + 4 + EDX]
            PUNPCKLBW MM1, MM5
            PMAXUB MM6, MM5
            MOVD MM5, [ESI*8 + EDI]
            PUNPCKLBW MM2, MM5
            PMAXUB MM6, MM5
            MOVD MM5, [ESI*8 + 4 + EDI]
            PUNPCKLBW MM3, MM5
            PMAXUB MM6, MM5
            PSHUFW MM4, MM0, $FF
            PSHUFW MM5, MM1, $FF
            POR MM4, MM7
            PMULHUW MM4, MM0
            POR MM5, MM7
            PMULHUW MM5, MM1
            MOVQ MM0, MM4
            PAVGW MM4, MM5
            PSHUFW MM0, MM2, $FF
            PSHUFW MM1, MM3, $FF
            POR MM0, MM7
            PMULHUW MM0, MM2
            POR MM1, MM7
            PMULHUW MM1, MM3
            PAVGW MM0, MM1
            PAVGW MM4, MM1
            MOVD EBX, MM6 //    4 
            AND EBX, $FF000000
            MOVQ MM6, MM4
            PSRLQ MM6, 56
            MOVD EBP, MM6 //    4 
            LEA EBP, [TrTable + EBP*8]
            MOVQ MM6, [EBP]
            PMULHUW MM4, MM6
            PSLLW MM4, 2
            PACKUSWB MM4, MM4
            MOVD EBP, MM4
            AND EBP, $00FFFFFF
            //  :   
            //   4 ,  RGB     
            //  ,   1
            OR EBX, EBP
            MOV [EAX + ESI*4], EBX
           INC ESI
           CMP ESI, ECX
          JB @m1;
          POP EBP
          POP EBX
          POP EDI
          POP ESI
        end;
      end;
      asm
        EMMS
      end;
      glTexImage2D(GL_TEXTURE_2D, j + 1, InternalFormat, mw, mh, 0, GL_RGBA, GL_UNSIGNED_BYTE, @M[j, 0]);
    end;
    For j:=0 to High(M) do if M[j]<>nil then FreeMem(M[j]);
  end;
