{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the GUI framework classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$include mo_globaldefs.h}

unit mo_menu;

interface
uses
  un_typedefs, mo_hub, mo_classes, mo_globopts, mo_indexer;

  Const
    align_left = 0;
    align_top = 0;
    align_right = 1;
    align_bottom = 1;
    align_center = 2;
    align_width = 3;
    align_height = 3;

type
  TControl = class (TTrulyPersistent)
  protected
    f_left, f_top, f_width, f_height, f_DiminishingFactor: integer;
  public
    procedure RegisterFields; override;

    property Left: integer read f_left;
    property Top: integer read f_top;
    property Width: integer read f_width;
    property Height: integer read f_height;
    property DiminishingFactor: integer read f_DiminishingFactor;
    
    procedure SetRect(l, t, w, h: integer); virtual;
    function AskWidth(dFactor: integer):integer; virtual;
    function AskHeight(dFactor: integer):integer; virtual;
    
    function NumChilds: integer; virtual;
    function GetChild(num: integer): TControl; virtual;
    
    constructor Create(Top, Left, width, height, halign, valign: integer); virtual;

    procedure Cycle; virtual;
    procedure Render; virtual;
    procedure OnMouseMove(mx, my: integer); virtual;
    procedure OnPress(scancode: integer); virtual;
    procedure OnRelease(scancode: integer); virtual;
  end;

  //TArrayOfTControl
(*  {$define cl_objecttype}
    {$define typeofit := TControl}
    {$define type1name := TArrayOfTControl}
      {$include mo_dyna_1template.h}
  {$undef cl_objecttype} *)

  TMenu = class (TTrulypersistent)
  protected
    HigherLevelMenu: TMenu;
    Control: TArrayOfTrulyPersistent;
    ActiveControl: integer;
  public
    constructor Create(c: TControl);
    procedure RegisterFields; override;
    procedure Cycle; virtual;
    procedure Render; virtual;
    procedure OnMouseMove(mx, my: integer); virtual;
    procedure OnPress(scancode: integer); virtual;
    procedure OnRelease(scancode: integer); virtual;
    destructor Destroy; override;
  end;
  
  
  
implementation

  uses mo_module;
  
{ ********************** TArrayOfTControl (via macros) ******** }

(*  {$define cl_objecttype}
    {$define cl_persistentobjectttype}
      {$define typeofit := TControl}
      {$define type1name := TArrayOfTControl}
      {$define type1procname := RP_TArrayOfTControl}
        {$include mo_dyna_1template.inc}
    {$undef cl_persistentobjectttype}
  {$undef cl_objecttype}*)


{ ****************************** TMenu ************************ }

  procedure TMenu.RegisterFields;
  begin
    RegField('HigherLevelMenu', @HigherLevelMenu, TypeInfo(TMenu));
    RegField('Control', @Control, TypeInfo(TArrayOfTrulyPersistent));
    RegField('ActiveControl', @ActiveControl, TypeInfo(integer));
  end;
  
  constructor TMenu.Create(c: TControl);
    procedure ListChilds(o: TControl);
    var
      i: integer;
      L: TControl;
    begin
      for i:=0 to o.NumChilds - 1 do begin
        L:=o.GetChild(i);
        Control.Add(L);
        ListChilds(L);
      end;
    end;
  begin
    inherited Create;
    Control:=TArrayofTrulyPersistent.Create;
    Control.Add(c);
    ListChilds(c);
  end;
  
  procedure TMenu.Cycle;
  var
    i: integer;
  begin
    for i:=0 to Control.High do (Control[i] as TControl).Cycle;
  end;

  procedure TMenu.Render;
  var
    i: integer;
  begin
    for i:=0 to Control.High do (Control[i] as TControl).Render;
  end;

  procedure TMenu.OnMouseMove(mx, my: integer);
  var
    i: integer;
  begin
    for i:=0 to Control.High do (Control[i] as TControl).OnMouseMove(mx, my);
  end;

  procedure TMenu.OnPress(scancode: integer);
  var
    i: integer;
  begin
    for i:=0 to Control.High do (Control[i] as TControl).OnPress(scancode);
  end;

  procedure TMenu.OnRelease(scancode: integer);
  var
    i: integer;
  begin
    for i:=0 to Control.High do (Control[i] as TControl).OnRelease(scancode);
  end;
  
  destructor TMenu.Destroy;
  begin
    if (Module.Menu = Self) and (Assigned (HigherLevelMenu))
      then Module.Menu:=HigherLevelMenu;
    inherited;
  end;
  
{*********************** TControl ****************************}

  procedure TControl.RegisterFields;
  begin
    RegField('f_left', @f_left, TypeInfo(Integer));
    RegField('f_top', @f_top, TypeInfo(Integer));
    RegField('f_width', @f_width, TypeInfo(Integer));
    RegField('f_height', @f_height, TypeInfo(Integer));
    RegField('f_DiminishingFactor', @f_DiminishingFactor, TypeInfo(Integer));
  end;
  
  constructor TControl.Create(Top, Left, width, height, halign, valign: integer);
  begin
    inherited Create;
  end;

  procedure TControl.SetRect(l, t, w, h: integer);
  begin
  
  end;
  
  function TControl.AskWidth(dFactor: integer): integer;
  begin

  end;

  function TControl.AskHeight(dFactor: integer): integer;
  begin

  end;


  procedure TControl.Cycle;
  begin

  end;

  procedure TControl.Render;
  begin

  end;

  procedure TControl.OnMouseMove(mx, my: integer);
  begin

  end;

  procedure TControl.OnPress(scancode: integer);
  begin

  end;

  procedure TControl.OnRelease(scancode: integer);
  begin

  end;
  
  function TControl.NumChilds: integer;
  begin
    Result:=0;
  end;
  
  function TControl.GetChild(num: integer): TControl;
  begin
    Result:=nil;
  end;

end.
  
