{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the game world framework class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{$ifdef fpc}
  {$mode delphi}
{$endif}
{$longstrings on}
{$minenumsize 4}

unit mo_game;

interface
uses
  un_typedefs, mo_hub, mo_classes, mo_globopts, mo_indexer;
  
Const
  MaxGameTickTime = 0.1; //10Hz

type
  TGame = class(TTrulyPersistent)
  protected


  public
    ObInd: TIndexer;
    procedure RegisterFields; override;
    procedure AfterLoading; override;
    procedure BeforeSaving; override;
    
    procedure Cycle(TimePassed: float); virtual;
    function Render: boolean; virtual;
    
    procedure OnMouseMove(mx, my: integer); virtual;
    procedure OnPress(scancode: integer); virtual;
    procedure OnRelease(scancode: integer); virtual;
  end;

implementation

  procedure TGame.RegisterFields;
  begin
    RegField('ObjectIndex', @ObInd, TypeInfo(TIndexer));
  end;

  procedure TGame.AfterLoading;
  begin

  end;

  procedure TGame.BeforeSaving;
  begin

  end;
  
  procedure TGame.Cycle(TimePassed: float);
  begin
    if TimePassed > MaxGameTickTime
      then Cycle(TimePassed - MaxGameTickTime);
  end;

  function TGame.Render: boolean;
  begin
    Result:=False;
  end;
  
  procedure TGame.OnMouseMove(mx, my: integer);
  begin
  
  end;
  
  procedure TGame.OnPress(scancode: integer);
  begin

  end;

  procedure TGame.OnRelease(scancode: integer);
  begin

  end;




end.
