{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
 

function type1name.Add(i: typeofit):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure type1name.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container then SafeFree(TObject(a[j]));
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure type1name._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        D[j].Free;
        a[j]:=nil;// pointer(D[j]):=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function type1name._Read(ind: cardinal): typeofit;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
//verboselogA(Self.ClassName + '  %0  %1', [ind, Self.High]);
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=typeofit(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function type1name._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function type1name._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function type1name._ReadLast: typeofit;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= typeofit(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure type1name._Write(ind: cardinal; p: typeofit);
begin

  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure type1name._WriteLast(p: typeofit);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;

procedure type1name.Save();
var
  i: integer;
  v: typeofit;
begin
  WriteInt(Self.Length);
  For i:=0 to Self.High do begin
  {$ifdef cl_objecttype}
    {$ifdef cl_persistentobjectttype}
      WritePersistent((Self[i]) as typeofit);
    {$else}
      if Assigned(Self[i])
        then (Self[i] as typeofit).Save
        else WriteNil;
    {$endif}
  {$else}
    {$ifdef cl_stringtype}
       {$ifdef cl_ansistringtype}
         WriteAnsiString(Self[i]);
       {$else}
         WriteWideString(Self[i]);
       {$endif}
    {$else}
       v:=Self[i];
       WriteBin(@v, SizeOf(v) div SizeOf(integer));
       Assert(((Sizeof(v) div 4) * 4) = Sizeof(v), 'TDyna should be based on types whose size is multiply of 4')
    {$endif}
  {$endif}
  end;
end;

procedure type1name.Load();
var
  i: integer;
  v: typeofit;
begin
  Self.Length:=ReadInt();
  For i:=0 to Self.High do begin
  {$ifdef cl_objecttype}
     {$ifdef cl_persistentobjectttype}
       ReadPersistent(TTrulyPersistent(v));
       Self[i]:= v;
     {$else}
      //TDyna descendant.
       if PeekInt() < 0 then begin
         Self[i]:=nil;
         ReadInt();
       end
         {The Dynas always write their length first.
          Ergo, this value cannot be negative for an existing object.}
       else begin
         Self[i]:= typeofit.Create;
         (Self[i] as typeofit).Load;
       end;
     {$endif}
  {$else}
    {$ifdef cl_stringtype}
       {$ifdef cl_ansistringtype}
         Self[i]:=ReadAnsiString();
       {$else cl_ansistringtype}
         Self[i]:=ReadWideString();
       {$endif cl_ansistringtype}
    {$else}
       ReadBin(@v, SizeOf(v) div sizeof(integer));
       Self[i]:=v;
    {$endif}
  {$endif}
  end;
end;

function type1name._ReadNext: typeofit;
begin
  Assert (CurrentMmb <= Self.High, 'TDyna descendant: reading Next property violated array bondaries.');
  Result:=D[CurrentMmb];
  Inc(CurrentMmb);
end;

function type1name._ReadFirst: typeofit;
begin
  Result:=D[0];
  CurrentMmb:=1;
end;

{$ifndef hasnoproc}
  procedure type1procname (PField: pointer; OP: TFieldOperation); register;
  var
    o: type1name;
  begin
    case op of
      fio_Load: if PeekInt() < 0 then begin
                  pointer(PField^):=nil;
                  ReadInt;
                end
                else begin
                  type1name(PField^):=type1name.Create;
                  type1name(PField^).Load;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then type1name(PField^).Save
                  else WriteNil;
      fio_Skip: if PeekInt() >= 0 then begin
                  o:=type1name.Create; //load it and destroy it. The fate is cruel.
                  o.Load;
                  o.Free;
                end
                else ReadInt;
    end;
  end;
{$endif}
