{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the GUI object classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$include mo_globaldefs.h}

unit mo_controls;

interface
uses
  un_typedefs, mo_hub, mo_classes, mo_globopts, mo_indexer, mo_menu;

implementation

type

  TAbstractMotherHenControl = class(TControl)
  //an abstract base class for controls that have a set of childs.
  protected
    Child: TArrayofTrulyPersistent;
  public
    procedure RegisterFields; override;
    function NumChilds: integer; override;
    function GetChild(num: integer): TControl; override;
  end;

  

  { TVerticalTable }

  TVerticalTable = class (TAbstractMotherHenControl)
  protected
    f_padding,
    f_BorderWidth: integer;
    f_CellSize: TAOI;
  public
    procedure RegisterFields; override;

    procedure SetRect(l, t, w, h: integer); override;
    function AskWidth(dFactor: integer):integer; override;
    function AskHeight(dFactor: integer):integer; override;

    constructor Create(Top, Left, width, height, halign, valign,
                       padding, borderwidth: integer;
                       Children: array of TControl;
                       CellSize: array of integer); virtual;

    procedure Render; override;
  end;
  
  { THorizontalTable }

  THorizontalTable = class (TVerticalTable)
  public
    procedure SetRect(l, t, w, h: integer); override;
    function AskWidth(dFactor: integer):integer; override;
    function AskHeight(dFactor: integer):integer; override;

    constructor Create(Top, Left, width, height, halign, valign,
                       padding, borderwidth: integer;
                       Children: array of TControl;
                       CellSize: array of integer); override;

    procedure Render; override;
  end;

{ THorizontalTable }

procedure THorizontalTable.SetRect(l, t, w, h: integer);
begin
  inherited SetRect(l, t, w, h);
end;

function THorizontalTable.AskWidth(dFactor: integer): integer;
begin
  Result:=inherited AskWidth(dFactor);
end;

function THorizontalTable.AskHeight(dFactor: integer): integer;
begin
  Result:=inherited AskHeight(dFactor);
end;

constructor THorizontalTable.Create(Top, Left, width, height, halign, valign,
  padding, borderwidth: integer; Children: array of TControl;
  CellSize: array of integer);
begin
  inherited Create(Top, Left, width, height, halign, valign, padding,
    borderwidth, Children, CellSize);
end;

procedure THorizontalTable.Render;
begin
  inherited Render;
end;

{ ******************  TVerticalTable  *********************}
  procedure TVerticalTable.RegisterFields;
  begin
    RegField('f_padding', @f_padding, TypeInfo(integer));
    RegField('f_BorderWidth', @f_BorderWidth, TypeInfo(integer));
    RegField('f_CellSize', @f_CellSize, TypeInfo(TAOI));
  end;

  procedure TVerticalTable.SetRect(l, t, w, h: integer);
begin
  inherited SetRect(l, t, w, h);
end;

  function TVerticalTable.AskWidth(dFactor: integer): integer;
begin
  Result:=inherited AskWidth(dFactor);
end;

  function TVerticalTable.AskHeight(dFactor: integer): integer;
begin
  Result:=inherited AskHeight(dFactor);
end;

    constructor TVerticalTable.Create(Top, Left, width, height, halign, valign,
    padding, borderwidth: integer; Children: array of TControl;
    CellSize: array of integer);
  begin

  end;

  procedure TVerticalTable.Render;
begin
  inherited Render;
end;

{ ************** TAbstractMotherHenControl ****************}

  procedure TAbstractMotherHenControl.RegisterFields;
  begin
    RegField('Child', @Child, TypeInfo(TArrayOfTrulyPersistent));
  end;

  function TAbstractMotherHenControl.NumChilds: integer;
  begin
    if Assigned(Child)
      then Result:=Child.Length
      else Result:=0;
  end;

  function TAbstractMotherHenControl.GetChild(num: integer): TControl;
  begin
    Result:=Child[num] as TControl;
  end;


end.
