{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the persistency system essentials.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{$ifndef cge}
  {$include mo_stubs_public.inc}
  {$include mo_cfile_public.inc}
{$endif}

var
  Scenario: array of dword;

  InvalidClassIndex: integer;
  LocalTI: integer;

  //Global variables, formerly fields of classes TRegistrator and TBasket:
  Fields, SaveableFields: TFieldInfos;
  Classes: TAOI;
  NameSpace,
  TypeNameSpace,
  ClassNameSpace: TNameSpace;
  Types: TTypeRegistry;
  Enums: T2DAOI;

  CurrentObject: TArrayOfTrulyPersistent;//TTrulyPersistent;
  CurrentObjectInd: TAOI;
  prevOffset, prevSize, prevname, prevtype: integer;


  B_NameSpace: TNameSpace;
  NameTT,
  NaToT,
  TNames,
  TSizes,
  CNames: TAOI;
  CNums: array of integer; //class indices in the registrator lists.
  EnumIdentic: array of boolean;

  B_Classes: array of CTrulyPersistent;
  B_Fields: TFieldInfos;
  ContName: string;
  CurrentInd: integer;
  Obj: TArrayOfTrulyPersistent;
  MemoryLeakSuspected,
  ThereAreSkippedObjectFields: boolean;
  Container: Pointer;
  B_Enums, EnumConvTable: T2DAOI;
type
  TDwordArray = array[0..$0FFFFFFF] of Dword;
  PDwordArray = ^TDwordArray;
var
  Buffer: PDwordArray;
  BufferSize: integer;
  BufInd: integer;

  NowSaving, NowLoading: boolean; //additional check for out-of-scope calls

  function min(a, b: integer): integer; {$ifdef fpc}inline;{$endif}
  begin
    if a < b then Result:=a else Result:=b;
  end;

  Function SizeToBufferIndex(s: integer): integer; {$ifdef fpc}inline;{$endif}
  begin
    if s > 0 then Result:= 1 + ((s - 1) div SizeOf(integer)) //compiler should optimize it into shr 2
             else Result:= 0;
  end;


  procedure RefillReadBuffer;
  begin
    Buffer:=ReadFromCGEFile(BufferSize);
    if not Assigned(Buffer) or (BufferSize = 0)
      then Die(RuEn('    .'
                  , 'Attempt to read beyond the buffer boundary.'));
    BufferSize:=SizeToBufferIndex(BufferSize);
    BufInd:=0;
  end;

  procedure AllocateWriteBuffer;
  begin
    Buffer:=AllocCGefileWriteBuffer(BufferSize);
    BufferSize:=BufferSize div AlignGranularity;
  end;

  procedure FlushWriteBuffer;
  begin
    WriteToCGEFile(min(BufInd, BufferSize) * AlignGranularity);
    BufInd:=0;
    AllocateWriteBuffer;
  end;

  procedure FlushFilledWriteBuffer; {$ifdef fpc}inline;{$endif}
  begin
    BufInd:=0;
    WriteToCGEFile(BufferSize * AlignGranularity);
    AllocateWriteBuffer;
  end;

  procedure WriteInt(i: integer); {$ifdef fpc}inline;{$endif}
  begin
    if BufInd = BufferSize then FlushFilledWriteBuffer;
    integer(Buffer^[BufInd]):=i;
    inc(BufInd);
  end;

  function ReadInt: integer; {$ifdef fpc}inline;{$endif}
  begin
    if BufInd = BufferSize then RefillReadBuffer;
    Result:=integer(Buffer^[BufInd]);
    inc(BufInd);
  end;

  function PeekInt: integer; {$ifdef fpc}inline;{$endif}
  begin
    if BufInd = BufferSize then RefillReadBuffer;
    Result:=integer(Buffer^[BufInd]);
  end;


  procedure WriteBin(p: pointer; len: integer); {$ifdef fpc}inline;{$endif}
//!!! len is not in bytes byt in 32-bit words!
  var
    z: integer;
  begin
    for z:=0 to len - 1 do begin
      if BufInd = BufferSize then FlushFilledWriteBuffer;
      Buffer^[BufInd]:=integer(p^);
      inc(BufInd);
      {$ifdef fpc}
      inc(p, AlignGranularity);
      {$else}
      // Delphi suxxx (-_-)#
      inc(cardinal(p), AlignGranularity);
      {$endif}
    end;
  end;

  procedure ReadBin(p: pointer; len: integer); {$ifdef fpc}inline;{$endif}
  var
    z: integer;
  begin
    for z:=0 to len - 1 do begin
      if BufInd = BufferSize then RefillReadBuffer;
      dword(p^):=Buffer^[BufInd];
      inc(BufInd);
      {$ifdef fpc}
      inc(p, AlignGranularity);
      {$else}
      inc(cardinal(p), AlignGranularity);
      {$endif}
    end
  end;

  procedure SkipBin(len: integer); {$ifdef fpc}inline;{$endif}
  var
    z: integer;
  begin
    for z:=0 to len - 1 do begin
      if BufInd = BufferSize then RefillReadBuffer;
      inc(BufInd);
    end
  end;

  procedure WriteDword(p: pointer); {$ifdef fpc}inline;{$endif}
  begin
    Assert(BufInd <= BufferSize, 'BufInd > BufferSize');
    if BufInd = BufferSize then FlushFilledWriteBuffer;
    Buffer^[BufInd]:=integer(p^);
    inc(BufInd);
  end;

  procedure ReadDWord(p: pointer); {$ifdef fpc}inline;{$endif}
  begin
    if BufInd = BufferSize then RefillReadBuffer;
    dword(p^):=Buffer^[BufInd];
    inc(BufInd);
  end;

  procedure SkipDword(); {$ifdef fpc}inline;{$endif}
  begin
    if BufInd = BufferSize then RefillReadBuffer;
    inc(BufInd);
  end;

    function AlignedSize(s: integer): integer; {$ifdef fpc}inline;{$endif}
    begin
      Result:=SizeToBufferIndex(s) * SizeOf(integer);
    end;

    function AlignedWideStringSize(s: integer): integer; {$ifdef fpc}inline;{$endif}
    const
      IdW = (SizeOf(integer) div SizeOf(WideChar));
    begin
      Result:=IdW * (1 + ((s - 1) div IdW));
    end;

  procedure SkipWideString; {$ifdef fpc}inline;{$endif}
  begin
    SkipBin(SizeToBufferIndex(AlignedSize(ReadInt() * SizeOf(WideChar))));
  end;

  procedure SkipAnsiString; {$ifdef fpc}inline;{$endif}
  begin
    SkipBin(SizeToBufferIndex(ReadInt()));
  end;

  procedure WriteAnsiString(v: AnsiString); {$ifdef fpc}inline;{$endif}
  var
    z, k: integer;
  begin
    z:=Length(v);
    WriteInt(z);
    if z > 0 then begin
      SetLength(v, AlignedSize(z));
      for k:=z + 1 to Length(v) do v[k]:=#0; //not necessary, but better to clean up, ne?
      WriteBin(@v[1], SizeToBufferIndex(z));
      SetLength(v, z);
    end;
  end;

  procedure WriteWideString(v: WideString); {$ifdef fpc}inline;{$endif}
  begin
    WriteInt(Length(v));
    if Length(v) > 0 then begin
      WriteBin(@v[1], SizeToBufferIndex(Length(v) * SizeOf(WideChar)));
    end;
  end;

  function ReadWideString(): WideString; {$ifdef fpc}inline;{$endif}
  begin
    SetLength(Result, ReadInt());
    if Length(Result) > 0 then ReadBin(@Result[1], SizeToBufferIndex(Length(Result) * SizeOf(WideChar)));
  end;

  function ReadAnsiString(): AnsiString; {$ifdef fpc}inline;{$endif}
  var
    s: integer;
  begin
    s:=ReadInt;
    SetLength(Result, AlignedSize(s));
    if s > 0 then begin
      ReadBin(@Result[1], SizeToBufferIndex(s));
      SetLength(Result, s);
    end;
  end;

  procedure WriteNil; {$ifdef fpc}inline;{$endif}
  begin
   // WriteInt(-1);
    if BufInd = BufferSize then FlushFilledWriteBuffer;
    integer(Buffer^[BufInd]):=-1;
    inc(BufInd);
  end;

  {$ifdef fpc}
    {$include mo_classes_1_freepascal.inc}
  {$else}
    {$include mo_classes_1_delphi.inc}
  {$endif}

{$include mo_basket.inc}

{$include mo_typeprocs.inc}

{$include mo_registrator.inc}

{$include mo_trulypersistent.inc}

{ TTrulyPersistentTester }
procedure TTrulyPersistentTester.RegisterFields;
begin
  RegType('TKikimora', TypeInfo(integer), SizeOf(TKikimora));
  RegField('StubA', @StubA, TypeInfo(string));
  RegField('G', @G, 'TKikimora');
  RegField('StubB', @StubB, TypeInfo(integer));
  RegField('StubC', @StubC, TypeInfo(float));
  //Registrator.RegField('StubB', @StubB, TypeInfo(integer));
 // Registrator.RegType(TypeInfo(TObject), SizeOf(TObject), nil);
 //Registrator.RegField('StubD', @StubD, TypeInfo(TObject));
  RegField('StubD', @StubD, TypeInfo(TTrulyPersistentTester));
  //Registrator.RegField('', @, SizeOf(), TypeInfo(), TypeData());
end;

{ TNameSpace }

function TNameSpace.Ind(s: string): integer;
var
  i: integer;
begin
  s:=UpperCase(s);
  Result:=-1;
  For i:=0 to High do
    if Self[i] = s then begin
      if Alias[i] >= 0 then Result:=Alias[i]
                      else Result:=i;
      Break;
    end;
end;

function TNameSpace.Translate(RegNS: TNameSpace): TAOI;
var
  o: TAOI;
  i: integer;
begin
  o:=TAOI.Create;
  o.Length:=Length;
  For i:=0 to High do begin
    o[i]:=RegNS.Ind(Self[i]);
//VerboseLogA('---NS tran: %0 %1 %2',[i, Self[i], o[i]]);
  end;
  Result:=o;
end;

function TNameSpace.Add(s: string): integer;
var
  i: integer;
begin
  s:=UpperCase(s);
  i:=Ind(s);
  if i >=0 then Result:=Ind(s)
  else begin
    Result:=inherited Add(s);
    SetLength(Alias, Self.Length);
    Alias[Result]:= -1;
  end;
end;

function TNameSpace.Add(s1, s2: string): integer;
var
  i: integer;
begin
  s2:=UpperCase(s2);
  i:=Ind(s1);
  if i >=0 then Result:=Ind(s1)
  else begin
    Add(s2);
    Result:=inherited Add(s1);
    SetLength(Alias, Self.Length);
    Alias[Result]:= Ind(s2);
  end;
end;

  procedure SaveGame(o: TObject; {$ifdef cge}m: TMessageId;{$endif} version: AnsiChar; TargetName: AnsiString);
  begin
    {$ifdef cge}
      AddLog(MI_SAVING, [MsgRaw(m)]);
    {$endif}
    Try
       PrepareToSave(TargetName, version, AnsiString(o.ClassName));
  //     {$include un_bottleneck_start.inc}
       WritePersistent(o as TTrulyPersistent);
  //     {$include un_bottleneck_stop.inc}
       DoneSaving(No, '');
    Except
      Die(MI_ERROR_SAVING, [{$ifdef cge}MsgRaw(m),{$endif} TargetName]);
    End;
    AddLogOk;
  end;

  function LoadGame({$ifdef cge}m: TMessageId;{$endif} SourceName: AnsiString; ClassName: WideString): TObject;
  var t,n: integer;
  begin
   {$ifdef cge}
    AddLog(MI_LOADING, [MsgRaw(m)]);
   {$endif}
    Try
//t:=tick();
       //{$include un_bottleneck_start.inc}
       PrepareToLoad(SourceName, ClassName);
       {$ifdef cge}
       if GetCgeFileSessionId <> GetCurrentSessionId then DeleteUnclaimedTextures;
       {$endif}
       ReadPersistent(TTrulyPersistent(Result));
       n:=NumObjects;
//if VerboseLog then AddLog('Loading %0 objects from the file took %1 ms (%3 ns per object).'#10#13'FileFormat is %2',[n, Tick()-t, 'CGE' + VersionOfLoadedFile, int(1000000.0*((Tick()-t)/n))]);
       DoneLoading;
      //{$include un_bottleneck_stop.inc}
    Except
      Die(MI_ERROR_LOADING, [{$ifdef cge}MsgRaw(m),{$endif} SourceName]);
    End;
    AddLogOk;
  end;

