{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the class tree saving and loading routines.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}



    var
      _grp_ind: integer;
  procedure ReadPersistent(var o: TTrulyPersistent); register;
  //due to recursion, it should put as little on the stack as possible.
  //So no local variables.
  begin
    _grp_ind:=ReadInt();
   {$ifdef safeloading}
    if (_grp_ind > Obj.High) then DieInvalidContainer('Data corrupt: object index out of bounds! (' + IntToStr(_grp_ind) + '/' + IntToStr(Obj.High) + ')');
   {$endif}
    if _grp_ind = 0 then begin
      //index 0 means there is really written a class instance.
      _grp_ind:=ReadInt(); // now it's a class index.
     {$ifdef safeloading}
      if _grp_ind >= Length(Cnums) then DieInvalidContainer('Data corrupt: class index out of bounds!');
     {$endif}
//  {$include un_bottleneck_begin.inc}
  //39%: it's time to optimize the object allocation...
      //create the instance:
      o:=B_Classes[_grp_ind].Generate;

//  {$include un_bottleneck_end.inc}
  //{$include un_bottleneck_begin.inc}
  //12%:
      Obj.Add(o); // *before* the fields are loaded - the nested objects can contain the one we are currently loading
      //load the fields:
  //{$include un_bottleneck_end.inc}
      o.LoadSelf();
    end
    else begin
      if _grp_ind < 0
        then o:=nil // index -1 represents NIL
        else o:=Obj[_grp_ind]; //index > 0 represents an already loaded object
    end;
  end;

  function ReadDyna(): TDyna;
  var
    cn, ind: integer;
    od: TDyna;
    cd: CDyna;
  begin
    ind:=ReadInt(); // now it's a class index.
    if ind < 0 then begin
      Result:=nil;
      Exit;
    end;
   {$ifdef safeloading}
    if ind >= Length(Cnums) then DieInvalidContainer('Data corrupt: class index out of bounds!');
   {$endif}
    cn:=Cnums[ind];
    cd:=CDyna(Types[cn]._class);
    od:=cd.Create;
    od.Load();
    Result:=od;
  end;

var onum: integer = 0;


  procedure WritePersistent(o: TTrulyPersistent);
 {$ifdef safeloading}
  var
    c: integer;
  {$endif}
  begin
//addloga('# %0',[onum]);
    if not Assigned(o) then begin
      WriteNil;
      Exit
    end;
   {$ifdef safeloading}
    if not (o is TTrulyPersistent)
      then Die(MI_ERROR_PROGRAMMER_NO_BAKA
       , ['WritePersistent(): the object is not TTrulyPersistent descendant.'#10#13
       +  '  The type of this hapless instance is "' + AnsiString(o.ClassName) + '"']);
   {$endif}

    if o._BasketIndex > 0 then begin
//addloga('--bi %0',[o._BasketIndex]);
      WriteInt(o._BasketIndex);
      Exit;
    end;

   inc(onum);
  {$ifdef safeloading}
   try
  {$endif}
    WriteInt(0); // index=0 means Object wasn't written before.
   {$ifdef safeloading}
    c:=o.ClassIndex();
    if c = 0 then Die(MI_ERROR_PROGRAMMER_NO_BAKA
     , ['Class "' + AnsiString(o.ClassName) + '" not registered!']);
    WriteInt(c); //class index
   {$else}
    WriteInt(o.ClassIndex());
   {$endif}
    inc(CurrentInd);
    o._BasketIndex:=CurrentInd;
    Obj.Add(o);
    o.SaveSelf();
  {$ifdef safeloading}
   except
     Die('Crashed writing to basket the object #'+IntToStr(onum)+'.'#10#13+(ExceptObject as Exception).Message);
   end;
  {$endif}
  end;
  
  procedure WriteDyna(o: TDyna);
  begin
    if Assigned(o)
      then begin
       {$ifdef safeloading}
        if not (o is TDyna)
          then Die(MI_ERROR_PROGRAMMER_NO_BAKA
           , ['WriteDyna(): the object is not a TDyna descendant.'#10#13
           +  '  The type of this hapless instance is "' + AnsiString(o.ClassName) + '"']);
       {$endif}
        WriteInt(ClassIndex(o.ClassType));
        o.Save()
      end
      else WriteNil;
  end;

  procedure LogWarnings();
  var
    i: integer;
    w: WideString;
  begin
    w:='';
    For i:=0 to BasketWarnings.High do begin
      w:=w + BasketWarnings[i];
      if i < BasketWarnings.High
        then w:=w + #10#13
    end;
    AddLog(MI_BASKET_NOT_EVERYTHING_IS_FINE_AND_DANDY, [w]);
  end;

  procedure PrepareToSave(TargetName: AnsiString; version: AnsiChar; Signature: WideString);//constructor CreateForSave
  var
    i: integer;
  begin
    NowSaving:=Yes;
    Obj:=TArrayOfTrulyPersistent.Create;
    CurrentInd:=0;
    ContName:=TargetName;
    BufInd:=0;
    OpenCGEFileForWrite(PAnsiChar(TargetName), version);

    AllocateWriteBuffer;

    Try
    // 1 Signature (wide string)
      WriteWideString(Signature);
    // 2 Enumerated type infos
      Enums.Save();
    // 3 Type names - for type sizes check
      With Types do begin
        WriteInt(Length);
        For i:=0 to High do WriteInt(D[i].name);
      end;
    // 4 Type sizes - see above
      With Types do begin
        WriteInt(Length);
        For i:=0 to High do WriteInt(D[i].Size);
      end;
    // 5 Class names
      With Classes do begin
        WriteInt(Length);
        For i:=0 to High do WriteInt(Types[D[i]].Name);
      end;
    // 6 Field lists (per class) - name/type only,
    //            , offset and "skippiness" are stored but not used.
      Fields.Save;
  //    SaveableFields.SaveToBasket(Self);
    // 7 Name space
      NameSpace.Save();
      if VerboseLog then AddLog('Types information added to savegame.');

      SetLength(Scenario, 0);
      For i:=0 to Classes.High do
        Types[Classes[i]]._class.BuildSavingScenario();

      if VerboseLog then AddLog('Saving scenarios built.');
    // 8 ....
  //VerboseLogA('Basket ready.', []);

    Except
      Die(
         RuEn('     '
            , 'Crashed while preparing data for saving.'));
    End;
  end;

  procedure PrepareToLoad(SourceName: AnsiString; Signature: WideString);//constructor CreateForLoad
  var
    j, s: integer;
    cc: pointer;
    w: WideString;
    CL: CTrulyPersistent;
  begin
    NowLoading:=Yes;
    MemoryLeakSuspected:=No;
    Obj:=TArrayOfTrulyPersistent.Create;
    Obj.Length:=1;

    OpenCGEFileForRead(PAnsiChar(SourceName), VersionOfLoadedFile);
    RefillReadBuffer;
    ContName:=SourceName;

    Try
  // 1 Signature (wide string)
      w:=ReadWideString();
      if (w <> Signature) then Die(RuEn('  .', 'Signature mismatch.'));
  // 2 Enumerated types (does not necessary have the same length as types array!)
      B_Enums:=T2DAOI.Create;
      B_Enums.Load();
  // 3 Type names - for type sizes check
      TNames:=TAOI.Create;
      TNames.Load();
  // 4 Type sizes - see above
      TSizes:=TAOI.Create;
      TSizes.Load();
  // 5 Class names
      CNames:=TAOI.Create;
      CNames.Load();
  // 6 Field lists (per class) - name/type only,
  //            , offset and "skippiness" are stored but not used.
      B_Fields:= TFieldInfos.Create;
      B_Fields.Load();
  // 7 Name space
      B_NameSpace:=TNameSpace.Create;
      B_NameSpace.Load();
      NameTT:=B_NameSpace.Translate(NameSpace);

      Parse;
      if VerboseLog then AddLog('Parsing OK.');

      //Filling the required per-class forms
      //  for all the classes known to basket:
      SetLength(Scenario, 0);
      SetLength(B_Classes, Length(Cnums));
      For j:=0 to Length(Cnums) - 1 do begin
        CL:=Types[Classes[Cnums[j]]]._class;
        CL.SetLocalFieldsList(B_Fields[j]); //.
        CL.SetLocalClassIndex(j);
        CL.BuildLoadingScenario();
        B_Classes[j]:=Types[Classes[Cnums[j]]]._class
      end;
      if VerboseLog then AddLog('Loading scenarios built.');
      if BasketWarnings.Length > 0 then LogWarnings();
      
    Except
      Die(
         RuEn('     ',
              'Crashed while preparing data for loading.'));
    End;
  end;


  procedure DoneSaving(FlushToFile: boolean; FileName: AnsiString);//destructor Finish;
  var
    i: integer;
  begin
    FlushWriteBuffer;
    CloseCgeFile(FlushToFile, PAnsiChar(FileName));

    //Cleanup indices
    For i:=0 to Obj.High do Obj[i]._BasketIndex:=0;
    Obj.Container:=No;
    Obj.Free;
    NowSaving:=No;
  end;
  
  procedure DoneLoading();//destructor Finish;
  var
    i: integer;
  begin
    CloseCgeFile(No,nil);
    
    SetLength(CNums, 0);
    Cnames.Free;
    TNames.Free;
    B_Fields.Free;
    TSizes.Free;
    B_NameSpace.Free;
    NameTT.Free;
    NaToT.Free;
    B_Enums.Free;
    EnumConvTable.Free;
    
    NowLoading:=No;

    if MemoryLeakSuspected then begin
// *******************************************************************
// ***** SAVE TO A TEMPORARY CONTAINER, DESTROY ALL OBJECTS, LOAD BACK.
AddLog(RuEn('!   !   !',
            'DAI HEN! PROBABLE MEMORY LEAK DETECTED! BYPASS NOT IMPLEMENTED YET!'));
    end;

    //Notify objects that they were loaded
//{$include un_bottleneck_begin.inc}
//04%
    For i:=1 to Obj.High do Obj[i].AfterLoading;
//{$include un_bottleneck_end.inc}

    Obj.Container:=No;
    Obj.Free;
  end;

  procedure DieInvalidContainer(nng: string);
  //Error that should not happen, so only the English technical messages.
  begin
    if nng > '' then nng:=#10#13 + nng;
    Die(MI_BASKET_FAIL_LOAD,
      [{'Invalid container "' + ContName
      + '" (Size ' + IntToStr(GetContainerSize(PChar(ContName)))
      + ', pointer ' + IntToHex(cardinal(GetContainer(PChar(ContName))), 8) + 'h)' +}
      nng]);
  end;
  
  procedure DieDataCorrupt(em: string);
  begin
    DieInvalidContainer(RuEn(' : ', 'Data corrupt: ') + em);
  end;

  procedure DieIncompatible(M: TMessageId; Param: array of const);
  //Error that *could* happen (quite likely, at that),
  //  so we need to explain it in an civilized manner. Russian fully supported.
  var w: WideString;
  begin
    w:=MsgFormat(M, Param) + #10#13
      + MsgFormat(MI_BASKET_EXPLAIN_UNKNOWN, []);
    Die(MI_BASKET_FAIL_LOAD, [w]);
  end;

  procedure Parse();
  var
    i, j, k, l, g, c, f, v, gt: integer;
    b: boolean;
    FI: TFieldInfo;
    CL: CTrulyPersistent;
    function ChCn(n1: integer): integer;
    begin
      if (n1 < 0) or (n1 > NameTT.High) then DieDataCorrupt('Name index out of bounds.');
      Result:=NameTT[n1];
    end;
  begin
    if B_Fields.Length <> CNames.Length then DieDataCorrupt('B_Fields.Length <> CNames.Length');
    if TNames.Length <> TSizes.Length then DieDataCorrupt('TNames.Length <> TSizes.Length');

    // Checking if all classes are known
    SetLength(CNums, CNames.Length);
    For i:=0 to CNames.High do begin
      c:=ChCn(Cnames[i]);
      if c < 0 then
        DieIncompatible (MI_BASKET_UNKNOWN_CLASS, [B_NameSpace[Cnames[i]]]);

      //also match the local class indices with the registerator lists
      For j:=0 to Classes.High do
        if c = Types[Classes[j]].Name then begin
          CNums[i]:=j;
          Break;
        end;
    end;

    // Checking if all types are known
    For i:=0 to TNames.High do
      if ChCn(Tnames[i]) < 0 then
        DieIncompatible (MI_BASKET_UNKNOWN_TYPE, [B_NameSpace[Tnames[i]]]);

    //Building the local name to registrator type index translation table
    NaToT:=TAOI.Create;
    NaToT.Length:=B_NameSpace.Length;
    For i:=0 to NaToT.High do begin
      For j:=0 to Types.High do
        if NameTT[i] = Types[j].Name then begin
          NaToT[i]:=j;
        end;
    end;

    // Checking if all type sizes match
    For i:=0 to TSizes.High do
      if TSizes[i] <> Types[NaToT[Tnames[i]]].Size then
        DieIncompatible (MI_BASKET_TYPE_SIZE_MISMATCH,
          [B_NameSpace[Tnames[i]]
          ,Types[NaToT[Tnames[i]]].Size
          ,TSizes[i]]);

    // Checking for unknown fields, fields of wrong types, etc.
    if Assigned (BasketWarnings) then BasketWarnings.Free;
    BasketWarnings:=TAOW.Create;

    For j:=0 to B_Fields.High do begin
      //for each class
      c:=CNums[j];
      l:=0;
      g:=0;
      //Matching the list and checking for extra/wrong type fields
      For l :=0 to B_Fields[j].High do begin
        f:=-1;
        FI:=B_Fields[j][l];

        //finding the field with the same name in the registrator list:
        For g:=0 to Fields[c].High do
          if NameTT[FI.Name] = Fields[c][g].Name
          then begin
            f:=g;
            Break;
          end;

        FI.RFind:=f; //where -1 means there is no such field.


        //Translating type index:
        For i:=0 to Types.High do
          if Types[i].Name = NameTT[TNames[FI.Tind]] then begin//TNames[FI.Tind]] then begin
            FI.Tind:=i;
            Break;
          end;

        if (f >= 0) and (Fields[c][f].Tind <> FI.Tind)
        //type has changed
        then begin
          FI.RFind:=-1; //skip: types mismatch.
// ****************************************************************************
//ToDo: allow replacing object fields with descendant types for backward compatibility.

          if Types[FI.Tind].Kind in [fk_Class, fk_Dyna]
            then Die(MI_BASKET_UNKNOWN_OBJECT_FIELD,  //.   .
              [ClassNameSpace[c]
              ,B_NameSpace[FI.Name]
              ,NameSpace[Types[FI.Tind].Name]])
            else BasketWarnings.Add(MsgFormat(MI_BASKET_WRONG_FIELD_TYPE,
              [ClassNameSpace[c]
              ,B_NameSpace[FI.Name]
              ,NameSpace[Types[FI.TInd].Name]
              ,NameSpace[Types[Fields[c][f].Tind].Name]]));
        end
        else
          if f < 0 then BasketWarnings.Add(MsgFormat(MI_BASKET_UNKNOWN_FIELD,
            [ClassNameSpace[c]
            ,B_NameSpace[FI.Name]
            ,NameSpace[Types[FI.Tind].Name]]));

        B_Fields[j][l]:=FI;
      end;

      //Checking for missing fields (warning only):
      For g:=0 to Fields[c].High do begin
        if Fields[c][g].Skip then Continue;
        //Note: if the field status was changed to skipped
        //  but it is stored in the savegame, it will be
        //  loaded anyway. "Skip" flag affects only the saving process.
        
        //Otherwise, if the field was changed from skipped to non-skipped,
        //  the parser will give a warning about a missing field.
        b:=No;
        For l :=0 to B_Fields[j].High do begin
          if Fields[c][g].Name = NameTT[B_Fields[j][l].Name] then begin
            if not B_Fields[j][l].Skip then b:=Yes;
            Break;
          end;
        end;
        if not b then BasketWarnings.Add(MsgFormat(MI_BASKET_MISSING_FIELD,
          [ClassNameSpace[c]
          ,NameSpace[Fields[c][g].Name]
          ,NameSpace[Types[Fields[c][g].Tind].Name]]));
      end;
    end;

    //Building the enumerated types conversion table (again, warnings only)
    //Initially Enum[][] contains the names (in local space) by ordinals.
    //We need it to contain new ordinals by old ordinals.
    
    //*ADDED: also check if the types are identic
    if Length(EnumIdentic) <> Types.Length
      then SetLength(EnumIdentic, Types.Length);

    EnumConvTable:=T2DAOI.Create;
    EnumConvTable.Length:=Types.Length;

    For i:=0 to TNames.High do begin
      gt:=NaToT[TNames[i]];
      if Types[gt].Kind <> fk_enum then Continue;
      if B_Enums.High < i then DieDataCorrupt('Enumerated types table is too short.');
      EnumIdentic[gt]:=(Enums[gt].High = B_Enums[i].High);
      EnumConvTable[gt].Length:=B_Enums[i].Length;
      With B_Enums[i] do begin
        For j:=0 to High do begin
          v:= -1;
          For k:=0 to Enums[gt].High do
            if NameTT[D[j]] = Enums[gt][k] then begin
              v:=k;
              Break;
            end;
          if v < 0 then begin
            v:=0;
            BasketWarnings.Add(MsgFormat(MI_BASKET_UNKNOWN_ENUM,
              [NameSpace[Types[gt].Name]
              ,B_NameSpace[D[j]]
              ,NameSpace[Enums[gt][0]]]));
          end;
          EnumConvTable[gt][j]:= v;
          EnumIdentic[gt]:=EnumIdentic[gt] and (v = j);
        End;
      end;
      if not EnumIdentic[gt]
        then BasketWarnings.Add(
               MsgFormat(MI_BASKET_ENUM_CHANGED, [NameSpace[Types[gt].Name]]));

    end;
  end;
  
  

 (* procedure SaveEnum(ti: integer; p: pointer);
  begin
    //Just save the ordinal value in the form of an integer.
    Case Types[ti].Data^.OrdType of
      otSByte: WriteInt(shortint(p^));
      otUByte: WriteInt(byte(p^));
      otSWord: WriteInt(smallint(p^));
      otUWord: WriteInt(word(p^));
      otSLong: WriteInt(longint(p^));
      otULong: WriteInt(dword(p^));
    end;
  end;
  *)
  
  function NumObjects: integer;
  begin
    Result:=Obj.High;
  end;
  

  procedure LoadEnum(tyi: integer; p: pointer);
  begin
    dword(p^):=EnumConvTable[tyi][ReadInt()];
(*  Now enums with size < 4 bytes are not allowed.
    Case Types[ti].Data^.OrdType of
      otSByte: shortint(p^):=
      otUByte: byte(p^):=B_Enums[ti][ReadInt()];
      otSWord: smallint(p^):=B_Enums[ti][ReadInt()];
      otUWord: word(p^):=B_Enums[ti][ReadInt()];
      otSLong: longint(p^):=B_Enums[ti][ReadInt()];
      otULong: dword(p^):=B_Enums[ti][ReadInt()];
    end;*)
  end;

