{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains  the main window class headers.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


Type
  TCGEWindow = class (TCLWindow)
  public
    // put your code for setting OpenGL rendering mode defaults here,
    // not in OnCreate - because, as I said above, OpenGL may be reloaded
    // between the OnIdle calls. If such happens, OnGetFocus will be called.
    // OnGetFocus is always called at least once, at startup
    procedure OnGetFocus; OVERRIDE;
    
    // always called before shutdown (use WindowExists to check if window
    // still exists at that time)
    procedure OnLoseFocus; OVERRIDE;

    // it's called one per every system mouse movement message.
    // use MouseX and MouseY to obtain coordinates.
    procedure OnMouseMove; OVERRIDE;

    // it's called once at startup, and everytime the window unwraps
    // from the minimized state (even if fullscren mode is used)
    // and each time when window's size was changed.
    // Use DisplayWidth and DisplayHeight to obtain window size.
    procedure OnResize; OVERRIDE;

    // mouse buttons are considered as keys with negative scancodes:
    // -1 - left button, -2 - right one, -3 - middle.
    // mouse wheel is considered as two keys: up (-4) and down (-5).
    // they do receive only OnPress, and Pressed for them is always false.
    //
    //this structure was choosen for sake of simplicity of key binding
    // in the game engine. It also coresponds to the mouse button / wheel
    // numbering in X. But scancodes are in MS-DOS format ("Esc" = 1, and so on)
    procedure OnPress(scancode: integer); OVERRIDE;
    procedure OnRelease(scancode: integer); OVERRIDE;
    
    // if the TextInput property is set to True, and the pressed keys
    // represent a valid character, then OnType will be called instead
    // of OnPress.
    procedure OnType(input: WideChar);  OVERRIDE;

    // called once at startup, after window created and OpenGL initialized.
    procedure OnCreate; OVERRIDE;

    // it's called once, at shutdown.
    // GUARANTEED - regardles of the way the window was closed.
    // Check the WindowExists property to determine if window sill exists
    //  or it was already destroyed.
    procedure OnDestroy; OVERRIDE;

    // Main cyclic method. Called repeatedly, unless there is anything else to do
    procedure OnIdle; OVERRIDE;
    
    destructor Destroy; override;
  protected
    function IsHotkey(scancode: integer; HK: array of integer): boolean;
  end;

var
  TheWindow: TCLWindow;

