{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the routine for detection of the previous 
      application instances.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


unit cl_pms;

{$ifdef fpc}
  {$mode delphi}
{$endif}

interface

uses
  SysUtils {$ifdef win32}, Windows{$endif};

  function ThisIsAnOnlyInstance: boolean;

implementation

{$ifdef win32}

  var
    M: THandle;
    Di: boolean = false;

  function ThisIsAnOnlyInstance: boolean;
  var N: string;
  begin
    Result:=True;
    N:='SingleInstancEMutex' + ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    M:=OpenMutex(MUTEX_MODIFY_STATE, False, PChar(N));
    if M = 0 then M:=CreateMutex(nil, True, PChar(N))
    else begin
      if WaitForSingleObject(M, 0) <> WAIT_ABANDONED
        then Result:=False;
    end;
    Di:=Result;
  end;

{$else}

  function ThisIsAnOnlyInstance: boolean;
  begin
    Result:=True;
  end;
{$endif}

initialization
finalization
{$ifdef win32}
  Try
    if Di then ReleaseMutex(M);
  Except End;
{$else}

{$endif}
end.

